/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes;

import appeng.api.AEApi;
import appeng.api.definitions.IDefinitions;
import appeng.api.definitions.IItems;
import appeng.api.definitions.IParts;
import appeng.api.recipes.ISubItemResolver;
import appeng.api.recipes.ResolverResult;
import appeng.api.recipes.ResolverResultSet;
import appeng.api.util.AEColor;
import appeng.api.util.AEColoredItemDefinition;
import appeng.items.materials.ItemMaterial;
import appeng.items.materials.MaterialType;
import appeng.items.misc.ItemCrystalSeed;
import appeng.items.parts.ItemPart;
import appeng.items.parts.PartType;
import net.minecraft.item.ItemStack;

public class AEItemResolver
implements ISubItemResolver {
    @Override
    public Object resolveItemByName(String nameSpace, String itemName) {
        if (nameSpace.equals("appliedenergistics2")) {
            String partName;
            PartType pt;
            int dVal;
            String materialName;
            MaterialType mt;
            IDefinitions definitions = AEApi.instance().definitions();
            IItems items = definitions.items();
            IParts parts = definitions.parts();
            if (itemName.startsWith("paint_ball.")) {
                return this.paintBall(items.coloredPaintBall(), itemName.substring(itemName.indexOf(46) + 1), false);
            }
            if (itemName.startsWith("lumen_paint_ball.")) {
                return this.paintBall(items.coloredPaintBall(), itemName.substring(itemName.indexOf(46) + 1), true);
            }
            if (itemName.equals("cable_glass")) {
                return new ResolverResultSet("cable_glass", parts.cableGlass().allStacks(1));
            }
            if (itemName.startsWith("cable_glass.")) {
                return this.cableItem(parts.cableGlass(), itemName.substring(itemName.indexOf(46) + 1));
            }
            if (itemName.equals("cable_covered")) {
                return new ResolverResultSet("cable_covered", parts.cableCovered().allStacks(1));
            }
            if (itemName.startsWith("cable_covered.")) {
                return this.cableItem(parts.cableCovered(), itemName.substring(itemName.indexOf(46) + 1));
            }
            if (itemName.equals("cable_smart")) {
                return new ResolverResultSet("cable_smart", parts.cableSmart().allStacks(1));
            }
            if (itemName.startsWith("cable_smart.")) {
                return this.cableItem(parts.cableSmart(), itemName.substring(itemName.indexOf(46) + 1));
            }
            if (itemName.equals("cable_dense")) {
                return new ResolverResultSet("cable_dense", parts.cableDense().allStacks(1));
            }
            if (itemName.startsWith("cable_dense.")) {
                return this.cableItem(parts.cableDense(), itemName.substring(itemName.indexOf(46) + 1));
            }
            if (itemName.startsWith("crystal_seed.")) {
                if (itemName.equalsIgnoreCase("crystal_seed.certus")) {
                    return ItemCrystalSeed.getResolver(0);
                }
                if (itemName.equalsIgnoreCase("crystal_seed.nether")) {
                    return ItemCrystalSeed.getResolver(600);
                }
                if (itemName.equalsIgnoreCase("crystal_seed.fluix")) {
                    return ItemCrystalSeed.getResolver(1200);
                }
                return null;
            }
            if (itemName.startsWith("material.") && (mt = MaterialType.valueOf(materialName = itemName.substring(itemName.indexOf(46) + 1))).getItemInstance() == ItemMaterial.instance && mt.getDamageValue() >= 0 && mt.isRegistered()) {
                return new ResolverResult("material", mt.getDamageValue());
            }
            if (itemName.startsWith("part.") && (dVal = ItemPart.instance.getDamageByType(pt = PartType.valueOf(partName = itemName.substring(itemName.indexOf(46) + 1)))) >= 0) {
                return new ResolverResult("part", dVal);
            }
        }
        return null;
    }

    private Object paintBall(AEColoredItemDefinition partType, String substring, boolean lumen) {
        AEColor col;
        try {
            col = AEColor.valueOf(substring.toUpperCase());
        }
        catch (Throwable t) {
            col = AEColor.TRANSPARENT;
        }
        if (col == AEColor.TRANSPARENT) {
            return null;
        }
        ItemStack is = partType.stack(col, 1);
        return new ResolverResult("paint_ball", (lumen ? 20 : 0) + is.func_77952_i());
    }

    private Object cableItem(AEColoredItemDefinition partType, String substring) {
        AEColor col;
        try {
            col = AEColor.valueOf(substring.toUpperCase());
        }
        catch (Throwable t) {
            col = AEColor.TRANSPARENT;
        }
        ItemStack is = partType.stack(col, 1);
        return new ResolverResult("part", is.func_77952_i());
    }
}

