/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.layers;

import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.LayerBase;
import appeng.api.parts.LayerFlags;
import appeng.util.Platform;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class LayerIEnergySource
extends LayerBase
implements IEnergySource {
    private TileEntity getEnergySourceTile() {
        IPartHost host = (IPartHost)((Object)this);
        return host.getTile();
    }

    private World getEnergySourceWorld() {
        if (this.getEnergySourceTile() == null) {
            return null;
        }
        return this.getEnergySourceTile().func_145831_w();
    }

    private boolean isTileValid() {
        TileEntity te = this.getEnergySourceTile();
        return te != null && !te.func_145837_r();
    }

    private void addToENet() {
        if (this.getEnergySourceWorld() == null) {
            return;
        }
        this.removeFromENet();
        if (!this.isInIC2() && Platform.isServer() && this.isTileValid()) {
            this.getLayerFlags().add(LayerFlags.IC2_ENET);
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this.getEnergySourceTile()));
        }
    }

    private void removeFromENet() {
        if (this.getEnergySourceWorld() == null) {
            return;
        }
        if (this.isInIC2() && Platform.isServer()) {
            this.getLayerFlags().remove((Object)LayerFlags.IC2_ENET);
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this.getEnergySourceTile()));
        }
    }

    private boolean interestedInIC2() {
        if (!((IPartHost)((Object)this)).isInWorld()) {
            return false;
        }
        int interested = 0;
        for (EnumFacing dir : EnumFacing.values()) {
            IPart part = this.getPart(dir);
            if (!(part instanceof IEnergyTile)) continue;
            ++interested;
        }
        return interested == 1;
    }

    @Override
    public void partChanged() {
        super.partChanged();
        if (this.interestedInIC2()) {
            this.addToENet();
        } else {
            this.removeFromENet();
        }
    }

    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing direction) {
        if (!this.isInIC2()) {
            return false;
        }
        IPart part = this.getPart(direction);
        if (part instanceof IEnergyEmitter) {
            return ((IEnergyEmitter)part).emitsEnergyTo(receiver, direction);
        }
        return false;
    }

    private boolean isInIC2() {
        return this.getLayerFlags().contains((Object)LayerFlags.IC2_ENET);
    }

    public double getOfferedEnergy() {
        if (!this.isInIC2()) {
            return 0.0;
        }
        for (EnumFacing dir : EnumFacing.values()) {
            IPart part = this.getPart(dir);
            if (!(part instanceof IEnergySource)) continue;
            return ((IEnergySource)part).getOfferedEnergy();
        }
        return 0.0;
    }

    public void drawEnergy(double amount) {
        for (EnumFacing dir : EnumFacing.values()) {
            IPart part = this.getPart(dir);
            if (!(part instanceof IEnergySource)) continue;
            ((IEnergySource)part).drawEnergy(amount);
            return;
        }
    }

    public int getSourceTier() {
        for (EnumFacing dir : EnumFacing.values()) {
            IPart part = this.getPart(dir);
            if (!(part instanceof IEnergySource)) continue;
            return ((IEnergySource)part).getSourceTier();
        }
        return 0;
    }
}

