/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts;

import appeng.api.AEApi;
import appeng.api.config.YesNo;
import appeng.api.exceptions.FailedConnection;
import appeng.api.implementations.parts.IPartCable;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.parts.IFacadeContainer;
import appeng.api.parts.IFacadePart;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartItem;
import appeng.api.parts.LayerFlags;
import appeng.api.parts.PartItemStack;
import appeng.api.parts.SelectedPart;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.client.render.cablebus.CableBusRenderState;
import appeng.client.render.cablebus.CableCoreType;
import appeng.client.render.cablebus.FacadeRenderState;
import appeng.core.AELog;
import appeng.facade.FacadeContainer;
import appeng.helpers.AEMultiTile;
import appeng.me.GridConnection;
import appeng.parts.BusCollisionHelper;
import appeng.parts.CableBusStorage;
import appeng.parts.ICableBusContainer;
import appeng.parts.PartPlacement;
import appeng.parts.networking.PartCable;
import appeng.util.Platform;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class CableBusContainer
extends CableBusStorage
implements AEMultiTile,
ICableBusContainer {
    private static final ThreadLocal<Boolean> IS_LOADING = new ThreadLocal();
    private final EnumSet<LayerFlags> myLayerFlags = EnumSet.noneOf(LayerFlags.class);
    private YesNo hasRedstone = YesNo.UNDECIDED;
    private IPartHost tcb;
    private boolean requiresDynamicRender = false;
    private boolean inWorld = false;

    public CableBusContainer(IPartHost host) {
        this.tcb = host;
    }

    public static boolean isLoading() {
        Boolean is = IS_LOADING.get();
        return is != null && is != false;
    }

    public void setHost(IPartHost host) {
        this.tcb.clearContainer();
        this.tcb = host;
    }

    public void rotateLeft() {
        IPart[] newSides = new IPart[6];
        newSides[AEPartLocation.UP.ordinal()] = this.getSide(AEPartLocation.UP);
        newSides[AEPartLocation.DOWN.ordinal()] = this.getSide(AEPartLocation.DOWN);
        newSides[AEPartLocation.EAST.ordinal()] = this.getSide(AEPartLocation.NORTH);
        newSides[AEPartLocation.SOUTH.ordinal()] = this.getSide(AEPartLocation.EAST);
        newSides[AEPartLocation.WEST.ordinal()] = this.getSide(AEPartLocation.SOUTH);
        newSides[AEPartLocation.NORTH.ordinal()] = this.getSide(AEPartLocation.WEST);
        for (AEPartLocation dir : AEPartLocation.SIDE_LOCATIONS) {
            this.setSide(dir, newSides[dir.ordinal()]);
        }
        this.getFacadeContainer().rotateLeft();
    }

    @Override
    public IFacadeContainer getFacadeContainer() {
        return new FacadeContainer(this);
    }

    @Override
    public boolean canAddPart(ItemStack is, AEPartLocation side) {
        if (PartPlacement.isFacade(is, side) != null) {
            return true;
        }
        if (is.func_77973_b() instanceof IPartItem) {
            IPartItem bi = (IPartItem)is.func_77973_b();
            is = is.func_77946_l();
            is.field_77994_a = 1;
            Object bp = bi.createPartFromItemStack(is);
            if (bp != null) {
                if (bp instanceof IPartCable) {
                    boolean canPlace = true;
                    for (AEPartLocation d : AEPartLocation.SIDE_LOCATIONS) {
                        if (this.getPart(d) == null || this.getPart(d).canBePlacedOn(((IPartCable)bp).supportsBuses())) continue;
                        canPlace = false;
                    }
                    if (!canPlace) {
                        return false;
                    }
                    return this.getPart(AEPartLocation.INTERNAL) == null;
                }
                if (!(bp instanceof IPartCable) && side != AEPartLocation.INTERNAL) {
                    IPart cable = this.getPart(AEPartLocation.INTERNAL);
                    if (cable != null && !bp.canBePlacedOn(((IPartCable)cable).supportsBuses())) {
                        return false;
                    }
                    return this.getPart(side) == null;
                }
            }
        }
        return false;
    }

    @Override
    public AEPartLocation addPart(ItemStack is, AEPartLocation side, @Nullable EntityPlayer player, @Nullable EnumHand hand) {
        if (this.canAddPart(is, side) && is.func_77973_b() instanceof IPartItem) {
            IPartItem bi = (IPartItem)is.func_77973_b();
            is = is.func_77946_l();
            is.field_77994_a = 1;
            Object bp = bi.createPartFromItemStack(is);
            if (bp instanceof IPartCable) {
                IGridNode cn;
                boolean canPlace = true;
                for (AEPartLocation d : AEPartLocation.SIDE_LOCATIONS) {
                    if (this.getPart(d) == null || this.getPart(d).canBePlacedOn(((IPartCable)bp).supportsBuses())) continue;
                    canPlace = false;
                }
                if (!canPlace) {
                    return null;
                }
                if (this.getPart(AEPartLocation.INTERNAL) != null) {
                    return null;
                }
                this.setCenter((IPartCable)bp);
                bp.setPartHostInfo(AEPartLocation.INTERNAL, this, this.tcb.getTile());
                if (player != null) {
                    bp.onPlacement(player, hand, is, side);
                }
                if (this.inWorld) {
                    bp.addToWorld();
                }
                if ((cn = this.getCenter().getGridNode()) != null) {
                    for (AEPartLocation ins : AEPartLocation.SIDE_LOCATIONS) {
                        IGridNode sn;
                        IPart sbp = this.getPart(ins);
                        if (sbp == null || (sn = sbp.getGridNode()) == null) continue;
                        try {
                            new GridConnection(cn, sn, AEPartLocation.INTERNAL);
                        }
                        catch (FailedConnection e) {
                            bp.removeFromWorld();
                            this.setCenter(null);
                            return null;
                        }
                    }
                }
                this.updateConnections();
                this.markForUpdate();
                this.markForSave();
                this.partChanged();
                return AEPartLocation.INTERNAL;
            }
            if (bp != null && !(bp instanceof IPartCable) && side != AEPartLocation.INTERNAL) {
                IPart cable = this.getPart(AEPartLocation.INTERNAL);
                if (cable != null && !bp.canBePlacedOn(((IPartCable)cable).supportsBuses())) {
                    return null;
                }
                this.setSide(side, (IPart)bp);
                bp.setPartHostInfo(side, this, this.getTile());
                if (player != null) {
                    bp.onPlacement(player, hand, is, side);
                }
                if (this.inWorld) {
                    bp.addToWorld();
                }
                if (this.getCenter() != null) {
                    IGridNode cn = this.getCenter().getGridNode();
                    IGridNode sn = bp.getGridNode();
                    if (cn != null && sn != null) {
                        try {
                            new GridConnection(cn, sn, AEPartLocation.INTERNAL);
                        }
                        catch (FailedConnection e) {
                            bp.removeFromWorld();
                            this.setSide(side, null);
                            return null;
                        }
                    }
                }
                this.updateDynamicRender();
                this.updateConnections();
                this.markForUpdate();
                this.markForSave();
                this.partChanged();
                return side;
            }
        }
        return null;
    }

    @Override
    public IPart getPart(AEPartLocation partLocation) {
        if (partLocation == AEPartLocation.INTERNAL) {
            return this.getCenter();
        }
        return this.getSide(partLocation);
    }

    @Override
    public IPart getPart(EnumFacing side) {
        return this.getSide(AEPartLocation.fromFacing(side));
    }

    @Override
    public void removePart(AEPartLocation side, boolean suppressUpdate) {
        if (side == AEPartLocation.INTERNAL) {
            if (this.getCenter() != null) {
                this.getCenter().removeFromWorld();
            }
            this.setCenter(null);
        } else {
            if (this.getSide(side) != null) {
                this.getSide(side).removeFromWorld();
            }
            this.setSide(side, null);
        }
        if (!suppressUpdate) {
            this.updateDynamicRender();
            this.updateConnections();
            this.markForUpdate();
            this.markForSave();
            this.partChanged();
        }
    }

    @Override
    public void markForUpdate() {
        this.tcb.markForUpdate();
    }

    @Override
    public DimensionalCoord getLocation() {
        return this.tcb.getLocation();
    }

    @Override
    public TileEntity getTile() {
        return this.tcb.getTile();
    }

    @Override
    public AEColor getColor() {
        if (this.getCenter() != null) {
            IPartCable c = this.getCenter();
            return c.getCableColor();
        }
        return AEColor.TRANSPARENT;
    }

    @Override
    public void clearContainer() {
        throw new UnsupportedOperationException("Now that is silly!");
    }

    @Override
    public boolean isBlocked(EnumFacing side) {
        return this.tcb.isBlocked(side);
    }

    @Override
    public SelectedPart selectPart(Vec3d pos) {
        for (AEPartLocation side : AEPartLocation.values()) {
            IPart p = this.getPart(side);
            if (p == null) continue;
            LinkedList<AxisAlignedBB> boxes = new LinkedList<AxisAlignedBB>();
            BusCollisionHelper bch = new BusCollisionHelper(boxes, side, null, true);
            p.getBoxes(bch);
            for (AxisAlignedBB bb : boxes) {
                if (!(bb = bb.func_72314_b(0.002, 0.002, 0.002)).func_72318_a(pos)) continue;
                return new SelectedPart(p, side);
            }
        }
        if (AEApi.instance().partHelper().getCableRenderMode().opaqueFacades) {
            IFacadeContainer fc = this.getFacadeContainer();
            for (AEPartLocation side : AEPartLocation.SIDE_LOCATIONS) {
                IFacadePart p = fc.getFacade(side);
                if (p == null) continue;
                LinkedList<AxisAlignedBB> boxes = new LinkedList<AxisAlignedBB>();
                BusCollisionHelper bch = new BusCollisionHelper(boxes, side, null, true);
                p.getBoxes(bch, null);
                for (AxisAlignedBB bb : boxes) {
                    if (!(bb = bb.func_72314_b(0.01, 0.01, 0.01)).func_72318_a(pos)) continue;
                    return new SelectedPart(p, side);
                }
            }
        }
        return new SelectedPart();
    }

    @Override
    public void markForSave() {
        this.tcb.markForSave();
    }

    @Override
    public void partChanged() {
        if (this.getCenter() == null) {
            LinkedList<ItemStack> facades = new LinkedList<ItemStack>();
            IFacadeContainer fc = this.getFacadeContainer();
            for (AEPartLocation d : AEPartLocation.SIDE_LOCATIONS) {
                IFacadePart fp = fc.getFacade(d);
                if (fp == null) continue;
                facades.add(fp.getItemStack());
                fc.removeFacade(this.tcb, d);
            }
            if (!facades.isEmpty()) {
                TileEntity te = this.tcb.getTile();
                Platform.spawnDrops(te.func_145831_w(), te.func_174877_v(), facades);
            }
        }
        this.tcb.partChanged();
    }

    @Override
    public boolean hasRedstone(AEPartLocation side) {
        if (this.hasRedstone == YesNo.UNDECIDED) {
            this.updateRedstone();
        }
        return this.hasRedstone == YesNo.YES;
    }

    @Override
    public boolean isEmpty() {
        IFacadeContainer fc = this.getFacadeContainer();
        for (AEPartLocation s : AEPartLocation.values()) {
            IFacadePart fp;
            IPart part = this.getPart(s);
            if (part != null) {
                return false;
            }
            if (s == AEPartLocation.INTERNAL || (fp = fc.getFacade(s)) == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set<LayerFlags> getLayerFlags() {
        return this.myLayerFlags;
    }

    @Override
    public void cleanup() {
        this.tcb.cleanup();
    }

    @Override
    public void notifyNeighbors() {
        this.tcb.notifyNeighbors();
    }

    @Override
    public boolean isInWorld() {
        return this.inWorld;
    }

    private void updateRedstone() {
        TileEntity te = this.getTile();
        this.hasRedstone = te.func_145831_w().func_175687_A(te.func_174877_v()) != 0 ? YesNo.YES : YesNo.NO;
    }

    private void updateDynamicRender() {
        this.requiresDynamicRender = false;
        for (AEPartLocation s : AEPartLocation.SIDE_LOCATIONS) {
            IPart p = this.getPart(s);
            if (p == null) continue;
            this.setRequiresDynamicRender(this.isRequiresDynamicRender() || p.requireDynamicRender());
        }
    }

    public void updateConnections() {
        if (this.getCenter() != null) {
            EnumSet<EnumFacing> sides = EnumSet.allOf(EnumFacing.class);
            for (EnumFacing s : EnumFacing.field_82609_l) {
                if (this.getPart(s) == null && !this.isBlocked(s)) continue;
                sides.remove(s);
            }
            this.getCenter().setValidSides(sides);
            IGridNode n = this.getCenter().getGridNode();
            if (n != null) {
                n.updateState();
            }
        }
    }

    public void addToWorld() {
        if (this.inWorld) {
            return;
        }
        this.inWorld = true;
        IS_LOADING.set(true);
        TileEntity te = this.getTile();
        for (int x = 6; x >= 0; --x) {
            IGridNode cn;
            IPart center;
            IGridNode sn;
            AEPartLocation s = AEPartLocation.fromOrdinal(x);
            IPart part = this.getPart(s);
            if (part == null) continue;
            part.setPartHostInfo(s, this, te);
            part.addToWorld();
            if (s == AEPartLocation.INTERNAL || (sn = part.getGridNode()) == null || (center = this.getPart(AEPartLocation.INTERNAL)) == null || (cn = center.getGridNode()) == null) continue;
            try {
                AEApi.instance().createGridConnection(cn, sn);
                continue;
            }
            catch (FailedConnection failedConnection) {
                // empty catch block
            }
        }
        this.partChanged();
        IS_LOADING.set(false);
    }

    public void removeFromWorld() {
        if (!this.inWorld) {
            return;
        }
        this.inWorld = false;
        for (AEPartLocation s : AEPartLocation.values()) {
            IPart part = this.getPart(s);
            if (part == null) continue;
            part.removeFromWorld();
        }
        this.partChanged();
    }

    @Override
    public IGridNode getGridNode(AEPartLocation side) {
        IGridNode n;
        IPart part = this.getPart(side);
        if (part != null && (n = part.getExternalFacingNode()) != null) {
            return n;
        }
        if (this.getCenter() != null) {
            return this.getCenter().getGridNode();
        }
        return null;
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        AECableType t;
        IPart part = this.getPart(dir);
        if (part instanceof IGridHost && (t = ((IGridHost)((Object)part)).getCableConnectionType(dir)) != null && t != AECableType.NONE) {
            return t;
        }
        if (this.getCenter() != null) {
            IPartCable c = this.getCenter();
            return c.getCableConnectionType();
        }
        return AECableType.NONE;
    }

    @Override
    public float getCableConnectionLength(AECableType cable) {
        return this.getPart(AEPartLocation.INTERNAL) instanceof IPartCable ? this.getPart(AEPartLocation.INTERNAL).getCableConnectionLength(cable) : -1.0f;
    }

    @Override
    public void securityBreak() {
        for (AEPartLocation d : AEPartLocation.values()) {
            IPart p = this.getPart(d);
            if (!(p instanceof IGridHost)) continue;
            ((IGridHost)((Object)p)).securityBreak();
        }
    }

    public Iterable<AxisAlignedBB> getSelectedBoundingBoxesFromPool(boolean ignoreConnections, boolean includeFacades, Entity e, boolean visual) {
        LinkedList<AxisAlignedBB> boxes = new LinkedList<AxisAlignedBB>();
        IFacadeContainer fc = this.getFacadeContainer();
        for (AEPartLocation s : AEPartLocation.values()) {
            IFacadePart fp;
            BusCollisionHelper bch = new BusCollisionHelper(boxes, s, e, visual);
            IPart part = this.getPart(s);
            if (part != null) {
                if (ignoreConnections && part instanceof IPartCable) {
                    bch.addBox(6.0, 6.0, 6.0, 10.0, 10.0, 10.0);
                } else {
                    part.getBoxes(bch);
                }
            }
            if (!AEApi.instance().partHelper().getCableRenderMode().opaqueFacades && visual || !includeFacades || s == null || s == AEPartLocation.INTERNAL || (fp = fc.getFacade(s)) == null) continue;
            fp.getBoxes(bch, e);
        }
        return boxes;
    }

    @Override
    public int isProvidingStrongPower(EnumFacing side) {
        IPart part = this.getPart(side);
        return part != null ? part.isProvidingStrongPower() : 0;
    }

    @Override
    public int isProvidingWeakPower(EnumFacing side) {
        IPart part = this.getPart(side);
        return part != null ? part.isProvidingWeakPower() : 0;
    }

    @Override
    public boolean canConnectRedstone(EnumSet<EnumFacing> enumSet) {
        for (EnumFacing dir : enumSet) {
            IPart part = this.getPart(dir);
            if (part == null || !part.canConnectRedstone()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onEntityCollision(Entity entity) {
        for (AEPartLocation s : AEPartLocation.values()) {
            IPart part = this.getPart(s);
            if (part == null) continue;
            part.onEntityCollision(entity);
        }
    }

    @Override
    public boolean activate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        SelectedPart p = this.selectPart(pos);
        if (p != null && p.part != null) {
            return p.part.onActivate(player, hand, pos);
        }
        return false;
    }

    @Override
    public void onNeighborChanged() {
        this.hasRedstone = YesNo.UNDECIDED;
        for (AEPartLocation s : AEPartLocation.values()) {
            IPart part = this.getPart(s);
            if (part == null) continue;
            part.onNeighborChanged();
        }
    }

    @Override
    public boolean isSolidOnSide(EnumFacing side) {
        if (side == null) {
            return false;
        }
        IFacadePart fp = this.getFacadeContainer().getFacade(AEPartLocation.fromFacing(side));
        if (fp != null) {
            return true;
        }
        IPart part = this.getPart(side);
        return part != null && part.isSolid();
    }

    @Override
    public boolean isLadder(EntityLivingBase entity) {
        for (AEPartLocation side : AEPartLocation.values()) {
            IPart p = this.getPart(side);
            if (p == null || !p.isLadder(entity)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void randomDisplayTick(World world, BlockPos pos, Random r) {
        for (AEPartLocation side : AEPartLocation.values()) {
            IPart p = this.getPart(side);
            if (p == null) continue;
            p.randomDisplayTick(world, pos, r);
        }
    }

    @Override
    public int getLightValue() {
        int light = 0;
        for (AEPartLocation d : AEPartLocation.values()) {
            IPart p = this.getPart(d);
            if (p == null) continue;
            light = Math.max(p.getLightLevel(), light);
        }
        return light;
    }

    public void writeToStream(ByteBuf data) throws IOException {
        IPart p;
        int x;
        int sides = 0;
        for (x = 0; x < 7; ++x) {
            p = this.getPart(AEPartLocation.fromOrdinal(x));
            if (p == null) continue;
            sides |= 1 << x;
        }
        data.writeByte((int)((byte)sides));
        for (x = 0; x < 7; ++x) {
            p = this.getPart(AEPartLocation.fromOrdinal(x));
            if (p == null) continue;
            ItemStack is = p.getItemStack(PartItemStack.NETWORK);
            data.writeShort(Item.func_150891_b((Item)is.func_77973_b()));
            data.writeShort(is.func_77952_i());
            p.writeToStream(data);
        }
        this.getFacadeContainer().writeToStream(data);
    }

    public boolean readFromStream(ByteBuf data) throws IOException {
        byte sides = data.readByte();
        boolean updateBlock = false;
        for (int x = 0; x < 7; ++x) {
            AEPartLocation side = AEPartLocation.fromOrdinal(x);
            if ((sides & 1 << x) == 1 << x) {
                ItemStack current;
                IPart p = this.getPart(side);
                short itemID = data.readShort();
                short dmgValue = data.readShort();
                Item myItem = Item.func_150899_d((int)itemID);
                ItemStack itemStack = current = p != null ? p.getItemStack(PartItemStack.NETWORK) : null;
                if (current != null && current.func_77973_b() == myItem && current.func_77952_i() == dmgValue) {
                    if (!p.readFromStream(data)) continue;
                    updateBlock = true;
                    continue;
                }
                this.removePart(side, false);
                side = this.addPart(new ItemStack(myItem, 1, (int)dmgValue), side, null, null);
                if (side != null) {
                    p = this.getPart(side);
                    p.readFromStream(data);
                    continue;
                }
                throw new IllegalStateException("Invalid Stream For CableBus Container.");
            }
            if (this.getPart(side) == null) continue;
            this.removePart(side, false);
        }
        if (this.getFacadeContainer().readFromStream(data)) {
            return true;
        }
        return updateBlock;
    }

    public void writeToNBT(NBTTagCompound data) {
        data.func_74768_a("hasRedstone", this.hasRedstone.ordinal());
        IFacadeContainer fc = this.getFacadeContainer();
        for (AEPartLocation s : AEPartLocation.values()) {
            fc.writeToNBT(data);
            IPart part = this.getPart(s);
            if (part == null) continue;
            NBTTagCompound def = new NBTTagCompound();
            part.getItemStack(PartItemStack.WORLD).func_77955_b(def);
            NBTTagCompound extra = new NBTTagCompound();
            part.writeToNBT(extra);
            data.func_74782_a("def:" + this.getSide(part).ordinal(), (NBTBase)def);
            data.func_74782_a("extra:" + this.getSide(part).ordinal(), (NBTBase)extra);
        }
    }

    private AEPartLocation getSide(IPart part) {
        if (this.getCenter() == part) {
            return AEPartLocation.INTERNAL;
        }
        for (AEPartLocation side : AEPartLocation.SIDE_LOCATIONS) {
            if (this.getSide(side) != part) continue;
            return side;
        }
        throw new IllegalStateException("Uhh Bad Part (" + part + ") on Side.");
    }

    public void readFromNBT(NBTTagCompound data) {
        if (data.func_74764_b("hasRedstone")) {
            this.hasRedstone = YesNo.values()[data.func_74762_e("hasRedstone")];
        }
        for (int x = 0; x < 7; ++x) {
            AEPartLocation side = AEPartLocation.fromOrdinal(x);
            NBTTagCompound def = data.func_74775_l("def:" + side.ordinal());
            NBTTagCompound extra = data.func_74775_l("extra:" + side.ordinal());
            if (def != null && extra != null) {
                ItemStack current;
                IPart p = this.getPart(side);
                ItemStack iss = ItemStack.func_77949_a((NBTTagCompound)def);
                if (iss == null) continue;
                ItemStack itemStack = current = p == null ? null : p.getItemStack(PartItemStack.WORLD);
                if (Platform.itemComparisons().isEqualItemType(iss, current)) {
                    p.readFromNBT(extra);
                    continue;
                }
                this.removePart(side, true);
                side = this.addPart(iss, side, null, null);
                if (side != null) {
                    p = this.getPart(side);
                    p.readFromNBT(extra);
                    continue;
                }
                AELog.warn("Invalid NBT For CableBus Container: " + iss.func_77973_b().getClass().getName() + " is not a valid part; it was ignored.", new Object[0]);
                continue;
            }
            this.removePart(side, false);
        }
        this.getFacadeContainer().readFromNBT(data);
    }

    public List getDrops(List drops) {
        for (AEPartLocation s : AEPartLocation.values()) {
            IFacadePart fp;
            IPart part = this.getPart(s);
            if (part != null) {
                drops.add(part.getItemStack(PartItemStack.BREAK));
                part.getDrops(drops, false);
            }
            if (s == AEPartLocation.INTERNAL || (fp = this.getFacadeContainer().getFacade(s)) == null) continue;
            drops.add(fp.getItemStack());
        }
        return drops;
    }

    public List getNoDrops(List drops) {
        for (AEPartLocation s : AEPartLocation.values()) {
            IPart part = this.getPart(s);
            if (part == null) continue;
            part.getDrops(drops, false);
        }
        return drops;
    }

    @Override
    public boolean recolourBlock(EnumFacing side, AEColor colour, EntityPlayer who) {
        IPart cable = this.getPart(AEPartLocation.INTERNAL);
        if (cable != null) {
            IPartCable pc = (IPartCable)cable;
            return pc.changeColor(colour, who);
        }
        return false;
    }

    public boolean isRequiresDynamicRender() {
        return this.requiresDynamicRender;
    }

    private void setRequiresDynamicRender(boolean requiresDynamicRender) {
        this.requiresDynamicRender = requiresDynamicRender;
    }

    @Override
    public CableBusRenderState getRenderState() {
        PartCable cable = (PartCable)this.getCenter();
        CableBusRenderState renderState = new CableBusRenderState();
        if (cable != null) {
            renderState.setCableColor(cable.getCableColor());
            renderState.setCableType(cable.getCableConnectionType());
            renderState.setCoreType(CableCoreType.fromCableType(cable.getCableConnectionType()));
            for (EnumFacing facing : EnumFacing.values()) {
                if (!cable.isConnected(facing)) continue;
                AECableType connectionType = cable.getCableConnectionType();
                BlockPos adjacentPos = this.getTile().func_174877_v().func_177972_a(facing);
                TileEntity adjacentTe = this.getTile().func_145831_w().func_175625_s(adjacentPos);
                if (adjacentTe instanceof IGridHost && (!(adjacentTe instanceof IPartHost) || cable.getCableConnectionType() == AECableType.DENSE)) {
                    IGridHost gridHost = (IGridHost)adjacentTe;
                    connectionType = gridHost.getCableConnectionType(AEPartLocation.fromFacing(facing.func_176734_d()));
                }
                if (adjacentTe instanceof IPartHost) {
                    renderState.getCableBusAdjacent().add(facing);
                }
                renderState.getConnectionTypes().put(facing, connectionType);
            }
            for (EnumFacing facing : EnumFacing.values()) {
                int channels = cable.getChannelsOnSide(facing);
                renderState.getChannelsOnSide().put(facing, channels);
            }
        }
        for (EnumFacing facing : EnumFacing.values()) {
            IPart part;
            FacadeRenderState facadeState = this.getFacadeRenderState(facing);
            if (facadeState != null) {
                renderState.getFacades().put(facing, facadeState);
            }
            if ((part = this.getPart(facing)) == null) continue;
            AEPartLocation loc = AEPartLocation.fromFacing(facing);
            BusCollisionHelper bch = new BusCollisionHelper(renderState.getBoundingBoxes(), loc, null, true);
            part.getBoxes(bch);
            if (part instanceof IGridHost) {
                int length;
                IGridHost gridHost = (IGridHost)((Object)part);
                AECableType desiredType = gridHost.getCableConnectionType(AEPartLocation.INTERNAL);
                if (renderState.getCoreType() == CableCoreType.GLASS && (desiredType == AECableType.SMART || desiredType == AECableType.COVERED)) {
                    renderState.setCoreType(CableCoreType.COVERED);
                }
                if ((length = (int)part.getCableConnectionLength(null)) > 0 && length <= 8) {
                    renderState.getAttachmentConnections().put(facing, length);
                }
            }
            renderState.getAttachments().put(facing, part.getStaticModels());
        }
        return renderState;
    }

    private FacadeRenderState getFacadeRenderState(EnumFacing side) {
        IFacadePart facade = this.getFacade(side.ordinal());
        if (facade != null) {
            ItemStack textureItem = facade.getTextureItem();
            IBlockState blockState = facade.getBlockState();
            if (blockState != null && textureItem != null) {
                EnumSet<EnumFacing> openFaces = this.calculateFaceOpenFaces(side);
                return new FacadeRenderState(blockState, openFaces, textureItem);
            }
        }
        return null;
    }

    private EnumSet<EnumFacing> calculateFaceOpenFaces(EnumFacing side) {
        IFacadePart fp;
        EnumSet<EnumFacing> out = EnumSet.of(side, side.func_176734_d());
        IFacadePart facade = this.getFacade(side.ordinal());
        World blockAccess = this.getTile().func_145831_w();
        BlockPos pos = this.getTile().func_174877_v();
        for (EnumFacing it : EnumFacing.values()) {
            if (out.contains(it) || !this.hasAlphaDiff(blockAccess.func_175625_s(pos.func_177972_a(it)), side, facade)) continue;
            out.add(it);
        }
        if (out.contains(EnumFacing.UP) && (side.func_82601_c() != 0 || side.func_82599_e() != 0) && (fp = this.getFacade(EnumFacing.UP.ordinal())) != null && fp.isTransparent() == facade.isTransparent()) {
            out.remove(EnumFacing.UP);
        }
        if (out.contains(EnumFacing.DOWN) && (side.func_82601_c() != 0 || side.func_82599_e() != 0) && (fp = this.getFacade(EnumFacing.DOWN.ordinal())) != null && fp.isTransparent() == facade.isTransparent()) {
            out.remove(EnumFacing.DOWN);
        }
        if (out.contains(EnumFacing.SOUTH) && side.func_82601_c() != 0 && (fp = this.getFacade(EnumFacing.SOUTH.ordinal())) != null && fp.isTransparent() == facade.isTransparent()) {
            out.remove(EnumFacing.SOUTH);
        }
        if (out.contains(EnumFacing.NORTH) && side.func_82601_c() != 0 && (fp = this.getFacade(EnumFacing.NORTH.ordinal())) != null && fp.isTransparent() == facade.isTransparent()) {
            out.remove(EnumFacing.NORTH);
        }
        return out;
    }

    private boolean hasAlphaDiff(TileEntity tileEntity, EnumFacing side, IFacadePart facade) {
        if (tileEntity instanceof IPartHost) {
            IPartHost ph = (IPartHost)tileEntity;
            IFacadePart fp = ph.getFacadeContainer().getFacade(AEPartLocation.fromFacing(side));
            return fp == null || fp.isTransparent() != facade.isTransparent();
        }
        return true;
    }
}

