/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.util.AEPartLocation;
import appeng.client.ClientHelper;
import appeng.client.render.effects.EnergyFx;
import appeng.core.CommonHelper;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.util.Platform;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketTransitionEffect
extends AppEngPacket {
    private final boolean mode;
    private final double x;
    private final double y;
    private final double z;
    private final AEPartLocation d;

    public PacketTransitionEffect(ByteBuf stream) {
        this.x = stream.readFloat();
        this.y = stream.readFloat();
        this.z = stream.readFloat();
        this.d = AEPartLocation.fromOrdinal(stream.readByte());
        this.mode = stream.readBoolean();
    }

    public PacketTransitionEffect(double x, double y, double z, AEPartLocation dir, boolean wasBlock) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.d = dir;
        this.mode = wasBlock;
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        data.writeFloat((float)x);
        data.writeFloat((float)y);
        data.writeFloat((float)z);
        data.writeByte(this.d.ordinal());
        data.writeBoolean(wasBlock);
        this.configureWrite(data);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void clientPacketData(INetworkInfo network, AppEngPacket packet, EntityPlayer player) {
        World world = ClientHelper.proxy.getWorld();
        for (int zz = 0; zz < (this.mode ? 32 : 8); ++zz) {
            if (!CommonHelper.proxy.shouldAddParticles(Platform.getRandom())) continue;
            EnergyFx fx = new EnergyFx(world, this.x + (this.mode ? (double)(Platform.getRandomInt() % 100) * 0.01 : (double)(Platform.getRandomInt() % 100) * 0.005 - 0.25), this.y + (this.mode ? (double)(Platform.getRandomInt() % 100) * 0.01 : (double)(Platform.getRandomInt() % 100) * 0.005 - 0.25), this.z + (this.mode ? (double)(Platform.getRandomInt() % 100) * 0.01 : (double)(Platform.getRandomInt() % 100) * 0.005 - 0.25), Items.field_151045_i);
            if (!this.mode) {
                fx.fromItem(this.d);
            }
            fx.setMotionX(-0.1f * (float)this.d.xOffset);
            fx.setMotionY(-0.1f * (float)this.d.yOffset);
            fx.setMotionZ(-0.1f * (float)this.d.zOffset);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)fx);
        }
        if (this.mode) {
            Block block = world.func_180495_p(new BlockPos((int)this.x, (int)this.y, (int)this.z)).func_177230_c();
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new PositionedSoundRecord(block.func_185467_w().func_185845_c(), SoundCategory.BLOCKS, (block.func_185467_w().func_185843_a() + 1.0f) / 2.0f, block.func_185467_w().func_185847_b() * 0.8f, (float)this.x + 0.5f, (float)this.y + 0.5f, (float)this.z + 0.5f));
        }
    }
}

