/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.crafting;

import appeng.items.misc.ItemEncodedPattern;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.input.Keyboard;

class ItemEncodedPatternBakedModel
implements IPerspectiveAwareModel {
    private final IBakedModel baseModel;
    private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
    private final CustomOverrideList overrides;

    ItemEncodedPatternBakedModel(IBakedModel baseModel, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms) {
        this.baseModel = baseModel;
        this.transforms = transforms;
        this.overrides = new CustomOverrideList();
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        return this.baseModel.func_188616_a(state, side, rand);
    }

    public boolean func_177555_b() {
        return this.baseModel.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.baseModel.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.baseModel.func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.baseModel.func_177554_e();
    }

    @Deprecated
    public ItemCameraTransforms func_177552_f() {
        return this.baseModel.func_177552_f();
    }

    public ItemOverrideList func_188617_f() {
        return this.overrides;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        if (this.baseModel instanceof IPerspectiveAwareModel) {
            return ((IPerspectiveAwareModel)this.baseModel).handlePerspective(cameraTransformType);
        }
        return IPerspectiveAwareModel.MapWrapper.handlePerspective((IBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)cameraTransformType);
    }

    private class CustomOverrideList
    extends ItemOverrideList {
        CustomOverrideList() {
            super((List)ItemEncodedPatternBakedModel.this.baseModel.func_188617_f().getOverrides());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            ItemEncodedPattern iep;
            ItemStack output;
            boolean shiftHeld;
            boolean bl = shiftHeld = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
            if (shiftHeld && (output = (iep = (ItemEncodedPattern)stack.func_77973_b()).getOutput(stack)) != null) {
                IBakedModel realModel = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(output);
                realModel = realModel.func_188617_f().handleItemState(realModel, output, world, entity);
                return new ShiftHoldingModelWrapper(realModel);
            }
            return ItemEncodedPatternBakedModel.this.baseModel.func_188617_f().handleItemState(originalModel, stack, world, entity);
        }
    }

    private class ShiftHoldingModelWrapper
    implements IPerspectiveAwareModel {
        private final IBakedModel outputModel;

        private ShiftHoldingModelWrapper(IBakedModel outputModel) {
            this.outputModel = outputModel;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            IBakedModel selectedModel = cameraTransformType == ItemCameraTransforms.TransformType.GUI ? this.outputModel : ItemEncodedPatternBakedModel.this.baseModel;
            if (selectedModel.func_177556_c() != ItemEncodedPatternBakedModel.this.baseModel.func_177556_c()) {
                GlStateManager.func_179145_e();
            }
            if (selectedModel instanceof IPerspectiveAwareModel) {
                return ((IPerspectiveAwareModel)selectedModel).handlePerspective(cameraTransformType);
            }
            return IPerspectiveAwareModel.MapWrapper.handlePerspective((IBakedModel)this, (ImmutableMap)ItemEncodedPatternBakedModel.this.transforms, (ItemCameraTransforms.TransformType)cameraTransformType);
        }

        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            return ItemEncodedPatternBakedModel.this.baseModel.func_188616_a(state, side, rand);
        }

        public boolean func_177555_b() {
            return ItemEncodedPatternBakedModel.this.baseModel.func_177555_b();
        }

        public boolean func_177556_c() {
            return ItemEncodedPatternBakedModel.this.baseModel.func_177556_c();
        }

        public boolean func_188618_c() {
            return ItemEncodedPatternBakedModel.this.baseModel.func_188618_c();
        }

        public TextureAtlasSprite func_177554_e() {
            return ItemEncodedPatternBakedModel.this.baseModel.func_177554_e();
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemEncodedPatternBakedModel.this.baseModel.func_177552_f();
        }

        public ItemOverrideList func_188617_f() {
            return ItemEncodedPatternBakedModel.this.baseModel.func_188617_f();
        }
    }
}

