/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.common.client;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.Icons;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.IMaterialItem;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.Pattern;
import slimeknights.tconstruct.library.tools.ToolPart;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.tools.common.client.GuiTinkerStation;
import slimeknights.tconstruct.tools.common.client.module.GuiButtonsPartCrafter;
import slimeknights.tconstruct.tools.common.client.module.GuiInfoPanel;
import slimeknights.tconstruct.tools.common.client.module.GuiSideInventory;
import slimeknights.tconstruct.tools.common.inventory.ContainerPartBuilder;
import slimeknights.tconstruct.tools.common.inventory.ContainerPatternChest;
import slimeknights.tconstruct.tools.common.inventory.ContainerTinkerStation;
import slimeknights.tconstruct.tools.common.tileentity.TilePartBuilder;

@SideOnly(value=Side.CLIENT)
public class GuiPartBuilder
extends GuiTinkerStation {
    private static final ResourceLocation BACKGROUND = Util.getResource("textures/gui/partbuilder.png");
    public static final int Column_Count = 4;
    protected GuiButtonsPartCrafter buttons;
    protected GuiInfoPanel info;
    protected GuiSideInventory sideInventory;
    protected ContainerPatternChest.DynamicChestInventory chestContainer;

    public GuiPartBuilder(InventoryPlayer playerInv, World world, BlockPos pos, TilePartBuilder tile) {
        super(world, pos, (ContainerTinkerStation)tile.createContainer(playerInv, world, pos));
        if (this.field_147002_h instanceof ContainerPartBuilder) {
            ContainerPartBuilder container = (ContainerPartBuilder)this.field_147002_h;
            if (container.isPartCrafter()) {
                this.buttons = new GuiButtonsPartCrafter(this, (Container)container, container.patternChest);
                this.addModule(this.buttons);
            } else {
                this.chestContainer = (ContainerPatternChest.DynamicChestInventory)container.getSubContainer(ContainerPatternChest.DynamicChestInventory.class);
                if (this.chestContainer != null) {
                    this.sideInventory = new GuiSideInventory(this, (Container)this.chestContainer, this.chestContainer.getSlotCount(), this.chestContainer.columns);
                    this.addModule(this.sideInventory);
                }
            }
            this.info = new GuiInfoPanel(this, (Container)container);
            this.info.field_147000_g = this.field_147000_g;
            this.addModule(this.info);
        }
    }

    public void func_146977_a(Slot slotIn) {
        ContainerPartBuilder container;
        if (this.field_147002_h instanceof ContainerPartBuilder && (container = (ContainerPartBuilder)this.field_147002_h).isPartCrafter() && slotIn.field_75224_c == container.patternChest) {
            return;
        }
        super.func_146977_a(slotIn);
    }

    public boolean func_146981_a(Slot slotIn, int mouseX, int mouseY) {
        ContainerPartBuilder container;
        if (this.field_147002_h instanceof ContainerPartBuilder && (container = (ContainerPartBuilder)this.field_147002_h).isPartCrafter() && slotIn.field_75224_c == container.patternChest) {
            return false;
        }
        return super.func_146981_a(slotIn, mouseX, mouseY);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.drawBackground(BACKGROUND);
        if (this.sideInventory != null) {
            this.sideInventory.updateSlotCount(this.chestContainer.getSizeInventory());
        }
        this.drawIconEmpty(this.container.func_75139_a(1), Icons.ICON_Shard);
        this.drawIconEmpty(this.container.func_75139_a(2), Icons.ICON_Pattern);
        this.drawIconEmpty(this.container.func_75139_a(3), Icons.ICON_Ingot);
        this.drawIconEmpty(this.container.func_75139_a(4), Icons.ICON_Block);
        String amount = null;
        Material material = this.getMaterial(this.container.func_75139_a(3).func_75211_c(), this.container.func_75139_a(4).func_75211_c());
        if (material != null) {
            boolean count = false;
            RecipeMatch.Match match = material.matchesRecursively(new ItemStack[]{this.container.func_75139_a(3).func_75211_c(), this.container.func_75139_a(4).func_75211_c()});
            if (match != null) {
                amount = Util.df.format((float)match.amount / 144.0f);
                Item part = Pattern.getPartFromTag(this.container.func_75139_a(2).func_75211_c());
                if (part instanceof IToolPart && match.amount < ((IToolPart)part).getCost()) {
                    amount = TextFormatting.DARK_RED + amount + TextFormatting.RESET;
                }
            }
        }
        if (amount != null) {
            int x = this.cornerX + this.realWidth / 2;
            int y = this.cornerY + 63;
            String text = Util.translateFormatted("gui.partbuilder.material_value", amount, material.getLocalizedName());
            this.field_146289_q.func_180455_b(text, (float)(x -= this.field_146289_q.func_78256_a(text) / 2), (float)y, 0x777777, false);
        }
        super.func_146976_a(partialTicks, mouseX, mouseY);
    }

    @Override
    public void updateDisplay() {
        ItemStack output = this.container.func_75139_a(0).func_75211_c();
        if (output != null) {
            if (output.func_77973_b() instanceof ToolPart) {
                Material material;
                ToolPart toolPart = (ToolPart)output.func_77973_b();
                if (!toolPart.canUseMaterial(material = toolPart.getMaterial(output))) {
                    String materialName = material.getLocalizedNameColored() + TextFormatting.WHITE;
                    String error = I18n.func_74837_a((String)"gui.error.useless_tool_part", (Object[])new Object[]{materialName, new ItemStack((Item)toolPart).func_82833_r()});
                    this.warning(error);
                } else {
                    this.setDisplayForMaterial(material);
                }
            }
        } else {
            Material material = this.getMaterial(this.container.func_75139_a(3).func_75211_c(), this.container.func_75139_a(4).func_75211_c());
            if (material != null) {
                this.setDisplayForMaterial(material);
            } else {
                this.info.setCaption(this.container.getInventoryDisplayName());
                this.info.setText(I18n.func_74838_a((String)"gui.partbuilder.info"));
            }
        }
    }

    @Override
    public void error(String message) {
        this.info.setCaption(I18n.func_74838_a((String)"gui.error"));
        this.info.setText(message);
    }

    @Override
    public void warning(String message) {
        this.info.setCaption(I18n.func_74838_a((String)"gui.warning"));
        this.info.setText(message);
    }

    public void updateButtons() {
        if (this.buttons != null) {
            Minecraft.func_71410_x().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    GuiPartBuilder.this.buttons.updatePosition(GuiPartBuilder.this.cornerX, GuiPartBuilder.this.cornerY, GuiPartBuilder.this.realWidth, GuiPartBuilder.this.realHeight);
                }
            });
        }
    }

    protected void setDisplayForMaterial(Material material) {
        this.info.setCaption(material.getLocalizedNameColored());
        LinkedList stats = Lists.newLinkedList();
        ArrayList tips = Lists.newArrayList();
        for (IMaterialStats stat : material.getAllStats()) {
            List<String> info = stat.getLocalizedInfo();
            if (info.isEmpty()) continue;
            stats.add(TextFormatting.UNDERLINE + stat.getLocalizedName());
            stats.addAll(info);
            stats.add(null);
            tips.add(null);
            tips.addAll(stat.getLocalizedDesc());
            tips.add(null);
        }
        for (ITrait trait : material.getAllTraits()) {
            if (trait.isHidden()) continue;
            stats.add(material.getTextColor() + trait.getLocalizedName());
            tips.add(material.getTextColor() + trait.getLocalizedDesc());
        }
        if (!stats.isEmpty() && stats.get(stats.size() - 1) == null) {
            stats.remove(stats.size() - 1);
            tips.remove(tips.size() - 1);
        }
        this.info.setText(stats, tips);
    }

    protected Material getMaterial(ItemStack ... stacks) {
        for (ItemStack stack : stacks) {
            if (stack == null || stack.func_77973_b() == null || !(stack.func_77973_b() instanceof IMaterialItem)) continue;
            return ((IMaterialItem)stack.func_77973_b()).getMaterial(stack);
        }
        for (Material material : TinkerRegistry.getAllMaterials()) {
            if (material.matches(stacks) == null) continue;
            return material;
        }
        return null;
    }

    private Material getMaterialItem(ItemStack stack) {
        return null;
    }
}

