/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.library.client.RenderUtil;
import slimeknights.tconstruct.library.smeltery.SmelteryTank;

public class SmelteryTankRenderer<T extends TileEntity>
extends TileEntitySpecialRenderer<T> {
    public void renderFluids(SmelteryTank tank, @Nonnull BlockPos pos, @Nonnull BlockPos tankMinPos, @Nonnull BlockPos tankMaxPos, double x, double y, double z) {
        this.renderFluids(tank, pos, tankMinPos, tankMaxPos, x, y, z, RenderUtil.FLUID_OFFSET, tankMinPos);
    }

    public void renderFluids(SmelteryTank tank, @Nonnull BlockPos pos, @Nonnull BlockPos tankMinPos, @Nonnull BlockPos tankMaxPos, double x, double y, double z, float offsetToBlockEdge, @Nonnull BlockPos lightingPos) {
        if (tank == null) {
            return;
        }
        List<FluidStack> fluids = tank.getFluids();
        double x1 = tankMinPos.func_177958_n() - pos.func_177958_n();
        double y1 = tankMinPos.func_177956_o() - pos.func_177956_o();
        double z1 = tankMinPos.func_177952_p() - pos.func_177952_p();
        double x2 = tankMaxPos.func_177958_n() - pos.func_177958_n();
        double z2 = tankMaxPos.func_177952_p() - pos.func_177952_p();
        if (!fluids.isEmpty()) {
            BlockPos minPos = new BlockPos(x1, y1, z1);
            BlockPos maxPos = new BlockPos(x2, y1, z2);
            int yd = 1 + Math.max(0, tankMaxPos.func_177956_o() - tankMinPos.func_177956_o());
            int[] heights = SmelteryTankRenderer.calcLiquidHeights(fluids, tank.getCapacity(), yd * 1000 - (int)((double)RenderUtil.FLUID_OFFSET * 2000.0), 100);
            double curY = RenderUtil.FLUID_OFFSET;
            for (int i = 0; i < fluids.size(); ++i) {
                double h = (double)heights[i] / 1000.0;
                RenderUtil.renderStackedFluidCuboid(fluids.get(i), x, y, z, lightingPos, minPos, maxPos, curY, curY + h, offsetToBlockEdge);
                curY += h;
            }
        }
    }

    public static int[] calcLiquidHeights(List<FluidStack> liquids, int capacity, int height, int min) {
        int[] fluidHeights = new int[liquids.size()];
        if (liquids.size() > 0) {
            for (int i = 0; i < liquids.size(); ++i) {
                FluidStack liquid = liquids.get(i);
                float h = (float)liquid.amount / (float)capacity;
                fluidHeights[i] = Math.max(min, (int)Math.ceil(h * (float)height));
            }
            int sum = 0;
            do {
                sum = 0;
                int biggest = -1;
                int m = 0;
                for (int i = 0; i < fluidHeights.length; ++i) {
                    sum += fluidHeights[i];
                    if (fluidHeights[i] <= biggest) continue;
                    biggest = fluidHeights[i];
                    m = i;
                }
                if (fluidHeights[m] == 0) break;
                if (sum <= height) continue;
                int n = m;
                fluidHeights[n] = fluidHeights[n] - 1;
            } while (sum > height);
        }
        return fluidHeights;
    }
}

