/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world;

import biomesoplenty.api.config.IConfigObj;
import biomesoplenty.api.generation.GeneratorStage;
import biomesoplenty.api.generation.Generators;
import biomesoplenty.api.generation.IGenerator;
import biomesoplenty.api.generation.IGeneratorRegistry;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.HashMap;
import java.util.Map;

public class GeneratorRegistry {
    private static BiMap<String, Class<? extends IGenerator>> generatorClasses = HashBiMap.create();
    private static Map<String, IGenerator.IGeneratorBuilder> generatorBuilders = new HashMap<String, IGenerator.IGeneratorBuilder>();

    public static <T extends IGenerator> void registerGenerator(String identifier, Class<T> generatorClass, IGenerator.IGeneratorBuilder<T> builder) {
        generatorClasses.put((Object)identifier, generatorClass);
        generatorBuilders.put(identifier, builder);
    }

    public static String getIdentifier(Class<? extends IGenerator> generatorClass) {
        return (String)generatorClasses.inverse().get(generatorClass);
    }

    public static Class<? extends IGenerator> getGeneratorClass(String identifier) {
        return (Class)generatorClasses.get((Object)identifier);
    }

    public static IGenerator.IGeneratorBuilder getGeneratorBuilder(String identifier) {
        return generatorBuilders.get(identifier);
    }

    public static boolean generatorExists(String identifier) {
        return generatorClasses.containsValue((Object)identifier);
    }

    public static IGenerator createGenerator(IConfigObj conf) {
        GeneratorStage stage = conf.getEnum("stage", GeneratorStage.class);
        String identifier = conf.getString("type");
        if (stage == null || identifier == null) {
            return null;
        }
        IGenerator.IGeneratorBuilder builder = GeneratorRegistry.getGeneratorBuilder(identifier);
        if (builder == null) {
            conf.addMessage("No generator is registered with type name " + identifier);
            return null;
        }
        Object generator = builder.create();
        generator.setStage(stage);
        generator.configure(conf);
        return generator;
    }

    static {
        Generators.registry = new GeneratorRegistryImpl();
    }

    public static class GeneratorRegistryImpl
    implements IGeneratorRegistry {
        @Override
        public <T extends IGenerator> void registerGenerator(String identifier, Class<T> generatorClass, IGenerator.IGeneratorBuilder<T> builder) {
            GeneratorRegistry.registerGenerator(identifier, generatorClass, builder);
        }

        @Override
        public String getIdentifier(Class<? extends IGenerator> generatorClass) {
            return GeneratorRegistry.getIdentifier(generatorClass);
        }

        @Override
        public Class<? extends IGenerator> getGeneratorClass(String identifier) {
            return GeneratorRegistry.getGeneratorClass(identifier);
        }

        @Override
        public IGenerator.IGeneratorBuilder<?> getGeneratorBuilder(String identifier) {
            return GeneratorRegistry.getGeneratorBuilder(identifier);
        }

        @Override
        public boolean generatorExists(String identifier) {
            return GeneratorRegistry.generatorExists(identifier);
        }

        @Override
        public IGenerator createGenerator(IConfigObj conf) {
            return GeneratorRegistry.createGenerator(conf);
        }
    }
}

