/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.config;

import biomesoplenty.common.remote.TrailManager;
import biomesoplenty.common.util.entity.PlayerUtil;
import biomesoplenty.core.BiomesOPlenty;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

public class MiscConfigurationHandler {
    public static Configuration config;
    public static String guiSettings;
    public static String textureSettings;
    public static String trailSettings;
    public static boolean useBoPWorldTypeDefault;
    public static boolean overrideTitlePanorama;
    public static boolean overrideForgeBuckets;
    public static boolean useBoPBucketTexture;
    public static TrailManager.TrailVisibilityMode trailVisbilityMode;

    public static void init(File configFile) {
        if (config == null) {
            config = new Configuration(configFile);
            MiscConfigurationHandler.loadConfiguration();
        }
    }

    private static void loadConfiguration() {
        try {
            useBoPWorldTypeDefault = config.getBoolean("Default to BoP World Type", guiSettings, false, "Use the Biomes O' Plenty World Type by default when selecting a world.");
            overrideTitlePanorama = config.getBoolean("Enable Biomes O' Plenty Main Menu Panorama", textureSettings, true, "Override the main menu panorama and use ours instead (It's nicer!)");
            overrideForgeBuckets = config.getBoolean("Enable Biomes O' Plenty Bucket Textures", textureSettings, true, "Override the Forge bucket texture and use ours instead (It's nicer!)");
            useBoPBucketTexture = config.getBoolean("Use Biomes O' Plenty Bucket Textures", textureSettings, false, "Use the Biomes O' Plenty bucket texture (Valid only for BOP fluid.)");
            if (FMLCommonHandler.instance().getSide() == Side.CLIENT && TrailManager.trailsMap.containsKey(PlayerUtil.getClientPlayerUUID())) {
                trailVisbilityMode = TrailManager.TrailVisibilityMode.values()[config.getInt("Modify Trail Visibility", trailSettings, 0, 0, 1, "0 = All trails visble, 1 = Others can see your trail but you can't")];
            }
        }
        catch (Exception e) {
            BiomesOPlenty.logger.error("Biomes O' Plenty has encountered a problem loading misc.cfg", (Throwable)e);
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("BiomesOPlenty")) {
            MiscConfigurationHandler.loadConfiguration();
        }
    }

    static {
        guiSettings = "GUI Settings";
        textureSettings = "Texture Settings";
        trailSettings = "Trail Settings";
    }
}

