/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.block;

import biomesoplenty.common.block.IBOPBlock;
import biomesoplenty.common.item.ItemBOPBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBOPStone
extends Block
implements IBOPBlock {
    public static final PropertyEnum VARIANT = PropertyEnum.func_177709_a((String)"variant", StoneType.class);
    public static PropertyBool POLISHED = PropertyBool.func_177716_a((String)"polished");

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT, POLISHED});
    }

    @Override
    public Class<? extends ItemBlock> getItemClass() {
        return ItemBOPBlock.class;
    }

    @Override
    public IProperty[] getPresetProperties() {
        return new IProperty[]{VARIANT, POLISHED};
    }

    @Override
    public IProperty[] getNonRenderingProperties() {
        return null;
    }

    @Override
    public String getStateName(IBlockState state) {
        return (Boolean.TRUE.equals(state.func_177229_b((IProperty)POLISHED)) ? "polished_" : "") + ((StoneType)((Object)state.func_177229_b((IProperty)VARIANT))).func_176610_l();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColor() {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IItemColor getItemColor() {
        return null;
    }

    public BlockBOPStone() {
        super(Material.field_151576_e);
        this.func_149672_a(SoundType.field_185851_d);
        this.setHarvestLevel("pickaxe", 1, this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)StoneType.LIMESTONE)));
        this.setHarvestLevel("pickaxe", 2, this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)StoneType.SILTSTONE)));
        this.setHarvestLevel("pickaxe", 3, this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)StoneType.SHALE)));
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)VARIANT, (Comparable)((Object)StoneType.LIMESTONE)).func_177226_a((IProperty)POLISHED, (Comparable)Boolean.valueOf(false)));
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        return state.func_177230_c() == this && (Boolean)state.func_177229_b((IProperty)POLISHED) != false ? 1.5f : 3.0f;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c() == this && (Boolean)state.func_177229_b((IProperty)POLISHED) != false ? 7.0f : 5.0f;
    }

    public IBlockState func_176203_a(int meta) {
        boolean polished = (meta & 8) > 0;
        int type = meta & 3;
        return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)StoneType.values()[type])).func_177226_a((IProperty)POLISHED, (Comparable)Boolean.valueOf(polished));
    }

    public int func_176201_c(IBlockState state) {
        int type = ((StoneType)((Object)state.func_177229_b((IProperty)VARIANT))).ordinal();
        boolean polished = (Boolean)state.func_177229_b((IProperty)POLISHED);
        return type + (polished ? 8 : 0);
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public static enum StoneType implements IStringSerializable
    {
        LIMESTONE,
        SILTSTONE,
        SHALE;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

