/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biome.overworld;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.block.IBlockPosQuery;
import biomesoplenty.api.config.IBOPWorldSettings;
import biomesoplenty.api.config.IConfigObj;
import biomesoplenty.api.enums.BOPGems;
import biomesoplenty.api.enums.BOPTrees;
import biomesoplenty.api.enums.BOPWoods;
import biomesoplenty.api.generation.GeneratorStage;
import biomesoplenty.common.biome.overworld.BOPBiome;
import biomesoplenty.common.util.block.BlockQuery;
import biomesoplenty.common.world.generator.GeneratorLakes;
import biomesoplenty.common.world.generator.GeneratorOreSingle;
import biomesoplenty.common.world.generator.GeneratorWeighted;
import biomesoplenty.common.world.generator.tree.GeneratorMangroveTree;
import java.util.Random;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;

public class BiomeGenMangrove
extends BOPBiome {
    public IBlockState usualTopBlock;
    public IBlockState alternateTopBlock;

    public BiomeGenMangrove() {
        super("mangrove", new BOPBiome.PropsBuilder("Mangrove").withTemperature(Float.valueOf(0.8f)).withRainfall(Float.valueOf(0.3f)).withGuiColour(7251289).withWaterColor(13500241));
        this.terrainSettings.avgHeight(62.0).heightVariation(2.0, 4.0).octaves(0.0, 1.0, 2.0, 2.0, 1.0, 0.0);
        this.seaFloorBlock = BOPBlocks.mud.func_176223_P();
        this.field_76752_A = BOPBlocks.mud.func_176223_P();
        this.field_76753_B = BOPBlocks.mud.func_176223_P();
        this.usualTopBlock = this.field_76752_A;
        this.alternateTopBlock = Blocks.field_150354_m.func_176223_P();
        this.canSpawnInBiome = false;
        this.canGenerateVillages = false;
        this.canGenerateRivers = false;
        this.field_76762_K.clear();
        this.beachBiomeLocation = null;
        this.clearWeights();
        this.addGenerator("quicksand", GeneratorStage.SAND, ((GeneratorLakes.Builder)new GeneratorLakes.Builder().amountPerChunk(0.2f)).waterLakeForBiome(this).liquid(BOPBlocks.sand).frozenLiquid((IBlockState)null).create());
        IBlockPosQuery emptySandMud = BlockQuery.buildAnd().states(this.usualTopBlock).create();
        GeneratorWeighted treeGenerator = new GeneratorWeighted(7.0f);
        this.addGenerator("trees", GeneratorStage.TREE, treeGenerator);
        treeGenerator.add("mangrove", 1, ((GeneratorMangroveTree.Builder)((GeneratorMangroveTree.Builder)((GeneratorMangroveTree.Builder)new GeneratorMangroveTree.Builder().placeOn(emptySandMud)).log(BOPWoods.MANGROVE)).leaves(BOPTrees.MANGROVE)).create());
        this.addGenerator("sapphire", GeneratorStage.SAND, ((GeneratorOreSingle.Builder)((GeneratorOreSingle.Builder)new GeneratorOreSingle.Builder().amountPerChunk(12.0f)).with(BOPGems.SAPPHIRE)).create());
    }

    @Override
    public void configure(IConfigObj conf) {
        super.configure(conf);
        this.usualTopBlock = this.field_76752_A;
        this.alternateTopBlock = conf.getBlockState("alternateTopBlock", this.alternateTopBlock);
    }

    @Override
    public void func_180622_a(World world, Random rand, ChunkPrimer primer, int x, int z, double noise) {
        double d0 = field_180281_af.func_151601_a((double)x * 0.25, (double)z * 0.25);
        if (d0 > 0.0) {
            int i = x & 0xF;
            int j = z & 0xF;
            for (int k = 255; k >= 0; --k) {
                if (primer.func_177856_a(j, k, i).func_185904_a() == Material.field_151579_a) continue;
                if (k != 62 || primer.func_177856_a(j, k, i).func_177230_c() == Blocks.field_150355_j) break;
                primer.func_177855_a(j, k, i, field_185372_h);
                break;
            }
        }
        this.field_76752_A = noise + rand.nextDouble() * 1.0 > 1.8 ? this.alternateTopBlock : this.usualTopBlock;
        this.func_180628_b(world, rand, primer, x, z, noise);
    }

    @Override
    public void applySettings(IBOPWorldSettings settings) {
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.MUSHROOMS)) {
            this.removeGenerator("glowshrooms");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.FLOWERS)) {
            this.removeGenerator("miners_delight");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.ROCK_FORMATIONS)) {
            this.removeGenerator("stone_formations");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.GEMS)) {
            this.removeGenerator("sapphire");
        }
        GeneratorWeighted treeGen = (GeneratorWeighted)this.getGenerator("trees");
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.TREES)) {
            this.removeGenerator("trees");
            GeneratorWeighted treeGenerator = new GeneratorWeighted(7.0f);
            IBlockPosQuery emptySandMud = BlockQuery.buildAnd().states(this.usualTopBlock).create();
            this.addGenerator("trees", GeneratorStage.TREE, treeGenerator);
            treeGenerator.add("mangrove", 1, ((GeneratorMangroveTree.Builder)((GeneratorMangroveTree.Builder)((GeneratorMangroveTree.Builder)new GeneratorMangroveTree.Builder().placeOn(emptySandMud)).log(BlockPlanks.EnumType.OAK)).leaves(BlockPlanks.EnumType.OAK)).create());
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.FOLIAGE)) {
            this.removeGenerator("bushes");
            this.removeGenerator("koru");
            this.removeGenerator("shrubs");
            this.removeGenerator("leaf_piles");
            this.removeGenerator("dead_leaf_piles");
            this.removeGenerator("clover_patches");
            this.removeGenerator("sprouts");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.PLANTS)) {
            this.removeGenerator("cattail");
            this.removeGenerator("double_cattail");
            this.removeGenerator("river_cane");
            this.removeGenerator("tiny_cacti");
            this.removeGenerator("roots");
            this.removeGenerator("rafflesia");
            this.removeGenerator("desert_sprouts");
        }
    }
}

