/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biome.overworld;

import biomesoplenty.api.biome.BiomeOwner;
import biomesoplenty.api.biome.IExtendedBiome;
import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.block.IBlockPosQuery;
import biomesoplenty.api.config.IBOPWorldSettings;
import biomesoplenty.api.config.IConfigObj;
import biomesoplenty.api.enums.BOPClimates;
import biomesoplenty.api.enums.BOPFlowers;
import biomesoplenty.api.enums.BOPPlants;
import biomesoplenty.api.generation.GeneratorStage;
import biomesoplenty.api.generation.IGenerator;
import biomesoplenty.common.block.BlockBOPMushroom;
import biomesoplenty.common.init.ModBiomes;
import biomesoplenty.common.util.biome.BiomeUtils;
import biomesoplenty.common.util.biome.GeneratorUtils;
import biomesoplenty.common.util.block.BlockQuery;
import biomesoplenty.common.world.GenerationManager;
import biomesoplenty.common.world.TerrainSettings;
import biomesoplenty.common.world.generator.GeneratorColumns;
import biomesoplenty.common.world.generator.GeneratorFlora;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockSand;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;

public class BOPBiome
extends Biome
implements IExtendedBiome {
    private GenerationManager generationManager = new GenerationManager();
    private Map<BOPClimates, Integer> weightMap = new HashMap<BOPClimates, Integer>();
    public int skyColor = -1;
    public boolean hasBiomeEssence = true;
    public IBlockState seaFloorBlock = Blocks.field_150346_d.func_176223_P();
    public boolean canSpawnInBiome = true;
    public boolean canGenerateVillages = true;
    public boolean canGenerateRivers = true;
    public ResourceLocation beachBiomeLocation = BiomeUtils.getLocForBiome(Biomes.field_76787_r);
    public TerrainSettings terrainSettings = new TerrainSettings();
    public boolean noNeighborTerrainInfuence = false;
    public int avgDirtDepth = 3;
    public final ResourceLocation location;
    public IConfigObj conf;

    private BOPBiome(ResourceLocation idLoc, PropsBuilder defaultBuilder, IConfigObj conf) {
        super((Biome.BiomeProperties)BOPBiome.configureBiomeProps(idLoc, defaultBuilder, conf));
        this.location = idLoc;
        this.conf = conf;
        this.terrainSettings.setDefaults();
        this.field_76760_I.field_76832_z = -999;
        this.field_76760_I.field_76802_A = -999;
        this.field_76760_I.field_76803_B = -999;
        this.field_76760_I.field_76801_G = -999;
        this.field_76760_I.field_76805_H = -999;
        this.addGenerator("roots", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(4.0f)).with(BOPPlants.ROOT)).create());
        IBlockPosQuery suitableStonePosition = BlockQuery.buildAnd().withAltitudeBetween(0, 55).blocks(Blocks.field_150348_b).create();
        this.addGenerator("miners_delight", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.25f)).generationAttempts(64)).with(BOPFlowers.MINERS_DELIGHT)).placeOn(suitableStonePosition)).scatterYMethod(GeneratorUtils.ScatterYMethod.BELOW_GROUND)).create());
        this.addGenerator("glowshrooms", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(1.5f)).generationAttempts(64)).placeOn(suitableStonePosition)).with(BOPBlocks.mushroom.func_176223_P().func_177226_a((IProperty)BlockBOPMushroom.VARIANT, (Comparable)((Object)BlockBOPMushroom.MushroomType.GLOWSHROOM)))).scatterYMethod(GeneratorUtils.ScatterYMethod.BELOW_GROUND)).create());
        this.addGenerator("stone_formations", GeneratorStage.FLOWERS, ((GeneratorColumns.Builder)((GeneratorColumns.Builder)((GeneratorColumns.Builder)((GeneratorColumns.Builder)new GeneratorColumns.Builder().amountPerChunk(30.0f)).generationAttempts(32).placeOn(suitableStonePosition)).with(BOPBlocks.stone_formations.func_176223_P())).minHeight(1).maxHeight(5).randomDirection(true).scatterYMethod(GeneratorUtils.ScatterYMethod.BELOW_GROUND)).create());
    }

    public BOPBiome(String idName, PropsBuilder defaultBuilder) {
        this(new ResourceLocation("BiomesOPlenty", idName), defaultBuilder, ModBiomes.readConfigFile(idName));
    }

    public static BiomeProps configureBiomeProps(ResourceLocation idLoc, PropsBuilder defaultBuilder, IConfigObj conf) {
        Boolean enableSnow;
        if (conf.isEmpty()) {
            return defaultBuilder.build();
        }
        defaultBuilder.withTemperature(conf.getFloat("temperature"));
        defaultBuilder.withRainfall(conf.getFloat("rainfall"));
        defaultBuilder.withWaterColor(conf.getInt("waterColor"));
        Boolean enableRain = conf.getBool("enableRain");
        if (enableRain != null && !enableRain.booleanValue()) {
            defaultBuilder.withRainDisabled();
        }
        if ((enableSnow = conf.getBool("enableSnow")) != null && enableSnow.booleanValue()) {
            defaultBuilder.withSnowEnabled();
        }
        defaultBuilder.withBaseBiome(conf.getString("baseBiome"));
        defaultBuilder.withGuiColour(conf.getInt("guiColour"));
        return defaultBuilder.build();
    }

    @Override
    public void applySettings(IBOPWorldSettings settings) {
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.MUSHROOMS)) {
            this.removeGenerator("glowshrooms");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.PLANTS)) {
            this.removeGenerator("roots");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.FLOWERS)) {
            this.removeGenerator("miners_delight");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.ROCK_FORMATIONS)) {
            this.removeGenerator("stone_formations");
        }
    }

    @Override
    public void configure(IConfigObj conf) {
        ArrayList<IConfigObj> confEntities;
        IConfigObj confGenerators;
        this.field_76752_A = conf.getBlockState("topBlock", this.field_76752_A);
        this.field_76753_B = conf.getBlockState("fillerBlock", this.field_76753_B);
        this.seaFloorBlock = conf.getBlockState("seaFloorBlock", this.seaFloorBlock);
        this.terrainSettings.avgHeight = conf.getFloat("averageHeight", Float.valueOf((float)this.terrainSettings.avgHeight)).floatValue();
        this.terrainSettings.variationBelow = conf.getFloat("variationBelow", Float.valueOf((float)this.terrainSettings.variationBelow)).floatValue();
        this.terrainSettings.variationAbove = conf.getFloat("variationAbove", Float.valueOf((float)this.terrainSettings.variationAbove)).floatValue();
        this.skyColor = conf.getInt("skyColor", this.skyColor);
        this.hasBiomeEssence = conf.getBool("hasBiomeEssence", this.hasBiomeEssence);
        this.canSpawnInBiome = conf.getBool("canSpawnInBiome", this.canSpawnInBiome);
        this.canGenerateVillages = conf.getBool("canGenerateVillages", this.canGenerateVillages);
        this.canGenerateRivers = conf.getBool("canGenerateRivers", this.canGenerateRivers);
        this.beachBiomeLocation = conf.getResourceLocation("beachBiomeLocation", this.beachBiomeLocation);
        IConfigObj confWeights = conf.getObject("weights");
        if (confWeights != null) {
            for (BOPClimates climate : BOPClimates.values()) {
                Integer weight = confWeights.getInt(climate.name().toLowerCase(), null);
                if (weight == null) continue;
                if (weight < 1) {
                    this.weightMap.remove((Object)climate);
                    continue;
                }
                this.weightMap.put(climate, weight);
            }
        }
        if ((confGenerators = conf.getObject("generators")) != null) {
            for (String name : confGenerators.getKeys()) {
                this.generationManager.configureWith(name, confGenerators.getObject(name));
            }
        }
        if ((confEntities = conf.getObjectArray("entities")) != null) {
            for (IConfigObj confEntity : confEntities) {
                Biome.SpawnListEntry entry;
                String entityName = confEntity.getString("name");
                EnumCreatureType creatureType = confEntity.getEnum("creatureType", EnumCreatureType.class);
                if (entityName == null || creatureType == null) continue;
                Class entityClazz = null;
                for (Map.Entry entry2 : EntityList.field_75625_b.entrySet()) {
                    String entryEntityName = (String)entry2.getKey();
                    if (!entryEntityName.equalsIgnoreCase(entityName)) continue;
                    entityClazz = (Class)entry2.getValue();
                }
                if (entityClazz == null) {
                    confEntity.addMessage("No entity registered called " + entityName);
                    continue;
                }
                if (!creatureType.func_75598_a().isAssignableFrom(entityClazz)) {
                    confEntity.addMessage("Entity " + entityName + " is not of type " + creatureType);
                    continue;
                }
                List spawns = this.func_76747_a(creatureType);
                Integer weight = confEntity.getInt("weight");
                if (weight != null && weight < 1) {
                    Iterator spawnIterator = spawns.iterator();
                    while (spawnIterator.hasNext()) {
                        entry = (Biome.SpawnListEntry)spawnIterator.next();
                        if (entry.field_76300_b != entityClazz) continue;
                        spawnIterator.remove();
                    }
                    continue;
                }
                boolean foundIt = false;
                for (Biome.SpawnListEntry entry3 : spawns) {
                    if (entry3.field_76300_b != entityClazz) continue;
                    entry3.field_76292_a = confEntity.getInt("weight", entry3.field_76292_a);
                    entry3.field_76301_c = confEntity.getInt("minGroupCount", entry3.field_76301_c);
                    entry3.field_76299_d = confEntity.getInt("maxGroupCount", entry3.field_76299_d);
                    foundIt = true;
                }
                if (foundIt) continue;
                entry = new Biome.SpawnListEntry(entityClazz, confEntity.getInt("weight", 10).intValue(), confEntity.getInt("minGroupCount", 4).intValue(), confEntity.getInt("maxGroupCount", 4).intValue());
                spawns.add(entry);
            }
        }
    }

    @Override
    public BiomeOwner getBiomeOwner() {
        return BiomeOwner.BIOMESOPLENTY;
    }

    @Override
    public void addGenerator(String name, GeneratorStage stage, IGenerator generator) {
        this.generationManager.addGenerator(name, stage, generator);
    }

    public IGenerator getGenerator(String name) {
        return this.generationManager.getGenerator(name);
    }

    public void removeGenerator(String name) {
        this.generationManager.removeGenerator(name);
    }

    @Override
    public GenerationManager getGenerationManager() {
        return this.generationManager;
    }

    @Override
    public Map<BOPClimates, Integer> getWeightMap() {
        return this.weightMap;
    }

    @Override
    public void addWeight(BOPClimates climate, int weight) {
        this.weightMap.put(climate, weight);
    }

    @Override
    public void clearWeights() {
        this.weightMap.clear();
    }

    public boolean hasBiomeEssence() {
        return this.hasBiomeEssence;
    }

    public int func_76731_a(float temperature) {
        return this.skyColor == -1 ? super.func_76731_a(temperature) : this.skyColor;
    }

    public void func_180622_a(World world, Random rand, ChunkPrimer primer, int x, int z, double stoneNoiseVal) {
        IBlockState topBlock = this.field_76752_A;
        IBlockState fillerBlock = this.field_76753_B;
        IBlockState seaFloorBlock = this.seaFloorBlock;
        boolean hitFloorYet = false;
        int topBlocksToFill = 0;
        int dirtBlocksToFill = 0;
        int seaFloorBlocksToFill = 0;
        int dirtDepth = Math.max(0, (int)(stoneNoiseVal / 3.0 + (double)this.avgDirtDepth + rand.nextDouble() * 0.25));
        int seaFloorDepth = 1 + rand.nextInt(2);
        int localX = x & 0xF;
        int localZ = z & 0xF;
        for (int y = 255; y >= 0; --y) {
            IBlockState state = primer.func_177856_a(localZ, y, localX);
            if (y <= rand.nextInt(5)) {
                primer.func_177855_a(localZ, y, localX, Blocks.field_150357_h.func_176223_P());
                continue;
            }
            if (state.func_185904_a() == Material.field_151579_a) {
                topBlocksToFill = topBlock == null ? 0 : 1;
                dirtBlocksToFill = dirtDepth;
                continue;
            }
            if (!hitFloorYet && state.func_185904_a() == Material.field_151586_h) {
                seaFloorBlocksToFill = seaFloorDepth;
            }
            if (state.func_177230_c() != Blocks.field_150348_b) continue;
            hitFloorYet = true;
            if (topBlocksToFill > 0) {
                if (y >= 62) {
                    primer.func_177855_a(localZ, y, localX, topBlock);
                } else if (y >= 56 - dirtDepth) {
                    primer.func_177855_a(localZ, y, localX, fillerBlock);
                } else {
                    primer.func_177855_a(localZ, y, localX, Blocks.field_150351_n.func_176223_P());
                    dirtBlocksToFill = 0;
                }
                --topBlocksToFill;
                continue;
            }
            if (seaFloorBlocksToFill > 0) {
                primer.func_177855_a(localZ, y, localX, seaFloorBlock);
                --seaFloorBlocksToFill;
                continue;
            }
            if (dirtBlocksToFill <= 0) continue;
            primer.func_177855_a(localZ, y, localX, fillerBlock);
            if (--dirtBlocksToFill != 0 || fillerBlock.func_177230_c() != Blocks.field_150354_m) continue;
            dirtBlocksToFill = rand.nextInt(4) + Math.max(0, y - 63);
            fillerBlock = fillerBlock.func_177229_b((IProperty)BlockSand.field_176504_a) == BlockSand.EnumType.RED_SAND ? Blocks.field_180395_cM.func_176223_P() : Blocks.field_150322_A.func_176223_P();
        }
    }

    @Override
    public ResourceLocation getBeachLocation() {
        return this.beachBiomeLocation;
    }

    @Override
    public Biome getBaseBiome() {
        return this;
    }

    @Override
    public ResourceLocation getResourceLocation() {
        return this.location;
    }

    private static class BiomeProps
    extends Biome.BiomeProperties {
        private int guiColour = 0xFFFFFF;

        private BiomeProps(String name, float temperature, float rainfall, float baseHeight, float heightVariation, boolean enableRain, boolean enableSnow, int waterColor, String baseBiomeRegName, int guiColour) {
            super(name);
            this.func_185410_a(temperature);
            this.func_185395_b(rainfall);
            this.func_185398_c(baseHeight);
            this.func_185400_d(heightVariation);
            if (!enableRain) {
                this.func_185396_a();
            }
            if (enableSnow) {
                this.func_185411_b();
            }
            this.func_185402_a(waterColor);
            this.func_185399_a(baseBiomeRegName);
            this.guiColour = guiColour;
        }
    }

    protected static class PropsBuilder {
        private final String biomeName;
        private int guiColour = 0xFFFFFF;
        private float baseHeight = 0.1f;
        private float heightVariation = 0.2f;
        private float temperature = 0.5f;
        private float rainfall = 0.5f;
        private int waterColor = 0xFFFFFF;
        private boolean enableSnow = false;
        private boolean enableRain = true;
        private String baseBiomeRegName;

        public PropsBuilder(String name) {
            this.biomeName = name;
        }

        public PropsBuilder withGuiColour(Integer colour) {
            if (colour != null) {
                this.guiColour = colour;
            }
            return this;
        }

        public PropsBuilder withTemperature(Float temperature) {
            if (temperature != null) {
                this.temperature = temperature.floatValue();
            }
            return this;
        }

        public PropsBuilder withRainfall(Float rainfall) {
            if (rainfall != null) {
                this.rainfall = rainfall.floatValue();
            }
            return this;
        }

        public PropsBuilder withBaseHeight(Float baseHeight) {
            if (baseHeight != null) {
                this.baseHeight = baseHeight.floatValue();
            }
            return this;
        }

        public PropsBuilder withHeightVariation(Float heightVariation) {
            if (heightVariation != null) {
                this.heightVariation = heightVariation.floatValue();
            }
            return this;
        }

        public PropsBuilder withRainDisabled() {
            this.enableRain = false;
            return this;
        }

        public PropsBuilder withSnowEnabled() {
            this.enableSnow = true;
            return this;
        }

        public PropsBuilder withWaterColor(Integer waterColor) {
            if (waterColor != null) {
                this.waterColor = waterColor;
            }
            return this;
        }

        public PropsBuilder withBaseBiome(String name) {
            if (name != null) {
                this.baseBiomeRegName = name;
            }
            return this;
        }

        public BiomeProps build() {
            return new BiomeProps(this.biomeName, this.temperature, this.rainfall, this.baseHeight, this.heightVariation, this.enableRain, this.enableSnow, this.waterColor, this.baseBiomeRegName, this.guiColour);
        }
    }
}

