/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport.telepad;

import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.ModObject;
import crazypants.enderio.TileEntityEio;
import crazypants.enderio.machine.PacketPowerStorage;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.power.IInternalPowerReceiver;
import crazypants.enderio.teleport.telepad.DialerFacing;
import crazypants.enderio.teleport.telepad.TelepadTarget;
import crazypants.enderio.teleport.telepad.packet.PacketTargetList;
import info.loenwind.autosave.annotations.Store;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileDialingDevice
extends TileEntityEio
implements IInternalPowerReceiver,
IItemHandlerModifiable {
    private static final int RF_PER_TICK = 20;
    @Store
    private int storedEnergyRF;
    private int lastSyncPowerStored;
    @Store
    protected ItemStack[] inventory = new ItemStack[2];
    @Store
    private DialerFacing facing;
    @Store(handler=TelepadTarget.TelepadTargetArrayListHandler.class)
    private final ArrayList<TelepadTarget> targets = new ArrayList();

    @Override
    public void doUpdate() {
        boolean powerChanged;
        if (this.field_145850_b.field_72995_K) {
            super.doUpdate();
            return;
        }
        if (this.inventory[0] != null && this.inventory[1] == null) {
            ItemStack stack = this.inventory[0];
            TelepadTarget newTarg = TelepadTarget.readFromNBT(stack);
            if (newTarg != null && !this.targets.contains(newTarg)) {
                this.addTarget(newTarg);
                PacketHandler.sendToAllAround((IMessage)new PacketTargetList(this, newTarg, true), (TileEntity)this);
            }
            this.inventory[0] = null;
            this.inventory[1] = stack;
            this.func_70296_d();
        }
        if (this.getEnergyStored() <= 0) {
            return;
        }
        this.setEnergyStored(this.getEnergyStored() - this.getUsage());
        boolean bl = powerChanged = this.lastSyncPowerStored != this.getEnergyStored() && this.shouldDoWorkThisTick(5);
        if (powerChanged) {
            this.lastSyncPowerStored = this.getEnergyStored();
            PacketHandler.sendToAllAround(new PacketPowerStorage(this), (TileEntity)this);
        }
    }

    public void addTarget(TelepadTarget newTarg) {
        if (newTarg == null) {
            return;
        }
        this.targets.add(newTarg);
        this.func_70296_d();
    }

    public void removeTarget(TelepadTarget target) {
        if (target == null) {
            return;
        }
        this.targets.remove(target);
        this.func_70296_d();
    }

    public ArrayList<TelepadTarget> getTargets() {
        return this.targets;
    }

    public void setTargets(Collection<TelepadTarget> t) {
        this.targets.clear();
        if (t != null) {
            this.targets.addAll(t);
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this;
        }
        return (T)super.getCapability(capability, facing);
    }

    public int getSlots() {
        return 2;
    }

    public ItemStack getStackInSlot(int slot) {
        if (slot < 0 || slot >= this.inventory.length) {
            return null;
        }
        return this.inventory[slot];
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        if (slot < 0 || slot >= this.inventory.length) {
            return;
        }
        this.inventory[slot] = stack;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (slot != 0 || this.inventory[0] != null || stack == null || stack.func_77973_b() != ModObject.itemLocationPrintout.getItem()) {
            return stack;
        }
        if (!simulate) {
            this.inventory[0] = stack.func_77946_l();
            this.func_70296_d();
        }
        return null;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot != 1 || amount < 1 || this.inventory[1] == null) {
            return null;
        }
        ItemStack res = this.inventory[1].func_77946_l();
        if (!simulate) {
            this.func_70296_d();
            this.inventory[1] = null;
        }
        return res;
    }

    @Override
    public int getMaxEnergyRecieved(EnumFacing dir) {
        return 800;
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return 96000;
    }

    @Override
    public boolean displayPower() {
        return true;
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.storedEnergyRF;
    }

    @Override
    public void setEnergyStored(int storedEnergy) {
        this.storedEnergyRF = MathHelper.func_76125_a((int)storedEnergy, (int)0, (int)this.getMaxEnergyStored(null));
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        int max = Math.max(0, Math.min(Math.min(this.getMaxEnergyRecieved(from), maxReceive), this.getMaxEnergyStored(from) - this.getEnergyStored(null)));
        if (!simulate) {
            this.setEnergyStored(this.getEnergyStored() + max);
        }
        return max;
    }

    public int getUsage() {
        return 20;
    }

    @Override
    public BlockCoord getLocation() {
        return new BlockCoord(this.field_174879_c);
    }

    public DialerFacing getFacing() {
        return this.facing == null ? DialerFacing.DOWN_TONORTH : this.facing;
    }

    public void setFacing(DialerFacing facing) {
        this.facing = facing;
        this.func_70296_d();
    }

    public int getPowerScaled(int scale) {
        return (int)((float)this.getEnergyStored() / (float)this.getMaxEnergyStored(null) * (float)scale);
    }

    public int getEnergyStored() {
        return this.getEnergyStored(null);
    }
}

