/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport;

import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.common.ContainerEnder;
import com.enderio.core.common.TileEntityBase;
import crazypants.enderio.api.teleport.ITravelAccessable;
import crazypants.enderio.network.GuiPacket;
import crazypants.enderio.network.IRemoteExec;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.teleport.packet.PacketPassword;
import java.awt.Point;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ContainerTravelAccessable
extends ContainerEnder<IInventory>
implements IRemoteExec.IContainer {
    public static final int EXEC_ACCESS_MODE = 0;
    public static final int EXEC_LABEL = 1;
    ITravelAccessable ta;
    TileEntity te;
    World world;
    private int guiID = -1;

    public ContainerTravelAccessable(InventoryPlayer playerInv, ITravelAccessable travelAccessable, World world) {
        super(playerInv, (IInventory)playerInv);
        this.ta = travelAccessable;
        this.world = world;
        if (this.ta instanceof TileEntity) {
            this.te = (TileEntity)this.ta;
        }
    }

    protected void addSlots(InventoryPlayer playerInv) {
    }

    public void addGhostSlots(List<GhostSlot> ghostSlots) {
        int x = 44;
        int y = 73;
        for (int i = 0; i < 5; ++i) {
            ghostSlots.add(new CtaGhostSlot(this.ta, i, x, y, true));
            x += 18;
        }
        x = 125;
        y = 10;
        ghostSlots.add(new CtaGhostSlot(this.ta, 0, x, y, false));
    }

    public Point getPlayerInventoryOffset() {
        return new Point(8, 103);
    }

    public ItemStack func_82846_b(EntityPlayer entityPlayer, int slotIndex) {
        return null;
    }

    @Override
    public void setGuiID(int id) {
        this.guiID = id;
    }

    @Override
    public int getGuiID() {
        return this.guiID;
    }

    @Override
    public void networkExec(int id, GuiPacket message) {
        switch (id) {
            case 0: {
                this.ta.setAccessMode(message.getEnum(0, ITravelAccessable.AccessMode.class));
                break;
            }
            case 1: {
                this.ta.setLabel(message.getString(0));
                break;
            }
            default: {
                return;
            }
        }
        IBlockState bs = this.te.func_145831_w().func_180495_p(this.te.func_174877_v());
        this.te.func_145831_w().func_184138_a(this.te.func_174877_v(), bs, bs, 3);
        this.te.func_145831_w().func_175646_b(this.te.func_174877_v(), this.te);
    }

    private static class CtaGhostSlot
    extends GhostSlot {
        private ITravelAccessable ta;
        boolean isAuth;

        public CtaGhostSlot(ITravelAccessable ta, int slotIndex, int x, int y, boolean isAuth) {
            this.slot = slotIndex;
            this.x = x;
            this.y = y;
            this.displayStdOverlay = false;
            this.grayOut = true;
            this.stackSizeLimit = 1;
            this.ta = ta;
            this.isAuth = isAuth;
        }

        public ItemStack getStack() {
            if (this.isAuth) {
                return this.ta.getPassword()[this.slot];
            }
            return this.ta.getItemLabel();
        }

        public void putStack(ItemStack stack) {
            if (this.isAuth) {
                if (this.ta instanceof TileEntityBase) {
                    PacketHandler.INSTANCE.sendToServer(PacketPassword.setPassword((TileEntityBase)this.ta, this.slot, stack));
                }
            } else if (this.ta instanceof TileEntityBase) {
                PacketHandler.INSTANCE.sendToServer((IMessage)PacketPassword.setLabel((TileEntityBase)this.ta, stack));
            }
        }
    }
}

