/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.sound;

import crazypants.enderio.Log;
import crazypants.enderio.sound.IModSound;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class SoundHelper {
    public static final Vec3d BLOCK_CENTER = new Vec3d(0.5, 0.5, 0.5);
    public static final Vec3d BLOCK_TOP = new Vec3d(0.5, 1.0, 0.5);
    public static final Vec3d BLOCK_LOW = new Vec3d(0.5, 0.1, 0.5);

    private SoundHelper() {
    }

    public static void playSound(World world, double soundLocationX, double soundLocationY, double soundLocationZ, IModSound sound, float volume, float pitch) {
        if (sound != null && sound.isValid()) {
            if (world instanceof WorldServer) {
                world.func_184148_a(null, soundLocationX, soundLocationY, soundLocationZ, sound.getSoundEvent(), sound.getSoundCategory(), volume, pitch);
            } else {
                world.func_184134_a(soundLocationX, soundLocationY, soundLocationZ, sound.getSoundEvent(), sound.getSoundCategory(), volume, pitch, false);
            }
        } else {
            Log.error("SoundHelper: Asked to play invalid sound " + sound);
        }
    }

    public static void playSound(World world, BlockPos soundLocation, IModSound sound, float volume, float pitch) {
        SoundHelper.playSound(world, soundLocation, BLOCK_CENTER, sound, volume, pitch);
    }

    public static void playSound(World world, BlockPos soundLocation, Vec3d offset, IModSound sound, float volume, float pitch) {
        SoundHelper.playSound(world, (double)soundLocation.func_177958_n() + offset.field_72450_a, (double)soundLocation.func_177956_o() + offset.field_72448_b, (double)soundLocation.func_177952_p() + offset.field_72449_c, sound, volume, pitch);
    }

    public static void playSound(World world, Entity soundLocation, IModSound sound, float volume, float pitch) {
        SoundHelper.playSound(world, soundLocation.field_70165_t, soundLocation.field_70163_u, soundLocation.field_70161_v, sound, volume, pitch);
    }
}

