/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.power;

import crazypants.enderio.Log;
import crazypants.enderio.power.IInternalPowerReceiver;
import crazypants.enderio.power.IPowerApiAdapter;
import crazypants.enderio.power.IPowerInterface;
import crazypants.enderio.power.rf.RfAdapter;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;

public class PowerHandlerUtil {
    private static final List<IPowerApiAdapter> providers = new CopyOnWriteArrayList<IPowerApiAdapter>();

    public static void addAdapter(IPowerApiAdapter adapter) {
        if (adapter != null) {
            providers.add(adapter);
        }
    }

    public static void create() {
        block2: {
            try {
                RfAdapter.create();
            }
            catch (Throwable e) {
                Log.warn("RF API not found. RF integration not loaded. This is not an error. Reason: " + e);
                if (!Log.LOGGER.isDebugEnabled()) break block2;
                e.printStackTrace();
            }
        }
    }

    public static IPowerInterface getPowerInterface(@Nullable ICapabilityProvider provider, EnumFacing side) {
        IPowerInterface res = null;
        for (IPowerApiAdapter prov : providers) {
            res = prov.getPowerInterface(provider, side);
            if (res == null) continue;
            return res;
        }
        return res;
    }

    public static IEnergyStorage getCapability(ItemStack stack) {
        return PowerHandlerUtil.getCapability((ICapabilityProvider)stack, null);
    }

    public static IEnergyStorage getCapability(@Nullable ICapabilityProvider provider, EnumFacing side) {
        IEnergyStorage res = null;
        for (IPowerApiAdapter prov : providers) {
            res = prov.getCapability(provider, side);
            if (res == null) continue;
            return res;
        }
        return res;
    }

    public static int recieveInternal(IInternalPowerReceiver target, int maxReceive, EnumFacing from, boolean simulate) {
        int result = Math.min(target.getMaxEnergyRecieved(from), maxReceive);
        result = Math.min(target.getMaxEnergyStored(from) - target.getEnergyStored(from), result);
        if ((result = Math.max(0, result)) > 0 && !simulate) {
            target.setEnergyStored(target.getEnergyStored(from) + result);
        }
        return result;
    }
}

