/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.wireless;

import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.machine.wireless.IWirelessCharger;
import crazypants.enderio.machine.wireless.WirelessChargerController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class WirelessChargedLocation {
    private final TileEntity te;
    private int lastChangeCount;
    private final List<IWirelessCharger> chargers;

    public WirelessChargedLocation(TileEntity te) {
        this.te = te;
        this.chargers = new ArrayList<IWirelessCharger>();
        this.lastChangeCount = WirelessChargerController.instance.getChangeCount() - 1;
    }

    private void updateChargers() {
        WirelessChargerController wcc = WirelessChargerController.instance;
        this.chargers.clear();
        this.lastChangeCount = wcc.getChangeCount();
        final BlockCoord bc = new BlockCoord(this.te);
        wcc.getChargers(this.te.func_145831_w(), bc, this.chargers);
        Collections.sort(this.chargers, new Comparator<IWirelessCharger>(){

            @Override
            public int compare(IWirelessCharger o1, IWirelessCharger o2) {
                int dist1 = o1.getLocation().getDistSq(bc);
                int dist2 = o2.getLocation().getDistSq(bc);
                return dist1 - dist2;
            }
        });
    }

    private void checkChangeCount() {
        if (this.lastChangeCount != WirelessChargerController.instance.getChangeCount()) {
            this.updateChargers();
        }
    }

    public boolean chargeItems(ItemStack[] items) {
        this.checkChangeCount();
        for (IWirelessCharger wc : this.chargers) {
            if (!wc.isActive() || !wc.chargeItems(items)) continue;
            return true;
        }
        return false;
    }

    public int takeEnergy(int max) {
        this.checkChangeCount();
        int charged = 0;
        for (IWirelessCharger wc : this.chargers) {
            if (wc.isActive() && (charged += wc.takeEnergy(max - charged)) >= max) break;
        }
        return charged;
    }
}

