/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.invpanel.remote;

import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.invpanel.TileInventoryPanel;
import crazypants.enderio.machine.invpanel.remote.ItemRemoteInvAccess;
import crazypants.enderio.machine.invpanel.remote.ItemRemoteInvAccessType;
import crazypants.util.NbtValue;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketRemoteInvPanel
implements IMessage,
IMessageHandler<PacketRemoteInvPanel, IMessage> {
    EnumHand hand;

    public PacketRemoteInvPanel() {
    }

    public PacketRemoteInvPanel(EnumHand hand) {
        this.hand = hand;
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeByte(this.hand.ordinal());
    }

    public void fromBytes(ByteBuf buffer) {
        this.hand = EnumHand.values()[buffer.readByte()];
    }

    public IMessage onMessage(PacketRemoteInvPanel message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        ItemStack heldItem = player.func_184586_b(message.hand);
        if (heldItem == null || !(heldItem.func_77973_b() instanceof ItemRemoteInvAccess)) {
            return null;
        }
        if (!NbtValue.REMOTE_X.hasTag(heldItem)) {
            return null;
        }
        int x = NbtValue.REMOTE_X.getInt(heldItem);
        int y = NbtValue.REMOTE_Y.getInt(heldItem);
        int z = NbtValue.REMOTE_Z.getInt(heldItem);
        int d = NbtValue.REMOTE_D.getInt(heldItem);
        ItemRemoteInvAccessType type = ItemRemoteInvAccessType.fromStack(heldItem);
        if (!type.inRange(d, x, y, z, player.func_130014_f_().field_73011_w.getDimension(), (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v)) {
            player.func_145747_a((ITextComponent)new TextComponentString(EnderIO.lang.localize("remoteinv.chat.outofrange")));
            return null;
        }
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server == null) {
            return null;
        }
        WorldServer world = server.func_71218_a(d);
        if (world == null) {
            player.func_145747_a((ITextComponent)new TextComponentString(EnderIO.lang.localize("remoteinv.chat.invalidtarget")));
            return null;
        }
        BlockPos pos = new BlockPos(x, y, z);
        if (!world.func_175667_e(pos)) {
            player.func_145747_a((ITextComponent)new TextComponentString(EnderIO.lang.localize("remoteinv.chat.notloaded")));
            return null;
        }
        TileEntity tileEntity = player.func_130014_f_().func_175625_s(pos);
        if (!(tileEntity instanceof TileInventoryPanel)) {
            player.func_145747_a((ITextComponent)new TextComponentString(EnderIO.lang.localize("remoteinv.chat.invalidtarget")));
            return null;
        }
        Container c = player.field_71070_bA;
        player.field_71134_c.func_187251_a((EntityPlayer)player, player.field_70170_p, null, EnumHand.MAIN_HAND, pos, EnumFacing.UP, 0.0f, 0.0f, 0.0f);
        return null;
    }
}

