/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.farm.farmers;

import crazypants.enderio.machine.farm.FarmNotification;
import crazypants.enderio.machine.farm.TileFarmStation;
import crazypants.enderio.machine.farm.farmers.HarvestResult;
import crazypants.enderio.machine.farm.farmers.IFarmerJoe;
import crazypants.enderio.machine.farm.farmers.IHarvestResult;
import crazypants.util.Prep;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChorusFlower;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class ChorusFarmer
implements IFarmerJoe {
    private final Item flowerItem = Item.func_150898_a((Block)Blocks.field_185766_cS);
    private static final EnumFacing[] GROW_DIRECTIONS = new EnumFacing[]{EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST};

    @Override
    public boolean canPlant(ItemStack stack) {
        return Prep.isValid(stack) && stack.func_77973_b() == this.flowerItem;
    }

    @Override
    public boolean prepareBlock(TileFarmStation farm, BlockPos pos, Block block, IBlockState state) {
        ItemStack seed = farm.getSeedTypeInSuppliesFor(pos);
        EntityPlayerMP player = farm.getFakePlayer();
        World world = farm.func_145831_w();
        if (this.canPlant(seed) && this.isValidPlantingSpot(world, pos) && player.func_175151_a(pos, EnumFacing.UP, seed) && world.func_175716_a(Blocks.field_185766_cS, pos, false, EnumFacing.UP, (Entity)null, seed)) {
            IBlockState iblockstate1 = Blocks.field_185766_cS.func_176223_P().func_177226_a((IProperty)BlockChorusFlower.field_185607_a, (Comparable)Integer.valueOf(0));
            IBlockState oldState = world.func_180495_p(pos);
            if (this.placeBlockAt(seed, (EntityPlayer)player, world, pos, iblockstate1)) {
                if (Prep.isValid(farm.takeSeedFromSupplies(pos))) {
                    SoundType soundtype = world.func_180495_p(pos).func_177230_c().getSoundType(world.func_180495_p(pos), world, pos, (Entity)player);
                    world.func_184133_a((EntityPlayer)player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                    return true;
                }
                world.func_180501_a(pos, oldState, 3);
            }
        }
        return false;
    }

    private boolean isValidPlantingSpot(World world, BlockPos pos) {
        for (int x = -1; x <= 1; ++x) {
            for (int y = 0; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (world.func_180495_p(pos.func_177982_a(x, y, z)).func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177982_a(x, y, z))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, IBlockState newState) {
        if (!world.func_180501_a(pos, newState, 3)) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == newState.func_177230_c()) {
            state.func_177230_c().func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
        }
        return true;
    }

    @Override
    public boolean canHarvest(TileFarmStation farm, BlockPos bc, Block block, IBlockState state) {
        return state.func_177230_c() == Blocks.field_185765_cR || state.func_177230_c() == Blocks.field_185766_cS;
    }

    @Override
    public IHarvestResult harvestBlock(TileFarmStation farm, BlockPos bc, Block block, IBlockState state) {
        BlockPos remove;
        if (!farm.hasAxe()) {
            farm.setNotification(FarmNotification.NO_AXE);
            return null;
        }
        ChorusWalker walker = new ChorusWalker(farm, bc);
        if (walker.flowersToHarvest.isEmpty() && walker.stemsToHarvest.isEmpty()) {
            return null;
        }
        World world = farm.func_145831_w();
        int fortune = farm.getMaxLootingValue();
        HarvestResult result = new HarvestResult();
        while (!walker.flowersToHarvest.isEmpty() && farm.hasAxe() && farm.hasPower()) {
            remove = walker.flowersToHarvest.remove(0);
            this.doHarvest(farm, world, farm.getBlockState(remove), remove, fortune, result);
        }
        while (!walker.stemsToHarvest.isEmpty() && farm.hasAxe() && farm.hasPower()) {
            remove = walker.stemsToHarvest.remove(walker.stemsToHarvest.size() - 1);
            this.doHarvest(farm, world, farm.getBlockState(remove), remove, fortune, result);
        }
        return result.getDrops().isEmpty() && result.getHarvestedBlocks().isEmpty() ? null : result;
    }

    private void doHarvest(TileFarmStation farm, World world, IBlockState blockState, BlockPos pos, int fortune, HarvestResult result) {
        farm.setJoeUseItem(farm.getTool(TileFarmStation.ToolType.AXE));
        List drops = blockState.func_177230_c().getDrops((IBlockAccess)world, pos, blockState, fortune);
        float chance = ForgeEventFactory.fireBlockHarvesting((List)drops, (World)world, (BlockPos)pos, (IBlockState)blockState, (int)fortune, (float)1.0f, (boolean)false, (EntityPlayer)farm.getFakePlayer());
        if (drops != null) {
            for (ItemStack drop : drops) {
                if (!(farm.func_145831_w().field_73012_v.nextFloat() <= chance)) continue;
                result.drops.add(new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, drop.func_77946_l()));
            }
        }
        blockState.func_177230_c().func_180657_a(farm.getFakePlayer().field_70170_p, (EntityPlayer)farm.getFakePlayer(), pos, blockState, null, farm.getFakePlayer().func_184614_ca());
        farm.clearJoeUseItem(true);
        farm.actionPerformed(true);
        farm.damageAxe(blockState.func_177230_c(), pos);
        world.func_175698_g(pos);
        result.harvestedBlocks.add(pos);
    }

    private static class ChorusWalker {
        final List<BlockPos> flowersToHarvest = new ArrayList<BlockPos>();
        final List<BlockPos> stemsToHarvest = new ArrayList<BlockPos>();
        final TileFarmStation farm;

        ChorusWalker(TileFarmStation farm, BlockPos pos) {
            this.farm = farm;
            this.collect(pos, EnumFacing.DOWN);
        }

        boolean collect(BlockPos pos, EnumFacing from) {
            IBlockState state = this.farm.func_145831_w().func_180495_p(pos);
            if (state.func_177230_c() == Blocks.field_185765_cR) {
                boolean isNeeded = false;
                for (EnumFacing side : GROW_DIRECTIONS) {
                    if (side == from) continue;
                    isNeeded |= this.collect(pos.func_177972_a(side), side.func_176734_d());
                }
                if (!isNeeded) {
                    this.stemsToHarvest.add(pos);
                }
                return isNeeded;
            }
            if (state.func_177230_c() == Blocks.field_185766_cS) {
                if ((Integer)state.func_177229_b((IProperty)BlockChorusFlower.field_185607_a) == 5) {
                    this.flowersToHarvest.add(pos);
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

