/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.farm;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.common.vecmath.Vector4f;
import com.mojang.authlib.GameProfile;
import crazypants.enderio.ModObject;
import crazypants.enderio.capacitor.CapacitorKey;
import crazypants.enderio.capacitor.DefaultCapacitorData;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.AbstractPoweredTaskEntity;
import crazypants.enderio.machine.ContinuousTask;
import crazypants.enderio.machine.FakePlayerEIO;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.IPoweredTask;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.farm.BlockFarmStation;
import crazypants.enderio.machine.farm.FarmNotification;
import crazypants.enderio.machine.farm.Fertilizer;
import crazypants.enderio.machine.farm.PacketFarmAction;
import crazypants.enderio.machine.farm.PacketFarmLockedSlot;
import crazypants.enderio.machine.farm.PacketUpdateNotification;
import crazypants.enderio.machine.farm.PickupWorld;
import crazypants.enderio.machine.farm.farmers.FarmersCommune;
import crazypants.enderio.machine.farm.farmers.IHarvestResult;
import crazypants.enderio.machine.ranged.IRanged;
import crazypants.enderio.machine.ranged.RangeParticle;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.power.PowerHandlerUtil;
import crazypants.util.NullHelper;
import crazypants.util.Prep;
import crazypants.util.Things;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.EnumSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.context.BlockPosContext;
import net.minecraftforge.server.permission.context.IContext;

@Storable
public class TileFarmStation
extends AbstractPoweredTaskEntity
implements IPaintable.IPaintableTileEntity,
IRanged {
    private static final int TICKS_PER_WORK = 20;
    public static Things TREETAPS = new Things(new String[0]);
    private BlockPos lastScanned;
    private FakePlayerEIO farmerJoe;
    private static GameProfile FARMER_PROFILE = new GameProfile(UUID.fromString("c1ddfd7f-120a-4437-8b64-38660d3ec62d"), "[EioFarmer]");
    public static final int NUM_TOOL_SLOTS = 3;
    private static final int minToolSlot = 0;
    private static final int maxToolSlot = 2;
    public static final int NUM_FERTILIZER_SLOTS = 2;
    public static final int minFirtSlot = 3;
    public static final int maxFirtSlot = 4;
    public static final int NUM_SUPPLY_SLOTS = 4;
    public static final int minSupSlot = 5;
    public static final int maxSupSlot = 8;
    @Store
    private int lockedSlots = 0;
    public Set<FarmNotification> notification = EnumSet.noneOf(FarmNotification.class);
    public boolean sendNotification = false;
    private boolean wasActive;
    private int bonemealCooldown = 4;
    private boolean showingRange;
    private static final Vector4f color = new Vector4f(0.5686275f, 0.32156864f, 0.08235294f, 0.4f);

    public TileFarmStation() {
        super(new SlotDefinition(9, 6, 1), CapacitorKey.FARM_POWER_INTAKE, CapacitorKey.FARM_POWER_BUFFER, CapacitorKey.FARM_POWER_USE);
    }

    public int getFarmSize() {
        return (int)(CapacitorKey.FARM_BASE_SIZE.getFloat(this.getCapacitorData()) + CapacitorKey.FARM_BONUS_SIZE.getFloat(this.getCapacitorData()));
    }

    public int getFarmBaseSize() {
        return (int)(CapacitorKey.FARM_BASE_SIZE.getFloat(DefaultCapacitorData.BASIC_CAPACITOR) + CapacitorKey.FARM_BONUS_SIZE.getFloat(DefaultCapacitorData.BASIC_CAPACITOR));
    }

    public void actionPerformed(boolean isAxe) {
        if (isAxe) {
            this.usePower(Config.farmAxeActionEnergyUseRF);
        } else {
            this.usePower(Config.farmActionEnergyUseRF);
        }
        this.clearNotification();
    }

    public boolean tillBlock(BlockPos plantingLocation) {
        boolean doDamage;
        BlockPos dirtLoc = plantingLocation.func_177977_b();
        Block dirtBlock = this.getBlock(dirtLoc);
        if (dirtBlock == Blocks.field_150458_ak) {
            return true;
        }
        ItemStack tool = this.getTool(ToolType.HOE);
        if (Prep.isInvalid(tool)) {
            if (dirtBlock == Blocks.field_150346_d || dirtBlock == Blocks.field_150349_c) {
                this.setNotification(FarmNotification.NO_HOE);
            }
            return false;
        }
        boolean bl = doDamage = this.field_145850_b.field_73012_v.nextFloat() < Config.farmToolTakeDamageChance && this.canDamage(tool);
        if (!doDamage) {
            tool = tool.func_77946_l();
        }
        int origDamage = tool.func_77952_i();
        EnumActionResult itemUse = tool.func_77973_b().func_180614_a(tool, (EntityPlayer)this.farmerJoe, this.field_145850_b, dirtLoc, EnumHand.MAIN_HAND, EnumFacing.UP, 0.5f, 0.5f, 0.5f);
        if (itemUse != EnumActionResult.SUCCESS) {
            return false;
        }
        if (doDamage) {
            if (origDamage == tool.func_77952_i()) {
                tool.func_77972_a(1, (EntityLivingBase)this.farmerJoe);
            }
            if (Prep.isInvalid(tool) || tool.field_77994_a == 0 || tool.func_77952_i() >= tool.func_77958_k()) {
                this.destroyTool(ToolType.HOE);
                this.func_70296_d();
            }
        }
        this.field_145850_b.func_184134_a((double)((float)dirtLoc.func_177958_n() + 0.5f), (double)((float)dirtLoc.func_177956_o() + 0.5f), (double)((float)dirtLoc.func_177952_p() + 0.5f), SoundEvents.field_187579_bV, SoundCategory.BLOCKS, (Blocks.field_150458_ak.func_185467_w().func_185843_a() + 1.0f) / 2.0f, Blocks.field_150458_ak.func_185467_w().func_185847_b() * 0.8f, false);
        this.actionPerformed(false);
        return true;
    }

    public int getMaxLootingValue() {
        int result = 0;
        for (int i = 0; i <= 2; ++i) {
            int level;
            if (!Prep.isValid(this.inventory[i]) || (level = this.getLooting(this.inventory[i])) <= result) continue;
            result = level;
        }
        return result;
    }

    public boolean hasHoe() {
        return this.hasTool(ToolType.HOE);
    }

    public boolean hasAxe() {
        return this.hasTool(ToolType.AXE);
    }

    public boolean hasShears() {
        return this.hasTool(ToolType.SHEARS);
    }

    public int getAxeLootingValue() {
        ItemStack tool = this.getTool(ToolType.AXE);
        if (Prep.isInvalid(tool)) {
            return 0;
        }
        return this.getLooting(tool);
    }

    public void damageAxe(Block blk, BlockPos bc) {
        this.damageTool(ToolType.AXE, blk, bc, 1);
    }

    public void damageHoe(int i, BlockPos bc) {
        this.damageTool(ToolType.HOE, null, bc, i);
    }

    public void damageShears(Block blk, BlockPos bc) {
        this.damageTool(ToolType.SHEARS, blk, bc, 1);
    }

    public boolean hasTool(ToolType type) {
        return this.getTool(type) != null;
    }

    private boolean isDryRfTool(ItemStack stack) {
        if (!Config.farmEvictEmptyRFTools || Prep.isInvalid(stack)) {
            return false;
        }
        IEnergyStorage cap = PowerHandlerUtil.getCapability((ICapabilityProvider)stack, null);
        if (cap == null) {
            return false;
        }
        return cap.getMaxEnergyStored() > 0 && cap.getEnergyStored() <= 0;
    }

    public ItemStack getTool(ToolType type) {
        block5: for (int i = 0; i <= 2; ++i) {
            if (ToolType.isBrokenTinkerTool(this.inventory[i]) || this.isDryRfTool(this.inventory[i])) {
                for (int j = this.slotDefinition.minOutputSlot; j <= this.slotDefinition.maxOutputSlot; ++j) {
                    if (!Prep.isInvalid(this.inventory[j])) continue;
                    this.inventory[j] = this.inventory[i];
                    this.inventory[i] = Prep.getEmpty();
                    this.func_70296_d();
                    continue block5;
                }
                continue;
            }
            if (!type.itemMatches(this.inventory[i]) || this.inventory[i].field_77994_a <= 0) continue;
            switch (type) {
                case AXE: {
                    this.removeNotification(FarmNotification.NO_AXE);
                    break;
                }
                case HOE: {
                    this.removeNotification(FarmNotification.NO_HOE);
                    break;
                }
                case TREETAP: {
                    this.removeNotification(FarmNotification.NO_TREETAP);
                    break;
                }
            }
            return this.inventory[i];
        }
        return Prep.getEmpty();
    }

    public void damageTool(ToolType type, Block blk, BlockPos bc, int damage) {
        ItemStack tool = this.getTool(type);
        if (Prep.isInvalid(tool)) {
            return;
        }
        float rand = this.field_145850_b.field_73012_v.nextFloat();
        if (rand >= Config.farmToolTakeDamageChance) {
            return;
        }
        IBlockState bs = this.getBlockState(bc);
        boolean canDamage = this.canDamage(tool);
        if (type == ToolType.AXE) {
            tool.func_77973_b().func_179218_a(tool, this.field_145850_b, bs, bc, (EntityLivingBase)this.farmerJoe);
        } else if (type == ToolType.HOE) {
            int origDamage = tool.func_77952_i();
            tool.func_77973_b().func_180614_a(tool, (EntityPlayer)this.farmerJoe, this.field_145850_b, bc, EnumHand.MAIN_HAND, EnumFacing.UP, 0.5f, 0.5f, 0.5f);
            if (origDamage == tool.func_77952_i() && canDamage) {
                tool.func_77972_a(1, (EntityLivingBase)this.farmerJoe);
            }
        } else if (canDamage) {
            tool.func_77972_a(1, (EntityLivingBase)this.farmerJoe);
        }
        if (Prep.isInvalid(tool) || tool.field_77994_a == 0 || canDamage && tool.func_77952_i() >= tool.func_77958_k()) {
            this.destroyTool(type);
            this.func_70296_d();
        }
    }

    private boolean canDamage(ItemStack stack) {
        return Prep.isValid(stack) && stack.func_77984_f() && stack.func_77973_b().func_77645_m();
    }

    private void destroyTool(ToolType type) {
        for (int i = 0; i <= 2; ++i) {
            if (!Prep.isValid(this.inventory[i]) || !type.itemMatches(this.inventory[i]) || this.inventory[i].field_77994_a != 0) continue;
            this.inventory[i] = Prep.getEmpty();
            return;
        }
    }

    private int getLooting(ItemStack stack) {
        return Math.max(EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185304_p, (ItemStack)stack), EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack));
    }

    public EntityPlayerMP getFakePlayer() {
        return this.farmerJoe;
    }

    public Block getBlock(BlockPos posIn) {
        return this.getBlockState(posIn).func_177230_c();
    }

    public IBlockState getBlockState(BlockPos posIn) {
        return this.field_145850_b.func_180495_p(posIn);
    }

    public boolean isOpen(BlockPos bc) {
        IBlockState bs;
        Block block = this.getBlock(bc);
        return block.isAir(bs = this.getBlockState(bc), (IBlockAccess)this.field_145850_b, bc) || block.func_176200_f((IBlockAccess)this.field_145850_b, bc);
    }

    public void setNotification(FarmNotification note) {
        if (!this.notification.contains((Object)note)) {
            this.notification.add(note);
            this.sendNotification = true;
        }
    }

    public void removeNotification(FarmNotification note) {
        if (this.notification.remove((Object)note)) {
            this.sendNotification = true;
        }
    }

    public void clearNotification() {
        if (this.hasNotification()) {
            this.notification.clear();
            this.sendNotification = true;
        }
    }

    public boolean hasNotification() {
        return !this.notification.isEmpty();
    }

    private void sendNotification() {
        PacketHandler.INSTANCE.sendToAll((IMessage)new PacketUpdateNotification(this, this.notification));
    }

    @Override
    public boolean isMachineItemValidForSlot(int i, ItemStack stack) {
        if (Prep.isInvalid(stack)) {
            return false;
        }
        if (i <= 2) {
            if (ToolType.isTool(stack)) {
                for (int j = 0; j <= 2; ++j) {
                    if (!ToolType.getToolType(stack).itemMatches(this.inventory[j])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (i <= 4) {
            return Fertilizer.isFertilizer(stack);
        }
        if (i <= 8) {
            return (Prep.isValid(this.inventory[i]) || !this.isSlotLocked(i)) && FarmersCommune.instance.canPlant(stack);
        }
        return false;
    }

    @Override
    public void doUpdate() {
        super.doUpdate();
        if (this.isActive() != this.wasActive) {
            this.wasActive = this.isActive();
            this.field_145850_b.func_180500_c(EnumSkyBlock.BLOCK, this.field_174879_c);
        }
    }

    @Override
    protected boolean checkProgress(boolean redstoneChecksPassed) {
        if (this.shouldDoWorkThisTick(7200)) {
            this.clearNotification();
        }
        if (redstoneChecksPassed) {
            this.usePower();
            if (this.canTick(redstoneChecksPassed)) {
                this.doTick();
            }
        }
        return false;
    }

    protected boolean canTick(boolean redstoneChecksPassed) {
        if (!this.shouldDoWorkThisTick(2)) {
            return false;
        }
        if (this.getEnergyStored() < this.getPowerUsePerTick()) {
            this.setNotification(FarmNotification.NO_POWER);
            return false;
        }
        return true;
    }

    protected void doTick() {
        Fertilizer fertilizer;
        IHarvestResult harvest;
        if (this.sendNotification && this.shouldDoWorkThisTick(20)) {
            this.sendNotification = false;
            this.sendNotification();
        }
        if (!this.hasPower() && Config.farmActionEnergyUseRF > 0 && Config.farmAxeActionEnergyUseRF > 0) {
            this.setNotification(FarmNotification.NO_POWER);
            return;
        }
        this.removeNotification(FarmNotification.NO_POWER);
        if (this.farmerJoe == null) {
            this.farmerJoe = new FakePlayerEIO(this.field_145850_b, this.getLocation(), FARMER_PROFILE);
            this.farmerJoe.setOwner(this.getOwner());
            this.farmerJoe.field_70170_p = new PickupWorld(this.field_145850_b, this.farmerJoe);
        }
        BlockPos bc = null;
        IBlockState bs = null;
        int infiniteLoop = 20;
        while (bc == null || bc.equals((Object)this.func_174877_v()) || !this.field_145850_b.func_175667_e(bc) || !PermissionAPI.hasPermission((GameProfile)this.getOwner().getAsGameProfile(), (String)BlockFarmStation.permissionFarming, (IContext)new BlockPosContext((EntityPlayer)this.farmerJoe, bc, bs, null))) {
            if (infiniteLoop-- <= 0) {
                return;
            }
            bc = this.getNextCoord();
            bs = this.getBlockState(bc);
        }
        Block block = bs.func_177230_c();
        if (this.isOpen(bc)) {
            FarmersCommune.instance.prepareBlock(this, bc, block, bs);
            bs = this.getBlockState(bc);
            block = bs.func_177230_c();
        }
        if (this.isOutputFull()) {
            this.setNotification(FarmNotification.OUTPUT_FULL);
            return;
        }
        this.removeNotification(FarmNotification.OUTPUT_FULL);
        if (!this.hasPower() && Config.farmActionEnergyUseRF > 0 && Config.farmAxeActionEnergyUseRF > 0) {
            this.setNotification(FarmNotification.NO_POWER);
            return;
        }
        if (!this.isOpen(bc) && (harvest = FarmersCommune.instance.harvestBlock(this, bc, block, bs)) != null) {
            boolean done = false;
            if (harvest.getHarvestedBlocks() != null && !harvest.getHarvestedBlocks().isEmpty()) {
                PacketFarmAction pkt = new PacketFarmAction(harvest.getHarvestedBlocks());
                PacketHandler.INSTANCE.sendToAllAround((IMessage)pkt, new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)bc.func_177958_n(), (double)bc.func_177956_o(), (double)bc.func_177952_p(), 64.0));
                done = true;
            }
            if (harvest.getDrops() != null) {
                for (EntityItem ei : harvest.getDrops()) {
                    if (ei == null) continue;
                    this.insertHarvestDrop((Entity)ei, bc);
                    if (!ei.field_70128_L) {
                        this.field_145850_b.func_72838_d((Entity)ei);
                    }
                    done = true;
                }
            }
            if (done) {
                return;
            }
        }
        if (!(this.hasPower() || Config.farmBonemealActionEnergyUseRF <= 0 && Config.farmBonemealTryEnergyUseRF <= 0)) {
            this.setNotification(FarmNotification.NO_POWER);
            return;
        }
        if (this.hasBonemeal() && this.bonemealCooldown-- <= 0 && this.random.nextFloat() <= 0.75f && ((fertilizer = Fertilizer.getInstance(this.inventory[3])).applyOnPlant() != this.isOpen(bc) || fertilizer.applyOnAir() == this.field_145850_b.func_175623_d(bc))) {
            this.setJoeUseItem(this.inventory[3]);
            if (fertilizer.apply(this.inventory[3], (EntityPlayer)this.farmerJoe, this.field_145850_b, bc)) {
                this.inventory[3] = this.clearJoeUseItem(true);
                PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFarmAction(bc), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)bc.func_177958_n(), (double)bc.func_177956_o(), (double)bc.func_177952_p(), 64.0));
                if (Prep.isValid(this.inventory[3]) && this.inventory[3].field_77994_a == 0) {
                    this.inventory[3] = Prep.getEmpty();
                }
                this.usePower(Config.farmBonemealActionEnergyUseRF);
                this.bonemealCooldown = 16;
            } else {
                this.usePower(Config.farmBonemealTryEnergyUseRF);
                this.bonemealCooldown = 4;
            }
            this.clearJoeUseItem(true);
        }
    }

    public void setJoeUseItem(ItemStack item) {
        this.farmerJoe.field_71071_by.field_70462_a[0] = item;
        this.farmerJoe.field_71071_by.field_70461_c = 0;
    }

    public ItemStack clearJoeUseItem(boolean retreiveHandItem) {
        ItemStack item = Prep.getEmpty();
        if (retreiveHandItem) {
            item = this.farmerJoe.field_71071_by.field_70462_a[0];
            this.farmerJoe.field_71071_by.field_70462_a[0] = Prep.getEmpty();
        }
        ItemStack[] inv = this.farmerJoe.field_71071_by.field_70462_a;
        for (int slot = 0; slot < inv.length; ++slot) {
            ItemStack stack = inv[slot];
            if (!Prep.isValid(stack)) continue;
            inv[slot] = null;
            this.insertItem(stack);
        }
        return item;
    }

    private boolean hasBonemeal() {
        if (Prep.isValid(this.inventory[3])) {
            return true;
        }
        for (int i = 4; i <= 4; ++i) {
            if (!Prep.isValid(this.inventory[i])) continue;
            this.inventory[3] = this.inventory[i];
            this.inventory[i] = Prep.getEmpty();
            return true;
        }
        return false;
    }

    private boolean isOutputFull() {
        for (int i = this.slotDefinition.minOutputSlot; i <= this.slotDefinition.maxOutputSlot; ++i) {
            ItemStack curStack = this.inventory[i];
            if (!Prep.isInvalid(curStack) && (Config.farmStopOnNoOutputSlots || curStack.field_77994_a >= curStack.func_77976_d())) continue;
            return false;
        }
        return true;
    }

    public boolean hasSeed(ItemStack seeds, BlockPos bc) {
        int slot = this.getSupplySlotForCoord(bc);
        ItemStack inv = this.inventory[slot];
        return Prep.isValid(inv) && (inv.field_77994_a > 1 || !this.isSlotLocked(slot)) && inv.func_77969_a(seeds);
    }

    public int isLowOnSaplings(BlockPos bc) {
        int slot = this.getSupplySlotForCoord(bc);
        ItemStack inv = this.inventory[slot];
        return 90 * (Config.farmSaplingReserveAmount - (Prep.isInvalid(inv) ? 0 : inv.field_77994_a)) / Config.farmSaplingReserveAmount;
    }

    public ItemStack takeSeedFromSupplies(ItemStack stack, BlockPos forBlock) {
        return this.takeSeedFromSupplies(stack, forBlock, true);
    }

    public ItemStack takeSeedFromSupplies(ItemStack stack, BlockPos forBlock, boolean matchMetadata) {
        if (Prep.isInvalid(stack) || forBlock == null) {
            return null;
        }
        int slot = this.getSupplySlotForCoord(forBlock);
        ItemStack inv = this.inventory[slot];
        if (Prep.isValid(inv) && (matchMetadata ? inv.func_77969_a(stack) : inv.func_77973_b() == stack.func_77973_b())) {
            if (inv.field_77994_a <= 1 && this.isSlotLocked(slot)) {
                return null;
            }
            ItemStack result = inv.func_77946_l();
            result.field_77994_a = 1;
            inv = inv.func_77946_l();
            --inv.field_77994_a;
            if (inv.field_77994_a == 0) {
                inv = Prep.getEmpty();
            }
            this.func_70299_a(slot, inv);
            return result;
        }
        return null;
    }

    public ItemStack takeSeedFromSupplies(BlockPos bc) {
        return this.takeSeedFromSupplies(this.getSeedTypeInSuppliesFor(bc), bc);
    }

    public ItemStack getSeedTypeInSuppliesFor(BlockPos bc) {
        int slot = this.getSupplySlotForCoord(bc);
        return this.getSeedTypeInSuppliesFor(slot);
    }

    public ItemStack getSeedTypeInSuppliesFor(int slot) {
        ItemStack inv = this.inventory[slot];
        if (Prep.isValid(inv) && (inv.field_77994_a > 1 || !this.isSlotLocked(slot))) {
            return inv.func_77946_l();
        }
        return Prep.getEmpty();
    }

    public int getSupplySlotForCoord(BlockPos forBlock) {
        int xCoord = this.func_174877_v().func_177958_n();
        int zCoord = this.func_174877_v().func_177952_p();
        if (forBlock.func_177958_n() <= xCoord && forBlock.func_177952_p() > zCoord) {
            return 5;
        }
        if (forBlock.func_177958_n() > xCoord && forBlock.func_177952_p() > zCoord - 1) {
            return 6;
        }
        if (forBlock.func_177958_n() < xCoord && forBlock.func_177952_p() <= zCoord) {
            return 7;
        }
        return 8;
    }

    private void insertHarvestDrop(Entity entity, BlockPos bc) {
        if (!this.field_145850_b.field_72995_K && entity instanceof EntityItem && !entity.field_70128_L) {
            EntityItem item = (EntityItem)entity;
            ItemStack stack = item.func_92059_d();
            if (Prep.isValid(stack)) {
                stack = stack.func_77946_l();
                int numInserted = this.insertResult(stack, bc);
                stack.field_77994_a -= numInserted;
                item.func_92058_a(stack);
                if (stack.field_77994_a == 0) {
                    item.func_70106_y();
                }
            } else {
                item.func_70106_y();
            }
        }
    }

    private void insertItem(ItemStack stack) {
        int numInserted = this.insertResult(stack, this.func_174877_v());
        stack.field_77994_a -= numInserted;
        if (Prep.isValid(stack) && stack.field_77994_a > 0) {
            EntityItem entityItem = new EntityItem(this.func_145831_w(), (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, stack);
            this.func_145831_w().func_72838_d((Entity)entityItem);
        }
    }

    private int insertResult(ItemStack stack, BlockPos bc) {
        int slot = bc != null ? this.getSupplySlotForCoord(bc) : 5;
        int[] slots = new int[4];
        int k = 0;
        int j = slot;
        while (j <= 8) {
            slots[k++] = j++;
        }
        j = 5;
        while (j < slot) {
            slots[k++] = j++;
        }
        int origSize = stack.field_77994_a;
        stack = stack.func_77946_l();
        int inserted = 0;
        for (int j2 = 0; j2 < slots.length && inserted < stack.field_77994_a; ++j2) {
            int i = slots[j2];
            ItemStack curStack = this.inventory[i];
            int inventoryStackLimit = this.getInventoryStackLimit(i);
            if (!this.func_94041_b(i, stack)) continue;
            if (Prep.isInvalid(curStack)) {
                if (stack.field_77994_a < inventoryStackLimit) {
                    this.inventory[i] = stack.func_77946_l();
                    inserted = stack.field_77994_a;
                    continue;
                }
                this.inventory[i] = stack.func_77946_l();
                this.inventory[i].field_77994_a = inserted = inventoryStackLimit;
                continue;
            }
            if (curStack.field_77994_a >= inventoryStackLimit || !curStack.func_77969_a(stack)) continue;
            inserted = Math.min(inventoryStackLimit - curStack.field_77994_a, stack.field_77994_a);
            this.inventory[i].field_77994_a += inserted;
        }
        stack.field_77994_a -= inserted;
        if (inserted >= origSize) {
            return origSize;
        }
        IMachineRecipe.ResultStack[] in = new IMachineRecipe.ResultStack[]{new IMachineRecipe.ResultStack(stack)};
        this.mergeResults(in);
        return origSize - (Prep.isInvalid(in[0].item) ? 0 : in[0].item.field_77994_a);
    }

    @Nonnull
    private BlockPos getNextCoord() {
        int size = this.getFarmSize();
        BlockPos loc = this.func_174877_v();
        if (this.lastScanned == null) {
            this.lastScanned = NullHelper.notnullM(loc.func_177982_a(-size, 0, -size), "BlockPos.add()");
            return this.lastScanned;
        }
        int nextX = this.lastScanned.func_177958_n() + 1;
        int nextZ = this.lastScanned.func_177952_p();
        if (nextX > loc.func_177958_n() + size) {
            nextX = loc.func_177958_n() - size;
            if (++nextZ > loc.func_177952_p() + size) {
                nextX = loc.func_177958_n() - size;
                nextZ = loc.func_177952_p() - size;
            }
        }
        this.lastScanned = new BlockPos(nextX, this.lastScanned.func_177956_o(), nextZ);
        return this.lastScanned;
    }

    public void toggleLockedState(int slot) {
        if (this.field_145850_b.field_72995_K) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketFarmLockedSlot(this, slot));
        }
        this.setSlotLocked(slot, !this.isSlotLocked(slot));
    }

    public boolean isSlotLocked(int slot) {
        return (this.lockedSlots & 1 << slot) != 0;
    }

    private void setSlotLocked(int slot, boolean value) {
        this.lockedSlots = value ? (this.lockedSlots |= 1 << slot) : (this.lockedSlots &= ~(1 << slot));
    }

    @Override
    public boolean func_145818_k_() {
        return false;
    }

    @Override
    @Nonnull
    public String getMachineName() {
        return ModObject.blockFarmStation.getUnlocalisedName();
    }

    @Override
    public float getProgress() {
        return 0.5f;
    }

    @Override
    public void onCapacitorDataChange() {
        super.onCapacitorDataChange();
        this.currentTask = this.createTask(null, 0.0f);
    }

    @Override
    protected IPoweredTask createTask(IMachineRecipe nextRecipe, float chance) {
        return new ContinuousTask(this.getPowerUsePerTick());
    }

    @Override
    public int getInventoryStackLimit(int slot) {
        if (slot >= 5 && slot <= 8) {
            return Math.min(CapacitorKey.FARM_STACK_LIMIT.get(this.getCapacitorData()), 64);
        }
        return 64;
    }

    @Override
    public int func_70297_j_() {
        return this.getInventoryStackLimit(5);
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isShowingRange() {
        return this.showingRange;
    }

    @SideOnly(value=Side.CLIENT)
    public void setShowRange(boolean showRange) {
        if (this.showingRange == showRange) {
            return;
        }
        this.showingRange = showRange;
        if (this.showingRange) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a(new RangeParticle<TileFarmStation>(this, color));
        }
    }

    @Override
    public BoundingBox getBounds() {
        return new BoundingBox(this.func_174877_v()).expand((double)this.getRange(), 0.0, (double)this.getRange());
    }

    public float getRange() {
        return this.getFarmSize();
    }

    public static enum ToolType {
        HOE{

            @Override
            boolean match(ItemStack item) {
                return Config.farmHoes.contains(item);
            }
        }
        ,
        AXE{

            @Override
            boolean match(ItemStack item) {
                return item.func_77973_b().getHarvestLevel(item, "axe", null, null) >= 0;
            }
        }
        ,
        TREETAP{

            @Override
            boolean match(ItemStack item) {
                return TREETAPS.contains(item);
            }
        }
        ,
        SHEARS{

            @Override
            boolean match(ItemStack item) {
                return item.func_77973_b() instanceof ItemShears;
            }
        }
        ,
        NONE{

            @Override
            boolean match(ItemStack item) {
                return false;
            }
        };


        public final boolean itemMatches(ItemStack item) {
            return Prep.isValid(item) && this.match(item) && !ToolType.isBrokenTinkerTool(item);
        }

        private static boolean isBrokenTinkerTool(ItemStack item) {
            return Prep.isValid(item) && item.func_77942_o() && item.func_77978_p().func_74764_b("Stats") && item.func_77978_p().func_74775_l("Stats").func_74767_n("Broken");
        }

        abstract boolean match(ItemStack var1);

        public static boolean isTool(ItemStack stack) {
            for (ToolType type : ToolType.values()) {
                if (!type.itemMatches(stack)) continue;
                return true;
            }
            return false;
        }

        public static ToolType getToolType(ItemStack stack) {
            for (ToolType type : ToolType.values()) {
                if (!type.itemMatches(stack)) continue;
                return type;
            }
            return NONE;
        }
    }
}

