/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine;

import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.CycleButton;
import com.google.common.collect.Lists;
import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.gui.IconEIO;
import java.util.List;
import java.util.Locale;
import net.minecraft.tileentity.TileEntity;

public enum RedstoneControlMode {
    IGNORE,
    ON,
    OFF,
    NEVER;

    public static final int MIN_ON_LEVEL = 1;

    public static boolean isConditionMet(RedstoneControlMode redstoneControlMode, int powerLevel) {
        switch (redstoneControlMode) {
            case IGNORE: {
                return true;
            }
            case NEVER: {
                return false;
            }
            case OFF: {
                return powerLevel == 0;
            }
            case ON: {
                return powerLevel > 0;
            }
        }
        return false;
    }

    public static boolean isConditionMet(RedstoneControlMode redstoneControlMode, TileEntity te) {
        switch (redstoneControlMode) {
            case IGNORE: {
                return true;
            }
            case NEVER: {
                return false;
            }
        }
        return RedstoneControlMode.isConditionMet(redstoneControlMode, ConduitUtil.isBlockIndirectlyGettingPoweredIfLoaded(te.func_145831_w(), te.func_174877_v()));
    }

    public RedstoneControlMode next() {
        int ord = this.ordinal();
        ord = ord == RedstoneControlMode.values().length - 1 ? 0 : ++ord;
        return RedstoneControlMode.values()[ord];
    }

    public RedstoneControlMode previous() {
        int ord = this.ordinal();
        if (--ord < 0) {
            ord = RedstoneControlMode.values().length - 1;
        }
        return RedstoneControlMode.values()[ord];
    }

    public static enum IconHolder implements CycleButton.ICycleEnum
    {
        IGNORE(IGNORE, IconEIO.REDSTONE_MODE_ALWAYS),
        ON(ON, IconEIO.REDSTONE_MODE_WITH_SIGNAL),
        OFF(OFF, IconEIO.REDSTONE_MODE_WITHOUT_SIGNAL),
        NEVER(NEVER, IconEIO.REDSTONE_MODE_NEVER);

        private final RedstoneControlMode mode;
        private final IWidgetIcon icon;

        private IconHolder(RedstoneControlMode mode, IWidgetIcon icon) {
            this.mode = mode;
            this.icon = icon;
        }

        public String getTooltip() {
            return EnderIO.lang.localize("gui.tooltip.redstoneControlMode." + this.name().toLowerCase(Locale.US));
        }

        public IWidgetIcon getIcon() {
            return this.icon;
        }

        public List<String> getTooltipLines() {
            return Lists.newArrayList((Object[])new String[]{this.getTooltip()});
        }

        public RedstoneControlMode getMode() {
            return this.mode;
        }

        public static IconHolder getFromMode(RedstoneControlMode mode) {
            for (IconHolder holder : IconHolder.values()) {
                if (holder.mode != mode) continue;
                return holder;
            }
            return IGNORE;
        }
    }
}

