/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.loot;

import crazypants.enderio.EnderIO;
import crazypants.enderio.Log;
import crazypants.enderio.ModObject;
import crazypants.enderio.capacitor.CapacitorHelper;
import crazypants.enderio.loot.LootSelector;
import crazypants.enderio.loot.WeightedUpgrade;
import crazypants.util.NbtValue;
import crazypants.util.Prep;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;

public class AnvilCapacitorRecipe {
    public static void create() {
        MinecraftForge.EVENT_BUS.register(AnvilCapacitorRecipe.class);
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public static void handleAnvilEvent(AnvilUpdateEvent evt) {
        void var9_14;
        ItemStack left = evt.getLeft();
        ItemStack right = evt.getRight();
        if (Prep.isInvalid(left) || Prep.isInvalid(right) || left.func_77973_b() != ModObject.itemBasicCapacitor.getItem() || right.func_77973_b() != ModObject.itemBasicCapacitor.getItem() || left.func_77960_j() != 3 || right.func_77960_j() != 3) {
            return;
        }
        List<Pair<String, Float>> dataLeft = CapacitorHelper.getCapDataRaw(left);
        List<Pair<String, Float>> dataRight = CapacitorHelper.getCapDataRaw(right);
        if (dataLeft == null || dataRight == null || dataLeft.isEmpty() || dataRight.isEmpty()) {
            return;
        }
        HashMap<WeightedUpgrade, Pair> data = new HashMap<WeightedUpgrade, Pair>();
        float seed = 0.0f;
        for (Pair<String, Float> pair : dataLeft) {
            WeightedUpgrade weightedUpgrade = WeightedUpgrade.getByRawString((String)pair.getKey());
            if (weightedUpgrade == null) {
                return;
            }
            data.put(weightedUpgrade, Pair.of((Object)pair.getValue(), (Object)null));
            seed += ((Float)pair.getValue()).floatValue();
        }
        for (Pair<String, Float> pair : dataRight) {
            WeightedUpgrade weightedUpgrade = WeightedUpgrade.getByRawString((String)pair.getKey());
            if (weightedUpgrade == null) {
                return;
            }
            if (data.containsKey((Object)weightedUpgrade)) {
                data.put(weightedUpgrade, Pair.of((Object)pair.getValue(), (Object)((Pair)data.get((Object)weightedUpgrade)).getKey()));
            } else {
                data.put(weightedUpgrade, Pair.of((Object)pair.getValue(), (Object)null));
            }
            seed += ((Float)pair.getValue()).floatValue();
        }
        Random rand = new Random((long)(seed * 1000.0f));
        HashMap<WeightedUpgrade, Float> result = new HashMap<WeightedUpgrade, Float>();
        for (WeightedUpgrade wa : WeightedUpgrade.values()) {
            if (!data.containsKey((Object)wa)) continue;
            float combine = AnvilCapacitorRecipe.combine(rand, (Pair<Float, Float>)((Pair)data.get((Object)wa)));
            result.put(wa, Float.valueOf(combine));
            Log.debug("Combining " + (Object)((Object)wa) + " " + ((Pair)data.get((Object)wa)).getKey() + " and " + ((Pair)data.get((Object)wa)).getValue() + " to " + combine);
        }
        int n = Math.max(CapacitorHelper.getCapLevelRaw(left), CapacitorHelper.getCapLevelRaw(right));
        if (n < 5 && rand.nextFloat() < 0.5f) {
            ++var9_14;
        }
        ItemStack stack = left.func_77946_l();
        String name = LootSelector.buildBaseName(EnderIO.lang.localize("itemBasicCapacitor.name"), (float)var9_14);
        stack = CapacitorHelper.addCapData(stack, CapacitorHelper.SetType.LEVEL, null, (float)var9_14);
        for (Map.Entry entry : result.entrySet()) {
            stack = CapacitorHelper.addCapData(stack, ((WeightedUpgrade)((Object)entry.getKey())).setType, ((WeightedUpgrade)((Object)entry.getKey())).capacitorKey, ((Float)entry.getValue()).floatValue());
            name = LootSelector.buildName(EnderIO.lang.localize(((WeightedUpgrade)((Object)entry.getKey())).langKey, new Object[]{name}), ((Float)entry.getValue()).floatValue());
        }
        NbtValue.CAPNAME.setString(stack, name);
        evt.setOutput(stack);
        evt.setCost((int)(var9_14 * var9_14));
    }

    private static float combine(Random rand, Pair<Float, Float> pair) {
        if (pair.getRight() == null) {
            return ((Float)pair.getLeft()).floatValue();
        }
        return AnvilCapacitorRecipe.combine(rand, ((Float)pair.getLeft()).floatValue(), ((Float)pair.getRight()).floatValue());
    }

    private static float combine(Random rand, float a, float b) {
        float min = a < b ? a : b;
        float center = a < b ? b : a;
        float offsetLow = center - min;
        float max = Math.min(center + offsetLow, 4.75f);
        float offsetHigh = max - center;
        float gaussian = (float)rand.nextGaussian();
        if (gaussian <= 0.0f) {
            return Math.max(min, center - gaussian * offsetLow);
        }
        return Math.min(max, center + gaussian * offsetHigh);
    }
}

