/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.config.recipes.xml;

import crazypants.enderio.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.config.recipes.StaxFactory;
import crazypants.enderio.config.recipes.xml.AbstractCrafting;
import crazypants.enderio.config.recipes.xml.FloatItem;
import crazypants.enderio.integration.tic.TicProxy;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class Smelting
extends AbstractCrafting {
    private Float exp;
    private boolean tinkers = false;
    private boolean vanilla = true;
    private FloatItem input;

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        try {
            super.readResolve();
            if (this.exp == null) {
                if (this.valid) {
                    this.exp = Float.valueOf(FurnaceRecipes.func_77602_a().func_151398_b(this.getOutput().getItemStack()));
                }
            } else {
                if (this.exp.floatValue() < 0.0f) {
                    throw new InvalidRecipeConfigException("Invalid negative value for 'exp'");
                }
                if (this.exp.floatValue() > 1.0f) {
                    throw new InvalidRecipeConfigException("Invalid value for 'exp', above 100%");
                }
            }
            if (this.input == null) {
                throw new InvalidRecipeConfigException("Missing <input>");
            }
            if (!this.vanilla && !this.tinkers) {
                throw new InvalidRecipeConfigException("One or more of 'vanilla' or 'tinkers' must be enabled");
            }
            if (this.vanilla && this.input.amount != 1.0f) {
                throw new InvalidRecipeConfigException("For 'vanilla' setting an input amount is not valid");
            }
            this.valid = this.valid && this.input.isValid();
        }
        catch (InvalidRecipeConfigException e) {
            throw new InvalidRecipeConfigException(e, "in <crafting>");
        }
        return this;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
        super.enforceValidity();
        this.input.enforceValidity();
    }

    @Override
    public void register() {
        if (this.isValid() && this.isActive()) {
            if (this.vanilla) {
                GameRegistry.addSmelting((ItemStack)this.input.getItemStack(), (ItemStack)this.getOutput().getItemStack(), (float)this.exp.floatValue());
            }
            if (this.tinkers) {
                TicProxy.registerSmelterySmelting(this.input.getItemStack(), this.getOutput().getItemStack(), 1.0f / this.input.amount);
            }
        }
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        if ("exp".equals(name)) {
            this.exp = Float.valueOf(Float.parseFloat(value));
            return true;
        }
        if ("tinkers".equals(name)) {
            this.tinkers = Boolean.parseBoolean(value);
            return true;
        }
        if ("vanilla".equals(name)) {
            this.vanilla = Boolean.parseBoolean(value);
            return true;
        }
        return super.setAttribute(factory, name, value);
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        if ("input".equals(name) && this.input == null) {
            this.input = factory.read(new FloatItem(), startElement);
            return true;
        }
        return super.setElement(factory, name, startElement);
    }
}

