/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.packet;

import com.enderio.core.common.util.DyeColor;
import crazypants.enderio.conduit.packet.AbstractConduitPacket;
import crazypants.enderio.conduit.redstone.IRedstoneConduit;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketRedstoneConduitSignalColor
extends AbstractConduitPacket<IRedstoneConduit>
implements IMessageHandler<PacketRedstoneConduitSignalColor, IMessage> {
    private EnumFacing dir;
    private DyeColor col;

    public PacketRedstoneConduitSignalColor() {
    }

    public PacketRedstoneConduitSignalColor(IRedstoneConduit con, EnumFacing dir) {
        super(con.getBundle().getEntity(), con);
        this.dir = dir;
        this.col = con.getSignalColor(dir);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        if (this.dir == null) {
            buf.writeShort(-1);
        } else {
            buf.writeShort(this.dir.ordinal());
        }
        buf.writeShort(this.col.ordinal());
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        short ord = buf.readShort();
        this.dir = ord < 0 ? null : EnumFacing.values()[ord];
        this.col = DyeColor.values()[buf.readShort()];
    }

    public IMessage onMessage(PacketRedstoneConduitSignalColor message, MessageContext ctx) {
        ((IRedstoneConduit)message.getTileCasted(ctx)).setSignalColor(message.dir, message.col);
        IBlockState bs = message.getWorld(ctx).func_180495_p(message.getPos());
        message.getWorld(ctx).func_184138_a(message.getPos(), bs, bs, 3);
        return null;
    }
}

