/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.item.filter;

import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.CycleButton;
import crazypants.enderio.EnderIO;
import crazypants.enderio.gui.IconEIO;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum SpeciesMode {
    BOTH,
    PRIMARY,
    SECONDARY;


    public SpeciesMode next() {
        SpeciesMode[] values = SpeciesMode.values();
        return values[(this.ordinal() + 1) % values.length];
    }

    @SideOnly(value=Side.CLIENT)
    public static enum IconHolder implements CycleButton.ICycleEnum
    {
        BOTH(BOTH, IconEIO.FILTER_SPECIES_BOTH),
        PRIMARY(PRIMARY, IconEIO.FILTER_SPECIES_PRIMARY),
        SECONDARY(SECONDARY, IconEIO.FILTER_SPECIES_SECONDARY);

        private final SpeciesMode mode;
        private final IWidgetIcon icon;

        private IconHolder(SpeciesMode mode, IWidgetIcon icon) {
            this.mode = mode;
            this.icon = icon;
        }

        public IWidgetIcon getIcon() {
            return this.icon;
        }

        public List<String> getTooltipLines() {
            return Collections.singletonList(EnderIO.lang.localize("gui.conduit.item.species.".concat(this.name().toLowerCase(Locale.US))));
        }

        public SpeciesMode getMode() {
            return this.mode;
        }

        public static IconHolder getFromMode(SpeciesMode mode) {
            for (IconHolder holder : IconHolder.values()) {
                if (holder.mode != mode) continue;
                return holder;
            }
            return BOTH;
        }
    }
}

