/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.gui.item;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.ColorButton;
import com.enderio.core.client.gui.button.MultiIconButton;
import com.enderio.core.client.gui.button.ToggleButton;
import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.client.render.EnderWidget;
import com.enderio.core.common.util.DyeColor;
import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.gui.BaseSettingsPanel;
import crazypants.enderio.conduit.gui.FilterChangeListener;
import crazypants.enderio.conduit.gui.GuiExternalConnection;
import crazypants.enderio.conduit.gui.item.IItemFilterGui;
import crazypants.enderio.conduit.item.FunctionUpgrade;
import crazypants.enderio.conduit.item.IItemConduit;
import crazypants.enderio.conduit.item.filter.IItemFilter;
import crazypants.enderio.conduit.packet.PacketExtractMode;
import crazypants.enderio.conduit.packet.PacketItemConduitFilter;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.gui.RedstoneModeButton;
import crazypants.enderio.machine.IRedstoneModeControlable;
import crazypants.enderio.machine.RedstoneControlMode;
import crazypants.enderio.network.PacketHandler;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;

public class ItemSettings
extends BaseSettingsPanel {
    private static final int NEXT_FILTER_ID = 98932;
    private static final int ID_REDSTONE_BUTTON = 12614;
    private static final int ID_COLOR_BUTTON = 179816;
    private static final int ID_LOOP = 22;
    private static final int ID_ROUND_ROBIN = 24;
    private static final int ID_PRIORITY_UP = 25;
    private static final int ID_PRIORITY_DOWN = 26;
    private static final int ID_CHANNEL = 23;
    private IItemConduit itemConduit;
    private String inputHeading;
    private String outputHeading;
    private final MultiIconButton nextFilterB;
    private final ToggleButton loopB;
    private final ToggleButton roundRobinB;
    private final MultiIconButton priUpB;
    private final MultiIconButton priDownB;
    private final RedstoneModeButton<?> rsB;
    private final ColorButton colorB;
    private ColorButton channelB;
    boolean inOutShowIn = false;
    private IItemFilter activeFilter;
    private int priLeft;
    private int priWidth = 32;
    private final GuiToolTip priorityTooltip;
    private final GuiToolTip speedUpgradeTooltip;
    private final GuiToolTip functionUpgradeTooltip;
    private final GuiToolTip filterUpgradeTooltip;
    private IItemFilterGui filterGui;

    public ItemSettings(final GuiExternalConnection gui, IConduit con) {
        super(IconEIO.WRENCH_OVERLAY_ITEM, EnderIO.lang.localize("itemItemConduit.name"), gui, con);
        this.itemConduit = (IItemConduit)con;
        this.inputHeading = EnderIO.lang.localize("gui.conduit.item.extractionFilter");
        this.outputHeading = EnderIO.lang.localize("gui.conduit.item.insertionFilter");
        int x = 52;
        int y = this.customTop;
        this.nextFilterB = MultiIconButton.createRightArrowButton((IGuiScreen)gui, (int)98932, (int)x, (int)y);
        x = 66;
        this.channelB = new ColorButton((IGuiScreen)gui, 23, x, y);
        this.channelB.setColorIndex(0);
        this.channelB.setToolTipHeading(EnderIO.lang.localize("gui.conduit.item.channel"));
        this.filterUpgradeTooltip = new GuiToolTip(new Rectangle(x - 21 - 36, this.customTop + 3 + 16, 18, 18), new String[]{EnderIO.lang.localize("gui.conduit.item.filterupgrade")}){

            public boolean shouldDraw() {
                return !gui.getContainer().hasFilterUpgrades(ItemSettings.this.isInputVisible()) && super.shouldDraw();
            }
        };
        this.speedUpgradeTooltip = new GuiToolTip(new Rectangle(x - 21 - 18, this.customTop + 3 + 16, 18, 18), new String[]{EnderIO.lang.localize("gui.conduit.item.speedupgrade"), EnderIO.lang.localize("gui.conduit.item.speedupgrade2")}){

            public boolean shouldDraw() {
                return !gui.getContainer().hasSpeedUpgrades() && super.shouldDraw();
            }
        };
        ArrayList<String> list = new ArrayList<String>();
        SpecialTooltipHandler.addTooltipFromResources(list, (String)"enderio.gui.conduit.item.functionupgrade.line");
        for (FunctionUpgrade upgrade : FunctionUpgrade.values()) {
            list.add(EnderIO.lang.localizeExact(upgrade.unlocName.concat(".name")));
        }
        this.functionUpgradeTooltip = new GuiToolTip(new Rectangle(x - 21 - 36, this.customTop + 3 + 34, 18, 18), list){

            public boolean shouldDraw() {
                return !gui.getContainer().hasFunctionUpgrades() && super.shouldDraw();
            }
        };
        this.priLeft = (x += this.channelB.getWidth() + 4) - 8;
        this.rsB = new RedstoneModeButton((IGuiScreen)gui, 12614, x, y, new IRedstoneModeControlable(){

            @Override
            public void setRedstoneControlMode(RedstoneControlMode mode) {
                RedstoneControlMode curMode = this.getRedstoneControlMode();
                ItemSettings.this.itemConduit.setExtractionRedstoneMode(mode, gui.getDir());
                if (curMode != mode) {
                    PacketHandler.INSTANCE.sendToServer((IMessage)new PacketExtractMode(ItemSettings.this.itemConduit, gui.getDir()));
                }
            }

            @Override
            public RedstoneControlMode getRedstoneControlMode() {
                return ItemSettings.this.itemConduit.getExtractionRedstoneMode(gui.getDir());
            }

            @Override
            public boolean getRedstoneControlStatus() {
                return false;
            }
        });
        this.colorB = new ColorButton((IGuiScreen)gui, 179816, x += this.rsB.getWidth() + 4, y);
        this.colorB.setColorIndex(this.itemConduit.getExtractionSignalColor(gui.getDir()).ordinal());
        this.colorB.setToolTipHeading(EnderIO.lang.localize("gui.conduit.item.sigCol"));
        this.roundRobinB = new ToggleButton((IGuiScreen)gui, 24, x += 4 + this.colorB.getWidth(), y, (IWidgetIcon)IconEIO.ROUND_ROBIN_OFF, (IWidgetIcon)IconEIO.ROUND_ROBIN);
        this.roundRobinB.setSelectedToolTip(new String[]{EnderIO.lang.localize("gui.conduit.item.roundRobinEnabled")});
        this.roundRobinB.setUnselectedToolTip(new String[]{EnderIO.lang.localize("gui.conduit.item.roundRobinDisabled")});
        this.roundRobinB.setPaintSelectedBorder(false);
        this.loopB = new ToggleButton((IGuiScreen)gui, 22, x += 4 + this.roundRobinB.getWidth(), y, (IWidgetIcon)IconEIO.LOOP_OFF, (IWidgetIcon)IconEIO.LOOP);
        this.loopB.setSelectedToolTip(new String[]{EnderIO.lang.localize("gui.conduit.item.selfFeedEnabled")});
        this.loopB.setUnselectedToolTip(new String[]{EnderIO.lang.localize("gui.conduit.item.selfFeedDisabled")});
        this.loopB.setPaintSelectedBorder(false);
        this.priorityTooltip = new GuiToolTip(new Rectangle(this.priLeft + 9, y, this.priWidth, 16), new String[]{EnderIO.lang.localize("gui.conduit.item.priority")});
        x = this.priLeft + this.priWidth + 9;
        this.priUpB = MultiIconButton.createAddButton((IGuiScreen)gui, (int)25, (int)x, (int)y);
        this.priDownB = MultiIconButton.createMinusButton((IGuiScreen)gui, (int)26, (int)x, (int)(y + 8));
        gui.getContainer().addFilterListener(new FilterChangeListener(){

            @Override
            public void onFilterChanged() {
                ItemSettings.this.filtersChanged();
            }
        });
    }

    private String getHeading() {
        ConnectionMode mode = this.con.getConnectionMode(this.gui.getDir());
        if (mode == ConnectionMode.DISABLED) {
            return "";
        }
        if (mode == ConnectionMode.OUTPUT) {
            return this.outputHeading;
        }
        if (mode == ConnectionMode.INPUT || this.inOutShowIn) {
            return this.inputHeading;
        }
        return this.outputHeading;
    }

    @Override
    protected void initCustomOptions() {
        this.updateGuiVisibility();
    }

    private void updateGuiVisibility() {
        this.deactivate();
        this.createFilterGUI();
        this.updateButtons();
    }

    private void createFilterGUI() {
        boolean showInput = false;
        boolean showOutput = false;
        ConnectionMode mode = this.con.getConnectionMode(this.gui.getDir());
        if (mode == ConnectionMode.INPUT) {
            showInput = true;
        } else if (mode == ConnectionMode.OUTPUT) {
            showOutput = true;
        } else if (mode == ConnectionMode.IN_OUT) {
            this.nextFilterB.onGuiInit();
            showInput = this.inOutShowIn;
            boolean bl = showOutput = !this.inOutShowIn;
        }
        if (!showInput && !showOutput) {
            this.filterGui = null;
            this.activeFilter = null;
        } else if (showInput) {
            this.activeFilter = this.itemConduit.getInputFilter(this.gui.getDir());
            this.gui.getContainer().setInventorySlotsVisible(true);
            this.gui.getContainer().setInoutSlotsVisible(true, false);
            if (this.activeFilter != null) {
                this.filterGui = this.activeFilter.getGui(this.gui, this.itemConduit, true);
            }
        } else if (showOutput) {
            this.activeFilter = this.itemConduit.getOutputFilter(this.gui.getDir());
            this.gui.getContainer().setInoutSlotsVisible(false, true);
            this.gui.getContainer().setInventorySlotsVisible(true);
            if (this.activeFilter != null) {
                this.filterGui = this.activeFilter.getGui(this.gui, this.itemConduit, false);
            }
        }
    }

    private void filtersChanged() {
        this.deactiveFilterGUI();
        this.createFilterGUI();
        if (this.filterGui != null) {
            this.filterGui.updateButtons();
        }
    }

    private void updateButtons() {
        boolean outputActive;
        ConnectionMode mode = this.con.getConnectionMode(this.gui.getDir());
        if (mode == ConnectionMode.DISABLED) {
            return;
        }
        boolean bl = outputActive = mode == ConnectionMode.IN_OUT && !this.inOutShowIn || mode == ConnectionMode.OUTPUT;
        if (!outputActive) {
            this.rsB.onGuiInit();
            this.rsB.setMode(RedstoneControlMode.IconHolder.getFromMode(this.itemConduit.getExtractionRedstoneMode(this.gui.getDir())));
            this.colorB.onGuiInit();
            this.colorB.setColorIndex(this.itemConduit.getExtractionSignalColor(this.gui.getDir()).ordinal());
        }
        this.gui.addToolTip(this.filterUpgradeTooltip);
        this.gui.addToolTip(this.functionUpgradeTooltip);
        if (mode == ConnectionMode.IN_OUT && !outputActive) {
            this.loopB.onGuiInit();
            this.loopB.setSelected(this.itemConduit.isSelfFeedEnabled(this.gui.getDir()));
        }
        if (mode == ConnectionMode.IN_OUT && !outputActive || mode == ConnectionMode.INPUT) {
            this.roundRobinB.onGuiInit();
            this.roundRobinB.setSelected(this.itemConduit.isRoundRobinEnabled(this.gui.getDir()));
            this.gui.addToolTip(this.speedUpgradeTooltip);
        }
        if (mode == ConnectionMode.IN_OUT && outputActive || mode == ConnectionMode.OUTPUT) {
            this.priUpB.onGuiInit();
            this.priDownB.onGuiInit();
            this.gui.addToolTip(this.priorityTooltip);
        }
        int chanCol = !outputActive ? this.itemConduit.getInputColor(this.gui.getDir()).ordinal() : this.itemConduit.getOutputColor(this.gui.getDir()).ordinal();
        this.channelB.onGuiInit();
        this.channelB.setColorIndex(chanCol);
        if (this.filterGui != null) {
            this.filterGui.updateButtons();
        }
    }

    @Override
    public void actionPerformed(GuiButton guiButton) {
        super.actionPerformed(guiButton);
        if (guiButton.field_146127_k == 98932) {
            this.inOutShowIn = !this.inOutShowIn;
            this.updateGuiVisibility();
        } else if (guiButton.field_146127_k == 179816) {
            this.itemConduit.setExtractionSignalColor(this.gui.getDir(), DyeColor.values()[this.colorB.getColorIndex()]);
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketExtractMode(this.itemConduit, this.gui.getDir()));
        } else if (guiButton.field_146127_k == 22) {
            this.itemConduit.setSelfFeedEnabled(this.gui.getDir(), !this.itemConduit.isSelfFeedEnabled(this.gui.getDir()));
            this.sendFilterChange();
        } else if (guiButton.field_146127_k == 24) {
            this.itemConduit.setRoundRobinEnabled(this.gui.getDir(), !this.itemConduit.isRoundRobinEnabled(this.gui.getDir()));
            this.sendFilterChange();
        } else if (guiButton.field_146127_k == 25) {
            this.itemConduit.setOutputPriority(this.gui.getDir(), this.itemConduit.getOutputPriority(this.gui.getDir()) + 1);
            this.sendFilterChange();
        } else if (guiButton.field_146127_k == 26) {
            this.itemConduit.setOutputPriority(this.gui.getDir(), this.itemConduit.getOutputPriority(this.gui.getDir()) - 1);
            this.sendFilterChange();
        } else if (guiButton.field_146127_k == 23) {
            DyeColor col = DyeColor.values()[this.channelB.getColorIndex()];
            if (this.isInputVisible()) {
                this.itemConduit.setInputColor(this.gui.getDir(), col);
            } else {
                this.itemConduit.setOutputColor(this.gui.getDir(), col);
            }
            this.sendFilterChange();
        }
        if (this.filterGui != null) {
            this.filterGui.actionPerformed(guiButton);
        }
    }

    private void sendFilterChange() {
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketItemConduitFilter(this.itemConduit, this.gui.getDir()));
    }

    @Override
    public void mouseClicked(int x, int y, int par3) {
        super.mouseClicked(x, y, par3);
        if (this.filterGui != null) {
            this.filterGui.mouseClicked(x, y, par3);
        }
    }

    private boolean isInputVisible() {
        ConnectionMode mode = this.con.getConnectionMode(this.gui.getDir());
        return mode == ConnectionMode.IN_OUT && this.inOutShowIn || mode == ConnectionMode.INPUT;
    }

    @Override
    protected void connectionModeChanged(ConnectionMode conectionMode) {
        super.connectionModeChanged(conectionMode);
        this.updateGuiVisibility();
    }

    @Override
    protected void renderCustomOptions(int top, float par1, int par2, int par3) {
        boolean outputActive;
        ConnectionMode mode = this.con.getConnectionMode(this.gui.getDir());
        if (mode == ConnectionMode.DISABLED) {
            return;
        }
        this.gui.bindGuiTexture(1);
        this.gui.func_73729_b(this.gui.getGuiLeft(), this.gui.getGuiTop() + 55, 0, 55, this.gui.getXSize(), 145);
        FontRenderer fr = this.gui.getFontRenderer();
        String heading = this.getHeading();
        int x = 0;
        int rgb = ColorUtil.getRGB((Color)Color.darkGray);
        fr.func_78276_b(heading, this.left + x, top, rgb);
        boolean bl = outputActive = mode == ConnectionMode.IN_OUT && !this.inOutShowIn || mode == ConnectionMode.OUTPUT;
        if (outputActive) {
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            IconEIO.map.render((IWidgetIcon)EnderWidget.BUTTON_DOWN, (double)(this.left + this.priLeft), (double)(top - 5), (double)this.priWidth, 16.0, 0.0, true);
            String str = this.itemConduit.getOutputPriority(this.gui.getDir()) + "";
            int sw = fr.func_78256_a(str);
            fr.func_78276_b(str, this.left + this.priLeft + this.priWidth - sw - this.gap, top, ColorUtil.getRGB((Color)Color.black));
        } else {
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            this.gui.bindGuiTexture(1);
            this.gui.func_73729_b(this.gui.getGuiLeft() + 9 + 18, this.gui.getGuiTop() + 46, 94, 238, 18, 18);
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.gui.bindGuiTexture(1);
        this.gui.func_73729_b(this.gui.getGuiLeft() + 9, this.gui.getGuiTop() + 46, 94, 220, 18, 18);
        this.gui.func_73729_b(this.gui.getGuiLeft() + 9, this.gui.getGuiTop() + 46 + 18, 112, 238, 18, 18);
        if (this.filterGui != null) {
            this.filterGui.renderCustomOptions(top, par1, par2, par3);
        }
    }

    @Override
    public void deactivate() {
        this.gui.getContainer().setInventorySlotsVisible(false);
        this.gui.getContainer().setInoutSlotsVisible(false, false);
        this.rsB.detach();
        this.colorB.detach();
        this.roundRobinB.detach();
        this.loopB.detach();
        this.nextFilterB.detach();
        this.priUpB.detach();
        this.priDownB.detach();
        this.gui.removeToolTip(this.priorityTooltip);
        this.gui.removeToolTip(this.speedUpgradeTooltip);
        this.gui.removeToolTip(this.functionUpgradeTooltip);
        this.gui.removeToolTip(this.filterUpgradeTooltip);
        this.channelB.detach();
        this.deactiveFilterGUI();
    }

    private void deactiveFilterGUI() {
        if (this.filterGui != null) {
            this.filterGui.deactivate();
            this.filterGui = null;
        }
        this.gui.clearGhostSlots();
    }
}

