/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.gui;

import com.enderio.core.api.client.gui.ITabPanel;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.gui.ExternalConnectionContainer;
import crazypants.enderio.gui.GuiContainerBaseEIO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;

public class GuiExternalConnection
extends GuiContainerBaseEIO {
    private static int nextButtonId = 1;
    final InventoryPlayer playerInv;
    final IConduitBundle bundle;
    private final EnumFacing dir;
    private final List<IConduit> conduits = new ArrayList<IConduit>();
    private final List<ITabPanel> tabs = new ArrayList<ITabPanel>();
    private int activeTab = 0;
    private final ExternalConnectionContainer container = (ExternalConnectionContainer)this.field_147002_h;

    public static int nextButtonId() {
        return nextButtonId++;
    }

    public GuiExternalConnection(InventoryPlayer playerInv, IConduitBundle bundle, EnumFacing dir) {
        super((Container)new ExternalConnectionContainer(playerInv, bundle, dir), "externalConduitConnection", "itemFilter");
        this.playerInv = playerInv;
        this.bundle = bundle;
        this.dir = dir;
        this.field_147000_g = 195;
        this.field_146999_f = 206;
        this.container.setInoutSlotsVisible(false, false);
        this.container.setInventorySlotsVisible(false);
        ArrayList<IConduit> cons = new ArrayList<IConduit>(bundle.getConduits());
        Collections.sort(cons, new Comparator<IConduit>(){

            @Override
            public int compare(IConduit o1, IConduit o2) {
                return Double.compare(o1.getTabOrderForConduit(o1), o2.getTabOrderForConduit(o2));
            }
        });
        for (IConduit con : cons) {
            ITabPanel tab;
            if (!con.containsExternalConnection(dir) && !con.canConnectToExternal(dir, true) || (tab = con.createPanelForConduit(this, con)) == null) continue;
            this.conduits.add(con);
            this.tabs.add(tab);
        }
        if (this.tabs.isEmpty()) {
            Minecraft.func_71410_x().field_71439_g.func_71053_j();
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        ((ExternalConnectionContainer)this.field_147002_h).createGhostSlots(this.getGhostSlots());
        for (int i = 0; i < this.tabs.size(); ++i) {
            if (i == this.activeTab) {
                this.tabs.get(i).onGuiInit(this.field_147003_i + 10, this.field_147009_r, this.field_146999_f - 20, this.field_147000_g - 20);
                continue;
            }
            this.tabs.get(i).deactivate();
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_73864_a(int x, int y, int par3) throws IOException {
        super.func_73864_a(x, y, par3);
        int tabFromCoords = this.getTabFromCoords(x, y);
        if (tabFromCoords >= 0) {
            this.activeTab = tabFromCoords;
            this.func_73866_w_();
            return;
        }
        x -= this.field_147003_i;
        y -= this.field_147009_r;
        if (this.activeTab < this.tabs.size()) {
            this.tabs.get(this.activeTab).mouseClicked(x, y, par3);
        }
    }

    public void setSize(int x, int y) {
        this.field_146999_f = x;
        this.field_147000_g = y;
    }

    protected void func_146284_a(GuiButton guiButton) throws IOException {
        super.func_146284_a(guiButton);
        if (this.activeTab < this.tabs.size()) {
            this.tabs.get(this.activeTab).actionPerformed(guiButton);
        }
    }

    protected void func_146976_a(float par1, int par2, int par3) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int sx = (this.field_146294_l - this.field_146999_f) / 2;
        int sy = (this.field_146295_m - this.field_147000_g) / 2;
        this.bindGuiTexture();
        this.func_73729_b(sx, sy, 0, 0, this.field_146999_f, this.field_147000_g);
        this.startTabs();
        for (int i = 0; i < this.tabs.size(); ++i) {
            this.renderStdTab(sx, sy, i, this.tabs.get(i).getIcon(), i == this.activeTab);
        }
        if (this.activeTab < this.tabs.size()) {
            this.tabs.get(this.activeTab).render(par1, par2, par3);
        }
        super.func_146976_a(par1, par2, par3);
    }

    public EnumFacing getDir() {
        return this.dir;
    }

    public ExternalConnectionContainer getContainer() {
        return this.container;
    }

    protected void drawFakeItemStack(int x, int y, ItemStack stack) {
        super.drawFakeItemStack(x, y, stack);
        this.field_146296_j.func_180453_a(this.field_146289_q, stack, x, y, "");
    }

    public void clearGhostSlots() {
        this.getGhostSlots().clear();
        ((ExternalConnectionContainer)this.field_147002_h).createGhostSlots(this.getGhostSlots());
    }
}

