/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.capacitor;

import crazypants.enderio.IModObject;
import crazypants.enderio.capacitor.CapacitorKeyType;
import crazypants.enderio.capacitor.ICapacitorData;
import crazypants.enderio.capacitor.ICapacitorKey;
import crazypants.enderio.capacitor.Scaler;

public class DefaultCapacitorKey
implements ICapacitorKey {
    private final IModObject owner;
    private final CapacitorKeyType valueType;
    private final Scaler scaler;
    private final int baseValue;

    public DefaultCapacitorKey(IModObject owner, CapacitorKeyType valueType, Scaler scaler, int baseValue) {
        this.owner = owner;
        this.valueType = valueType;
        this.scaler = scaler;
        this.baseValue = baseValue;
    }

    @Override
    public int get(ICapacitorData capacitor) {
        return (int)((float)this.baseValue * this.scaler.scaleValue(capacitor.getUnscaledValue(this)));
    }

    @Override
    public float getFloat(ICapacitorData capacitor) {
        return (float)this.baseValue * this.scaler.scaleValue(capacitor.getUnscaledValue(this));
    }

    @Override
    public IModObject getOwner() {
        return this.owner;
    }

    @Override
    public CapacitorKeyType getValueType() {
        return this.valueType;
    }

    @Override
    public String getName() {
        return this.owner + ":" + (Object)((Object)this.valueType);
    }
}

