/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.capability;

import crazypants.enderio.capability.InventorySlot;
import crazypants.util.Prep;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.items.IItemHandler;

public class EnderInventory
implements IItemHandler {
    private final Map<String, InventorySlot> idents = new HashMap<String, InventorySlot>();
    private final EnumMap<Type, List<InventorySlot>> slots = new EnumMap(Type.class);
    private final View allSlots = new View(Type.ALL);
    @Nullable
    private TileEntity owner = null;
    @Nonnull
    public static final IItemHandler OFF = new IItemHandler(){

        public int getSlots() {
            return 0;
        }

        public ItemStack getStackInSlot(int slot) {
            return Prep.getEmpty();
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return Prep.getEmpty();
        }
    };

    public EnderInventory() {
        for (Type type : Type.values()) {
            this.slots.put(type, new ArrayList());
        }
    }

    public void add(Type type, Enum<?> ident, InventorySlot slot) {
        this.add(type, ident.name(), slot);
    }

    public void add(Type type, String ident, InventorySlot slot) {
        if (this.idents.containsKey(ident)) {
            throw new RuntimeException("Duplicate slot '" + ident + "'");
        }
        if (type == Type.ALL) {
            throw new RuntimeException("Invalid type '" + (Object)((Object)type) + "'");
        }
        this.idents.put(ident, slot);
        this.slots.get((Object)type).add(slot);
        this.slots.get((Object)Type.ALL).add(slot);
        if (type == Type.INPUT || type == Type.OUTPUT) {
            this.slots.get((Object)Type.INOUT).add(slot);
        }
        if (type == Type.INOUT) {
            this.slots.get((Object)Type.INPUT).add(slot);
            this.slots.get((Object)Type.OUTPUT).add(slot);
        }
        slot.setOwner(this.owner);
    }

    public InventorySlot getSlot(Enum<?> ident) {
        return this.getSlot(ident.name());
    }

    public InventorySlot getSlot(String ident) {
        if (!this.idents.containsKey(ident)) {
            throw new RuntimeException("Unknown slot '" + ident + "'");
        }
        return this.idents.get(ident);
    }

    @Nonnull
    public View getView(Type type) {
        return new View(type);
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeToNBT(tag);
        return tag;
    }

    public void writeToNBT(NBTTagCompound tag) {
        for (Map.Entry<String, InventorySlot> entry : this.idents.entrySet()) {
            if (entry.getValue() == null) continue;
            NBTTagCompound subTag = new NBTTagCompound();
            entry.getValue().writeToNBT(subTag);
            tag.func_74782_a(entry.getKey(), (NBTBase)subTag);
        }
    }

    public void readFromNBT(NBTTagCompound tag, String name) {
        this.readFromNBT(tag.func_74775_l(name));
    }

    public void readFromNBT(NBTTagCompound tag) {
        for (Map.Entry<String, InventorySlot> entry : this.idents.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().readFromNBT(tag.func_74775_l(entry.getKey()));
        }
    }

    public void setOwner(TileEntity owner) {
        this.owner = owner;
        for (InventorySlot slot : this.idents.values()) {
            slot.setOwner(owner);
        }
    }

    public int getSlots() {
        return this.allSlots.getSlots();
    }

    public ItemStack getStackInSlot(int slot) {
        return this.allSlots.getStackInSlot(slot);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (Prep.isInvalid(stack)) {
            return Prep.getEmpty();
        }
        return this.allSlots.insertItem(slot, stack, simulate);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.allSlots.extractItem(slot, amount, simulate);
    }

    public class View
    implements IItemHandler,
    Iterable<InventorySlot> {
        private final Type type;

        private View(Type type) {
            this.type = type;
        }

        public InventorySlot getSlot(int slot) {
            if (slot >= 0 && slot < this.getSlots()) {
                return (InventorySlot)((List)EnderInventory.this.slots.get((Object)this.type)).get(slot);
            }
            return null;
        }

        public int getSlots() {
            return ((List)EnderInventory.this.slots.get((Object)this.type)).size();
        }

        public ItemStack getStackInSlot(int slot) {
            InventorySlot inventorySlot;
            if (slot >= 0 && slot < this.getSlots() && (inventorySlot = (InventorySlot)((List)EnderInventory.this.slots.get((Object)this.type)).get(slot)) != null) {
                return inventorySlot.getStackInSlot(0);
            }
            return Prep.getEmpty();
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            InventorySlot inventorySlot;
            if (Prep.isInvalid(stack)) {
                return Prep.getEmpty();
            }
            if (slot >= 0 && slot < this.getSlots() && (inventorySlot = (InventorySlot)((List)EnderInventory.this.slots.get((Object)this.type)).get(slot)) != null) {
                return inventorySlot.insertItem(0, stack, simulate);
            }
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            InventorySlot inventorySlot;
            if (slot >= 0 && slot < this.getSlots() && (inventorySlot = (InventorySlot)((List)EnderInventory.this.slots.get((Object)this.type)).get(slot)) != null) {
                return inventorySlot.extractItem(0, amount, simulate);
            }
            return Prep.getEmpty();
        }

        @Override
        public Iterator<InventorySlot> iterator() {
            return new Iterator<InventorySlot>(){
                int i = 0;

                @Override
                public boolean hasNext() {
                    return this.i < View.this.getSlots();
                }

                @Override
                public InventorySlot next() {
                    return View.this.getSlot(this.i++);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("remove");
                }
            };
        }
    }

    public static enum Type {
        ALL,
        INPUT,
        OUTPUT,
        INOUT,
        UPGRADE,
        INTERNAL;

    }
}

