/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.block;

import com.enderio.core.common.BlockEnder;
import crazypants.enderio.BlockEio;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.IModObject;
import crazypants.enderio.machine.painter.blocks.BlockItemPaintedBlock;
import crazypants.enderio.machine.painter.blocks.TileEntityPaintedBlock;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.paint.PainterUtil2;
import crazypants.enderio.paint.render.PaintHelper;
import crazypants.enderio.render.IHaveRenderers;
import crazypants.enderio.render.pipeline.BlockStateWrapperRelay;
import crazypants.enderio.render.registry.SmartModelAttacher;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.DefaultStateMapper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDetector
extends BlockEio<TileEntityPaintedBlock>
implements IPaintable.ISolidBlockPaintableBlock,
IHaveRenderers {
    public static final PropertyBool IS_ON = PropertyBool.func_177716_a((String)"on");
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    private final boolean silent;

    public static BlockDetector create(IModObject modobject) {
        BlockDetector result = new BlockDetector(modobject.getUnlocalisedName(), false);
        result.init();
        return result;
    }

    public static BlockDetector createSilent(IModObject modobject) {
        BlockDetector result = new BlockDetector(modobject.getUnlocalisedName(), true);
        result.init();
        return result;
    }

    protected BlockDetector(@Nonnull String name, boolean silent) {
        super(name, TileEntityPaintedBlock.class);
        this.silent = silent;
        this.func_149647_a(EnderIOTab.tabEnderIOMachines);
        this.initDefaultState();
    }

    protected void init() {
        super.init();
        SmartModelAttacher.registerNoProps((Block)this);
    }

    protected void initDefaultState() {
        this.func_180632_j(this.field_176227_L.func_177621_b());
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{IS_ON, FACING});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)IS_ON, (Comparable)Boolean.valueOf((meta & 8) != 0)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.values()[meta & 7]);
    }

    public int func_176201_c(IBlockState state) {
        return ((Boolean)state.func_177229_b((IProperty)IS_ON) != false ? 8 : 0) + ((EnumFacing)state.func_177229_b((IProperty)FACING)).ordinal();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRenderers() {
        Item item = Item.func_150898_a((Block)this);
        Map locations = new DefaultStateMapper().func_178130_a((Block)this);
        IBlockState state = this.func_176223_P().func_177226_a((IProperty)IS_ON, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP);
        ModelResourceLocation mrl = (ModelResourceLocation)locations.get(state);
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)mrl);
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state != null && world != null && pos != null) {
            BlockStateWrapperRelay blockStateWrapper = new BlockStateWrapperRelay(state, world, pos);
            blockStateWrapper.bakeModel();
            return blockStateWrapper;
        }
        return state;
    }

    protected ItemBlock createItemBlock() {
        return new BlockItemPaintedBlock((Block)this, this.getName());
    }

    public boolean doNormalDrops(IBlockAccess world, BlockPos pos) {
        return false;
    }

    protected void processDrop(IBlockAccess world, BlockPos pos, @Nullable TileEntityPaintedBlock te, ItemStack drop) {
        PainterUtil2.setSourceBlock(drop, this.getPaintSource(null, world, pos));
    }

    public int func_180656_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return side.func_176734_d() != state.func_177229_b((IProperty)FACING) && (Boolean)state.func_177229_b((IProperty)IS_ON) != false ? 15 : 0;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    protected void playClickSound(World worldIn, BlockPos pos, IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)IS_ON)).booleanValue()) {
            worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187901_ga, SoundCategory.BLOCKS, 0.3f, 0.6f);
        } else {
            worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187847_fZ, SoundCategory.BLOCKS, 0.3f, 0.5f);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn) {
        IBlockState newState = state.func_177226_a((IProperty)IS_ON, (Comparable)Boolean.valueOf(this.isTargetBlockAir(state, world, pos)));
        if (newState != state) {
            world.func_175656_a(pos, newState);
            if (!this.silent) {
                this.playClickSound(world, pos, newState);
            }
        }
    }

    protected boolean isTargetBlockAir(IBlockState state, World world, BlockPos pos) {
        return world.func_175623_d(pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState state = super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a((IProperty)FACING, (Comparable)facing);
        return state.func_177226_a((IProperty)IS_ON, (Comparable)Boolean.valueOf(this.isTargetBlockAir(state, worldIn, pos)));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack stack) {
        this.setPaintSource(state, (IBlockAccess)world, pos, PainterUtil2.getSourceBlock(stack));
        if (!world.field_72995_K) {
            world.func_184138_a(pos, state, state, 3);
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack pickBlock = super.getPickBlock(state, target, world, pos, player);
        PainterUtil2.setSourceBlock(pickBlock, this.getPaintSource(null, (IBlockAccess)world, pos));
        return pickBlock;
    }

    @Override
    public void setPaintSource(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable IBlockState paintSource) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IPaintable.IPaintableTileEntity) {
            ((IPaintable.IPaintableTileEntity)te).setPaintSource(paintSource);
        }
    }

    @Override
    public void setPaintSource(Block block, ItemStack stack, @Nullable IBlockState paintSource) {
        PainterUtil2.setSourceBlock(stack, paintSource);
    }

    @Override
    public IBlockState getPaintSource(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = BlockEnder.getAnyTileEntitySafe((IBlockAccess)world, (BlockPos)pos);
        if (te instanceof IPaintable.IPaintableTileEntity) {
            return ((IPaintable.IPaintableTileEntity)te).getPaintSource();
        }
        return null;
    }

    @Override
    public IBlockState getPaintSource(Block block, ItemStack stack) {
        return PainterUtil2.getSourceBlock(stack);
    }

    @Nonnull
    public IBlockState getFacade(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nullable EnumFacing side) {
        IBlockState paintSource = this.getPaintSource(this.func_176223_P(), world, pos);
        return paintSource != null ? paintSource : world.func_180495_p(pos);
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    public boolean canRenderInLayer(BlockRenderLayer layer) {
        return true;
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return state.func_177229_b((IProperty)FACING) == side.func_176734_d();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager effectRenderer) {
        return PaintHelper.addHitEffects(state, world, target, effectRenderer);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager effectRenderer) {
        return PaintHelper.addDestroyEffects(world, pos, effectRenderer);
    }
}

