/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio;

import com.enderio.core.client.EnderCoreModConflictException;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.CommonProxy;
import crazypants.enderio.EnderIO;
import crazypants.enderio.Log;
import crazypants.enderio.ModObject;
import crazypants.enderio.block.ColdFireStateMapper;
import crazypants.enderio.conduit.ConduitBundleStateMapper;
import crazypants.enderio.conduit.render.ConduitBundleRenderManager;
import crazypants.enderio.config.Config;
import crazypants.enderio.diagnostics.DebugCommand;
import crazypants.enderio.diagnostics.EnderIOCrashCallable;
import crazypants.enderio.fluid.Buckets;
import crazypants.enderio.gui.TooltipHandlerBurnTime;
import crazypants.enderio.gui.TooltipHandlerFluid;
import crazypants.enderio.gui.TooltipHandlerGrinding;
import crazypants.enderio.integration.jei.JeiAccessor;
import crazypants.enderio.item.ConduitProbeOverlayRenderer;
import crazypants.enderio.item.KeyTracker;
import crazypants.enderio.item.ToolTickHandler;
import crazypants.enderio.item.YetaWrenchOverlayRenderer;
import crazypants.enderio.item.darksteel.DarkSteelItems;
import crazypants.enderio.item.darksteel.SoundDetector;
import crazypants.enderio.item.darksteel.upgrade.UpgradeRenderDispatcher;
import crazypants.enderio.machine.capbank.network.ClientNetworkManager;
import crazypants.enderio.machine.obelisk.render.ObeliskRenderManager;
import crazypants.enderio.machine.ranged.MarkerParticle;
import crazypants.enderio.material.fusedQuartz.EnderIOGlassesStateMapper;
import crazypants.enderio.paint.PaintTooltipUtil;
import crazypants.enderio.paint.YetaUtil;
import crazypants.enderio.paint.render.PaintRegistry;
import crazypants.enderio.render.IHaveRenderers;
import crazypants.enderio.render.IHaveTESR;
import crazypants.enderio.render.registry.ItemModelRegistry;
import crazypants.enderio.render.registry.SmartModelAttacher;
import crazypants.enderio.teleport.TravelController;
import crazypants.enderio.teleport.telepad.TeleportEntityRenderHandler;
import crazypants.util.ClientUtil;
import crazypants.util.Prep;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    @Override
    public World getClientWorld() {
        return FMLClientHandler.instance().getClient().field_71441_e;
    }

    @Override
    public boolean isAnEiInstalled() {
        return JeiAccessor.isJeiRuntimeAvailable();
    }

    @Override
    public EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public void loadIcons() {
        SmartModelAttacher.create();
        PaintRegistry.create();
    }

    @Override
    public void init(FMLPreInitializationEvent event) {
        super.init(event);
        SpecialTooltipHandler tt = SpecialTooltipHandler.INSTANCE;
        tt.addCallback((SpecialTooltipHandler.ITooltipCallback)new TooltipHandlerGrinding());
        tt.addCallback((SpecialTooltipHandler.ITooltipCallback)new TooltipHandlerBurnTime());
        if (Config.addFuelTooltipsToAllFluidContainers) {
            tt.addCallback((SpecialTooltipHandler.ITooltipCallback)new TooltipHandlerFluid());
        }
        PaintTooltipUtil.create();
        ConduitBundleRenderManager.instance.init(event);
        EnderIO.fluids.registerRenderers();
        EnderIOGlassesStateMapper.create();
        ConduitBundleStateMapper.create();
        ColdFireStateMapper.create();
        SmartModelAttacher.registerBlockItemModels();
        for (ModObject mo : ModObject.values()) {
            Block block = mo.getBlock();
            if (block instanceof IHaveRenderers) {
                ((IHaveRenderers)block).registerRenderers();
            } else if (block == null) {
                Item item = mo.getItem();
                if (item instanceof IHaveRenderers) {
                    ((IHaveRenderers)item).registerRenderers();
                } else if (item != null) {
                    ClientUtil.registerRenderer(item, mo.getUnlocalisedName());
                }
            }
            if (!(block instanceof IHaveTESR)) continue;
            ((IHaveTESR)block).bindTileEntitySpecialRenderer();
        }
        ObeliskRenderManager.INSTANCE.registerRenderers();
        new YetaWrenchOverlayRenderer();
        new ConduitProbeOverlayRenderer();
        DarkSteelItems.onClientPreInit();
        Buckets.registerRenderers();
        ItemModelRegistry.create();
        if (Config.useSneakMouseWheelYetaWrench) {
            ToolTickHandler th = new ToolTickHandler();
            MinecraftForge.EVENT_BUS.register((Object)th);
        }
        MinecraftForge.EVENT_BUS.register((Object)TravelController.instance);
        MinecraftForge.EVENT_BUS.register((Object)KeyTracker.instance);
        MinecraftForge.EVENT_BUS.register((Object)SoundDetector.instance);
        MinecraftForge.EVENT_BUS.register((Object)UpgradeRenderDispatcher.instance);
        MinecraftForge.EVENT_BUS.register((Object)new TeleportEntityRenderHandler());
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        SmartModelAttacher.registerColoredBlocksAndItems();
        MinecraftForge.EVENT_BUS.register((Object)ClientNetworkManager.getInstance());
    }

    @Override
    public void init(FMLPostInitializationEvent event) {
        super.init(event);
        ConduitBundleRenderManager.instance.init(event);
    }

    @Override
    public double getReachDistanceForPlayer(EntityPlayer entityPlayer) {
        if (entityPlayer instanceof EntityPlayerMP) {
            return ((EntityPlayerMP)entityPlayer).field_71134_c.getBlockReachDistance();
        }
        return super.getReachDistanceForPlayer(entityPlayer);
    }

    @Override
    public void setInstantConfusionOnPlayer(EntityPlayer ent, int duration) {
        ent.func_70690_d(new PotionEffect(MobEffects.field_76431_k, duration, 1, true, true));
        Minecraft.func_71410_x().field_71439_g.field_71086_bY = 1.0f;
    }

    @Override
    public long getTickCount() {
        return this.clientTickCount;
    }

    @Override
    protected void onClientTick() {
        if (!Minecraft.func_71410_x().func_147113_T() && Minecraft.func_71410_x().field_71441_e != null) {
            ++this.clientTickCount;
            YetaUtil.onClientTick();
        }
    }

    @Override
    public void markBlock(World worldObj, BlockPos pos, Vector4f color) {
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new MarkerParticle(worldObj, pos, color));
    }

    @Override
    protected void registerCommands() {
        ClientCommandHandler.instance.func_71560_a((ICommand)DebugCommand.CLIENT);
    }

    @Override
    public boolean isDedicatedServer() {
        return false;
    }

    @Override
    public CreativeTabs getCreativeTab(ItemStack stack) {
        return Prep.isInvalid(stack) ? null : stack.func_77973_b().func_77640_w();
    }

    @Override
    public void getSubItems(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        itemIn.func_150895_a(itemIn, tab, subItems);
    }

    @Override
    public void stopWithErrorScreen(String ... message) {
        EnderIOCrashCallable.registerStopScreenMessage(message);
        ArrayList<String> lines = new ArrayList<String>();
        for (String string : message) {
            Log.error(string);
            while (string.length() > 71) {
                lines.add(string.substring(0, 70));
                string = string.substring(70, string.length());
            }
            lines.add(string);
        }
        throw new EnderCoreModConflictException(lines.toArray(new String[0]));
    }
}

