/*
 * Decompiled with CFR 0.152.
 */
package li.cil.repack.org.luaj.vm2;

import li.cil.repack.org.luaj.vm2.LuaNumber;
import li.cil.repack.org.luaj.vm2.LuaString;
import li.cil.repack.org.luaj.vm2.LuaValue;

public final class Buffer {
    private static final int DEFAULT_CAPACITY = 64;
    private static final byte[] NOBYTES = new byte[0];
    private byte[] bytes;
    private int length;
    private int offset;
    private LuaValue value;

    public Buffer() {
        this(64);
    }

    public Buffer(int initialCapacity) {
        this.bytes = new byte[initialCapacity];
        this.length = 0;
        this.offset = 0;
        this.value = null;
    }

    public Buffer(LuaValue value) {
        this.bytes = NOBYTES;
        this.offset = 0;
        this.length = 0;
        this.value = value;
    }

    public LuaValue value() {
        return this.value != null ? this.value : this.tostring();
    }

    public Buffer setvalue(LuaValue value) {
        this.bytes = NOBYTES;
        this.length = 0;
        this.offset = 0;
        this.value = value;
        return this;
    }

    public final LuaString tostring() {
        this.realloc(this.length, 0);
        return LuaString.valueOf(this.bytes, this.offset, this.length);
    }

    public String tojstring() {
        return this.value().tojstring();
    }

    public String toString() {
        return this.tojstring();
    }

    public final Buffer append(byte b) {
        this.makeroom(0, 1);
        this.bytes[this.offset + this.length++] = b;
        return this;
    }

    public final Buffer append(LuaValue val) {
        this.append(val.strvalue());
        return this;
    }

    public final Buffer append(LuaString str) {
        int n = str.m_length;
        this.makeroom(0, n);
        str.copyInto(0, this.bytes, this.offset + this.length, n);
        this.length += n;
        return this;
    }

    public final Buffer append(String str) {
        char[] c = str.toCharArray();
        int n = LuaString.lengthAsUtf8(c);
        this.makeroom(0, n);
        LuaString.encodeToUtf8(c, c.length, this.bytes, this.offset + this.length);
        this.length += n;
        return this;
    }

    public Buffer concatTo(LuaValue lhs) {
        return this.setvalue(lhs.concat(this.value()));
    }

    public Buffer concatTo(LuaString lhs) {
        return this.value != null && !this.value.isstring() ? this.setvalue(lhs.concat(this.value)) : this.prepend(lhs);
    }

    public Buffer concatTo(LuaNumber lhs) {
        return this.value != null && !this.value.isstring() ? this.setvalue(lhs.concat(this.value)) : this.prepend(lhs.strvalue());
    }

    public Buffer prepend(LuaString s) {
        int n = s.m_length;
        this.makeroom(n, 0);
        System.arraycopy(s.m_bytes, s.m_offset, this.bytes, this.offset - n, n);
        this.offset -= n;
        this.length += n;
        this.value = null;
        return this;
    }

    public final void makeroom(int nbefore, int nafter) {
        if (this.value != null) {
            LuaString s = this.value.strvalue();
            this.value = null;
            this.length = s.m_length;
            this.offset = nbefore;
            this.bytes = new byte[nbefore + this.length + nafter];
            System.arraycopy(s.m_bytes, s.m_offset, this.bytes, this.offset, this.length);
        } else if (this.offset + this.length + nafter > this.bytes.length || this.offset < nbefore) {
            int n = nbefore + this.length + nafter;
            int m = n < 32 ? 32 : (n < this.length * 2 ? this.length * 2 : n);
            this.realloc(m, nbefore == 0 ? 0 : m - this.length - nafter);
        }
    }

    private final void realloc(int newSize, int newOffset) {
        if (newSize != this.bytes.length) {
            byte[] newBytes = new byte[newSize];
            System.arraycopy(this.bytes, this.offset, newBytes, newOffset, this.length);
            this.bytes = newBytes;
            this.offset = newOffset;
        }
    }
}

