/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc.server.component;

import com.google.common.io.Files;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import li.cil.oc.OpenComputers$;
import li.cil.oc.Settings$;
import li.cil.oc.api.Network;
import li.cil.oc.api.driver.DeviceInfo;
import li.cil.oc.api.fs.Label;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ComponentConnector;
import li.cil.oc.api.network.EnvironmentHost;
import li.cil.oc.api.network.Visibility;
import li.cil.oc.api.prefab.ManagedEnvironment;
import li.cil.oc.server.PacketSender$;
import li.cil.oc.server.component.package$;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.DimensionManager;
import scala.Array$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.convert.WrapAsJava$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\t=g\u0001B\u0001\u0003\u00015\u0011Q\u0001\u0012:jm\u0016T!a\u0001\u0003\u0002\u0013\r|W\u000e]8oK:$(BA\u0003\u0007\u0003\u0019\u0019XM\u001d<fe*\u0011q\u0001C\u0001\u0003_\u000eT!!\u0003\u0006\u0002\u0007\rLGNC\u0001\f\u0003\ta\u0017n\u0001\u0001\u0014\u0007\u0001qa\u0003\u0005\u0002\u0010)5\t\u0001C\u0003\u0002\u0012%\u00051\u0001O]3gC\nT!a\u0005\u0004\u0002\u0007\u0005\u0004\u0018.\u0003\u0002\u0016!\t\u0011R*\u00198bO\u0016$WI\u001c<je>tW.\u001a8u!\t9\"$D\u0001\u0019\u0015\tI\"#\u0001\u0004ee&4XM]\u0005\u00037a\u0011!\u0002R3wS\u000e,\u0017J\u001c4p\u0011!i\u0002A!b\u0001\n\u0003q\u0012\u0001C2ba\u0006\u001c\u0017\u000e^=\u0016\u0003}\u0001\"\u0001I\u0012\u000e\u0003\u0005R\u0011AI\u0001\u0006g\u000e\fG.Y\u0005\u0003I\u0005\u00121!\u00138u\u0011!1\u0003A!A!\u0002\u0013y\u0012!C2ba\u0006\u001c\u0017\u000e^=!\u0011!A\u0003A!b\u0001\n\u0003q\u0012\u0001\u00049mCR$XM]\"pk:$\b\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011B\u0010\u0002\u001bAd\u0017\r\u001e;fe\u000e{WO\u001c;!\u0011!a\u0003A!b\u0001\n\u0003i\u0013!\u00027bE\u0016dW#\u0001\u0018\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0005E\u0012\u0012A\u00014t\u0013\t\u0019\u0004GA\u0003MC\n,G\u000e\u0003\u00056\u0001\t\u0005\t\u0015!\u0003/\u0003\u0019a\u0017MY3mA!Aq\u0007\u0001B\u0001B\u0003%\u0001(\u0001\u0003i_N$\bc\u0001\u0011:w%\u0011!(\t\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005qzT\"A\u001f\u000b\u0005y\u0012\u0012a\u00028fi^|'o[\u0005\u0003\u0001v\u0012q\"\u00128wSJ|g.\\3oi\"{7\u000f\u001e\u0005\t\u0005\u0002\u0011)\u0019!C\u0001\u0007\u0006)1o\\;oIV\tA\tE\u0002!s\u0015\u0003\"AR%\u000f\u0005\u0001:\u0015B\u0001%\"\u0003\u0019\u0001&/\u001a3fM&\u0011!j\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005!\u000b\u0003\u0002C'\u0001\u0005\u0003\u0005\u000b\u0011\u0002#\u0002\rM|WO\u001c3!\u0011!y\u0005A!b\u0001\n\u0003q\u0012!B:qK\u0016$\u0007\u0002C)\u0001\u0005\u0003\u0005\u000b\u0011B\u0010\u0002\rM\u0004X-\u001a3!\u0011!\u0019\u0006A!b\u0001\n\u0003!\u0016\u0001C5t\u0019>\u001c7.\u001a3\u0016\u0003U\u0003\"\u0001\t,\n\u0005]\u000b#a\u0002\"p_2,\u0017M\u001c\u0005\t3\u0002\u0011\t\u0011)A\u0005+\u0006I\u0011n\u001d'pG.,G\r\t\u0005\u00067\u0002!\t\u0001X\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011u{\u0006-\u00192dI\u0016\u0004\"A\u0018\u0001\u000e\u0003\tAQ!\b.A\u0002}AQ\u0001\u000b.A\u0002}AQ\u0001\f.A\u00029BQa\u000e.A\u0002aBQA\u0011.A\u0002\u0011CQa\u0014.A\u0002}AQa\u0015.A\u0002UCqa\u001a\u0001C\u0002\u0013\u0005\u0003.\u0001\u0003o_\u0012,W#A5\u0011\u0005qR\u0017BA6>\u0005I\u0019u.\u001c9p]\u0016tGoQ8o]\u0016\u001cGo\u001c:\t\r5\u0004\u0001\u0015!\u0003j\u0003\u0015qw\u000eZ3!\u0011\u0015y\u0007\u0001\"\u0003q\u0003!\u0019\u0018M^3QCRDW#A9\u0011\u0005I<X\"A:\u000b\u0005Q,\u0018AA5p\u0015\u00051\u0018\u0001\u00026bm\u0006L!\u0001_:\u0003\t\u0019KG.\u001a\u0005\bu\u0002\u0011\r\u0011\"\u0004|\u0003)\u0019Xm\u0019;peNK'0Z\u000b\u0002y>\tQ0\b\u0002\u0003\u0001!1q\u0010\u0001Q\u0001\u000eq\f1b]3di>\u00148+\u001b>fA!I\u00111\u0001\u0001C\u0002\u0013%\u0011QA\u0001\u0005I\u0006$\u0018-\u0006\u0002\u0002\bA)\u0001%!\u0003\u0002\u000e%\u0019\u00111B\u0011\u0003\u000b\u0005\u0013(/Y=\u0011\u0007\u0001\ny!C\u0002\u0002\u0012\u0005\u0012AAQ=uK\"A\u0011Q\u0003\u0001!\u0002\u0013\t9!A\u0003eCR\f\u0007\u0005\u0003\u0005\u0002\u001a\u0001\u0011\r\u0011\"\u0003\u001f\u0003-\u0019Xm\u0019;pe\u000e{WO\u001c;\t\u000f\u0005u\u0001\u0001)A\u0005?\u0005a1/Z2u_J\u001cu.\u001e8uA!A\u0011\u0011\u0005\u0001C\u0002\u0013%a$A\ttK\u000e$xN]:QKJ\u0004F.\u0019;uKJDq!!\n\u0001A\u0003%q$\u0001\ntK\u000e$xN]:QKJ\u0004F.\u0019;uKJ\u0004\u0003\u0002CA\u0015\u0001\u0001\u0007I\u0011\u0002\u0010\u0002\u000f!,\u0017\r\u001a)pg\"I\u0011Q\u0006\u0001A\u0002\u0013%\u0011qF\u0001\fQ\u0016\fG\rU8t?\u0012*\u0017\u000f\u0006\u0003\u00022\u0005]\u0002c\u0001\u0011\u00024%\u0019\u0011QG\u0011\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003s\tY#!AA\u0002}\t1\u0001\u001f\u00132\u0011\u001d\ti\u0004\u0001Q!\n}\t\u0001\u0002[3bIB{7\u000f\t\u0005\n\u0003\u0003\u0002!\u0019!C\u0003\u0003\u0007\nqB]3bIN+7\r^8s\u0007>\u001cHo]\u000b\u0003\u0003\u000b\u0002R\u0001IA\u0005\u0003\u000f\u00022\u0001IA%\u0013\r\tY%\t\u0002\u0007\t>,(\r\\3\t\u0011\u0005=\u0003\u0001)A\u0007\u0003\u000b\n\u0001C]3bIN+7\r^8s\u0007>\u001cHo\u001d\u0011\t\u0013\u0005M\u0003A1A\u0005\u0006\u0005\r\u0013\u0001E<sSR,7+Z2u_J\u001cun\u001d;t\u0011!\t9\u0006\u0001Q\u0001\u000e\u0005\u0015\u0013!E<sSR,7+Z2u_J\u001cun\u001d;tA!I\u00111\f\u0001C\u0002\u0013\u0015\u00111I\u0001\u000ee\u0016\fGMQ=uK\u000e{7\u000f^:\t\u0011\u0005}\u0003\u0001)A\u0007\u0003\u000b\naB]3bI\nKH/Z\"pgR\u001c\b\u0005C\u0005\u0002d\u0001\u0011\r\u0011\"\u0002\u0002D\u0005qqO]5uK\nKH/Z\"pgR\u001c\b\u0002CA4\u0001\u0001\u0006i!!\u0012\u0002\u001f]\u0014\u0018\u000e^3CsR,7i\\:ug\u0002B!\"a\u001b\u0001\u0011\u000b\u0007IQBA7\u0003)!WM^5dK&sgm\\\u000b\u0003\u0003_\u0002\u0002\"!\u001d\u0002|\u0005}\u0014qP\u0007\u0003\u0003gRA!!\u001e\u0002x\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u0003s\n\u0013AC2pY2,7\r^5p]&!\u0011QPA:\u0005\ri\u0015\r\u001d\t\u0005\u0003\u0003\u000b9)\u0004\u0002\u0002\u0004*\u0019\u0011QQ;\u0002\t1\fgnZ\u0005\u0004\u0015\u0006\r\u0005BCAF\u0001!\u0005\t\u0015)\u0004\u0002p\u0005YA-\u001a<jG\u0016LeNZ8!\u0011\u001d\ty\t\u0001C!\u0003#\u000bQbZ3u\t\u00164\u0018nY3J]\u001a|GCAAJ!\u0019\t)*a'F\u000b6\u0011\u0011q\u0013\u0006\u0004\u00033+\u0018\u0001B;uS2LA!! \u0002\u0018\"9\u0011q\u0014\u0001\u0005\u0002\u0005\u0005\u0016\u0001C4fi2\u000b'-\u001a7\u0015\r\u0005\r\u00161VA^!\u0015\u0001\u0013\u0011BAS!\r\u0001\u0013qU\u0005\u0004\u0003S\u000b#AB!osJ+g\r\u0003\u0005\u0002.\u0006u\u0005\u0019AAX\u0003\u001d\u0019wN\u001c;fqR\u0004B!!-\u000286\u0011\u00111\u0017\u0006\u0004\u0003k\u0013\u0012aB7bG\"Lg.Z\u0005\u0005\u0003s\u000b\u0019LA\u0004D_:$X\r\u001f;\t\u0011\u0005u\u0016Q\u0014a\u0001\u0003\u007f\u000bA!\u0019:hgB!\u0011\u0011WAa\u0013\u0011\t\u0019-a-\u0003\u0013\u0005\u0013x-^7f]R\u001c\b\u0006DAO\u0003\u000f\fi-a4\u0002R\u0006M\u0007\u0003BAY\u0003\u0013LA!a3\u00024\nA1)\u00197mE\u0006\u001c7.\u0001\u0004eSJ,7\r^\r\u0002\u0003\u0005\u0019Am\\2\"\u0005\u0005U\u0017\u0001\u000f4v]\u000e$\u0018n\u001c8)Si\u001aHO]5oO\u0002jS\u0006I$fi\u0002\"\b.\u001a\u0011dkJ\u0014XM\u001c;!Y\u0006\u0014W\r\u001c\u0011pM\u0002\"\b.\u001a\u0011ee&4XM\f\u0005\b\u00033\u0004A\u0011AAn\u0003!\u0019X\r\u001e'bE\u0016dGCBAR\u0003;\fy\u000e\u0003\u0005\u0002.\u0006]\u0007\u0019AAX\u0011!\ti,a6A\u0002\u0005}\u0006\u0006CAl\u0003\u000f\f\t.a9\"\u0005\u0005\u0015\u0018\u0001\u001c4v]\u000e$\u0018n\u001c8)m\u0006dW/\u001a\u001etiJLgnZ\u0015;gR\u0014\u0018N\\4![5\u00023+\u001a;tAQDW\r\t7bE\u0016d\u0007e\u001c4!i\",\u0007\u0005\u001a:jm\u0016t\u0003EU3ukJt7\u000f\t;iK\u0002rWm\u001e\u0011wC2,X\r\f\u0011xQ&\u001c\u0007\u000eI7bs\u0002\u0012W\r\t;sk:\u001c\u0017\r^3e]!9\u0011\u0011\u001e\u0001\u0005\u0002\u0005-\u0018aC4fi\u000e\u000b\u0007/Y2jif$b!a)\u0002n\u0006=\b\u0002CAW\u0003O\u0004\r!a,\t\u0011\u0005u\u0016q\u001da\u0001\u0003\u007fCC\"a:\u0002H\u00065\u0017qZAi\u0003g\f#!!>\u0002\u000f\u001a,hn\u0019;j_:D\u0013F\u000f8v[\n,'\u000fI\u0017.AI+G/\u001e:og\u0002\"\b.\u001a\u0011u_R\fG\u000eI2ba\u0006\u001c\u0017\u000e^=!_\u001a\u0004C\u000f[3!IJLg/\u001a\u0017!S:\u0004#-\u001f;fg:Bq!!?\u0001\t\u0003\tY0A\u0007hKR\u001cVm\u0019;peNK'0\u001a\u000b\u0007\u0003G\u000bi0a@\t\u0011\u00055\u0016q\u001fa\u0001\u0003_C\u0001\"!0\u0002x\u0002\u0007\u0011q\u0018\u0015\r\u0003o\f9-!4\u0002P\u0006E'1A\u0011\u0003\u0005\u000b\t\u0001KZ;oGRLwN\u001c\u0015*u9,XNY3sA5j\u0003EU3ukJt7\u000f\t;iK\u0002\u001a\u0018N_3!_\u001a\u0004\u0013\rI:j]\u001edW\rI:fGR|'\u000fI8oAQDW\r\t3sSZ,G\u0006I5oA\tLH/Z:/\u0011\u001d\u0011I\u0001\u0001C\u0001\u0005\u0017\tqbZ3u!2\fG\u000f^3s\u0007>,h\u000e\u001e\u000b\u0007\u0003G\u0013iAa\u0004\t\u0011\u00055&q\u0001a\u0001\u0003_C\u0001\"!0\u0003\b\u0001\u0007\u0011q\u0018\u0015\r\u0005\u000f\t9-!4\u0002P\u0006E'1C\u0011\u0003\u0005+\t\u0011IZ;oGRLwN\u001c\u0015*u9,XNY3sA5j\u0003EU3ukJt7\u000f\t;iK\u0002rW/\u001c2fe\u0002zg\r\t9mCR$XM]:!S:\u0004C\u000f[3!IJLg/\u001a\u0018\t\u000f\te\u0001\u0001\"\u0001\u0003\u001c\u0005Q!/Z1e'\u0016\u001cGo\u001c:\u0015\r\u0005\r&Q\u0004B\u0010\u0011!\tiKa\u0006A\u0002\u0005=\u0006\u0002CA_\u0005/\u0001\r!a0)\u0019\t]\u0011qYAg\u0003\u001f\f\tNa\t\"\u0005\t\u0015\u0012\u0001\u00164v]\u000e$\u0018n\u001c8)g\u0016\u001cGo\u001c:;]Vl'-\u001a:*uM$(/\u001b8hA5j\u0003EU3bI\u0002\"\b.\u001a\u0011dkJ\u0014XM\u001c;!G>tG/\u001a8ug\u0002zg\r\t;iK\u0002\u001a\b/Z2jM&,G\rI:fGR|'O\f\u0005\b\u0005S\u0001A\u0011\u0001B\u0016\u0003-9(/\u001b;f'\u0016\u001cGo\u001c:\u0015\r\u0005\r&Q\u0006B\u0018\u0011!\tiKa\nA\u0002\u0005=\u0006\u0002CA_\u0005O\u0001\r!a0)\u0019\t\u001d\u0012qYAg\u0003\u001f\f\tNa\r\"\u0005\tU\u0012A\u00184v]\u000e$\u0018n\u001c8)g\u0016\u001cGo\u001c:;]Vl'-\u001a:-AY\fG.^3;gR\u0014\u0018N\\4*A5j\u0003e\u0016:ji\u0016\u0004C\u000f[3!gB,7-\u001b4jK\u0012\u00043m\u001c8uK:$8\u000f\t;pAQDW\rI:qK\u000eLg-[3eAM,7\r^8s]!9!\u0011\b\u0001\u0005\u0002\tm\u0012\u0001\u0003:fC\u0012\u0014\u0015\u0010^3\u0015\r\u0005\r&Q\bB \u0011!\tiKa\u000eA\u0002\u0005=\u0006\u0002CA_\u0005o\u0001\r!a0)\u0019\t]\u0012qYAg\u0003\u001f\f\tNa\u0011\"\u0005\t\u0015\u0013!\u00144v]\u000e$\u0018n\u001c8)_\u001a47/\u001a;;]Vl'-\u001a:*u9,XNY3sA5j\u0003EU3bI\u0002\n\u0007e]5oO2,\u0007EY=uK\u0002\nG\u000f\t;iK\u0002\u001a\b/Z2jM&,G\rI8gMN,GO\f\u0005\b\u0005\u0013\u0002A\u0011\u0001B&\u0003%9(/\u001b;f\u0005f$X\r\u0006\u0004\u0002$\n5#q\n\u0005\t\u0003[\u00139\u00051\u0001\u00020\"A\u0011Q\u0018B$\u0001\u0004\ty\f\u000b\u0007\u0003H\u0005\u001d\u0017QZAh\u0003#\u0014\u0019&\t\u0002\u0003V\u0005)f-\u001e8di&|g\u000eK8gMN,GO\u000f8v[\n,'\u000f\f\u0011wC2,XM\u000f8v[\n,'/\u000b\u0011.[\u0001:&/\u001b;fA\u0005\u00043/\u001b8hY\u0016\u0004#-\u001f;fAQ|\u0007\u0005\u001e5fAM\u0004XmY5gS\u0016$\u0007e\u001c4gg\u0016$h\u0006C\u0005\u0003Z\u0001\u0011\r\u0011\"\u0004\u0003\\\u0005Q\u0001*Z1e!>\u001cH+Y4\u0016\u0005\tusB\u0001B0C\t\tI\u0003\u0003\u0005\u0003d\u0001\u0001\u000bQ\u0002B/\u0003-AU-\u00193Q_N$\u0016m\u001a\u0011\t\u000f\t\u001d\u0004\u0001\"\u0011\u0003j\u0005!An\\1e)\u0011\t\tDa\u001b\t\u0011\t5$Q\ra\u0001\u0005_\n1A\u001c2u!\u0011\u0011\tH! \u000e\u0005\tM$\u0002\u0002B7\u0005kRAAa\u001e\u0003z\u0005IQ.\u001b8fGJ\fg\r\u001e\u0006\u0003\u0005w\n1A\\3u\u0013\u0011\u0011yHa\u001d\u0003\u001d9\u0013E\u000bV1h\u0007>l\u0007o\\;oI\"9!1\u0011\u0001\u0005B\t\u0015\u0015\u0001B:bm\u0016$B!!\r\u0003\b\"A!Q\u000eBA\u0001\u0004\u0011y\u0007C\u0004\u0003\f\u0002!IA!$\u0002\u001dY\fG.\u001b3bi\u0016\u001cVm\u0019;peR\u0019qDa$\t\u000f\tE%\u0011\u0012a\u0001?\u000511/Z2u_JDqA!&\u0001\t\u0013\u00119*A\u0006dQ\u0016\u001c7nU3di>\u0014HcA\u0010\u0003\u001a\"9!1\u0014BJ\u0001\u0004y\u0012AB8gMN,G\u000fC\u0004\u0003\u0016\u0002!IAa(\u0015\u000b}\u0011\tKa)\t\u0011\u0005u&Q\u0014a\u0001\u0003\u007fCqA!*\u0003\u001e\u0002\u0007q$A\u0001o\u0011\u001d\u0011I\u000b\u0001C\u0005\u0005W\u000bA\"\\8wKR{7+Z2u_J$Ra\bBW\u0005_C\u0001\"!,\u0003(\u0002\u0007\u0011q\u0016\u0005\b\u0005#\u00139\u000b1\u0001 \u0011\u001d\u0011\u0019\f\u0001C\u0005\u0005k\u000bqb]3di>\u0014Hk\u001c%fC\u0012\u0004vn\u001d\u000b\u0004?\t]\u0006b\u0002BI\u0005c\u0003\ra\b\u0005\b\u0005w\u0003A\u0011\u0002B_\u00031\u0019Xm\u0019;pe>3gm]3u)\ry\"q\u0018\u0005\b\u0005#\u0013I\f1\u0001 \u0011\u001d\u0011\u0019\r\u0001C\u0005\u0005\u000b\fAb\u001c4gg\u0016$8+Z2u_J$2a\bBd\u0011\u001d\u0011YJ!1A\u0002}AqAa3\u0001\t\u0013\u0011i-\u0001\u0007eSN\\\u0017i\u0019;jm&$\u0018\u0010\u0006\u0002\u00022\u0001")
public class Drive
extends ManagedEnvironment
implements DeviceInfo {
    private final int capacity;
    private final int platterCount;
    private final Label label;
    private final Option<EnvironmentHost> host;
    private final Option<String> sound;
    private final int speed;
    private final boolean isLocked;
    private final ComponentConnector node;
    private final int sectorSize;
    private final byte[] data;
    private final int sectorCount;
    private final int sectorsPerPlatter;
    private int headPos;
    private final double[] readSectorCosts;
    private final double[] writeSectorCosts;
    private final double[] readByteCosts;
    private final double[] writeByteCosts;
    private Map<String, String> deviceInfo;
    private final String HeadPosTag;
    private volatile boolean bitmap$0;

    private Map deviceInfo$lzycompute() {
        Drive drive = this;
        synchronized (drive) {
            if (!this.bitmap$0) {
                this.deviceInfo = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"class"), (Object)"disk"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"description"), (Object)"Hard disk drive"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"vendor"), (Object)"MightyPirates GmbH & Co. KG"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"product"), (Object)new StringBuilder().append((Object)"MPD").append((Object)((Object)BoxesRunTime.boxToInteger((int)(this.capacity() / 1024))).toString()).append((Object)"L").append((Object)((Object)BoxesRunTime.boxToInteger((int)this.platterCount())).toString()).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"capacity"), (Object)((Object)BoxesRunTime.boxToInteger((int)((int)((double)this.capacity() * 1.024)))).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"size"), (Object)((Object)BoxesRunTime.boxToInteger((int)this.capacity())).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clock"), (Object)new StringBuilder().append((Object)((Object)BoxesRunTime.boxToInteger((int)((int)((double)2000 / this.readSectorCosts()[this.speed()]) / 100))).toString()).append((Object)"/").append((Object)((Object)BoxesRunTime.boxToInteger((int)((int)((double)2000 / this.writeSectorCosts()[this.speed()]) / 100))).toString()).append((Object)"/").append((Object)((Object)BoxesRunTime.boxToInteger((int)((int)((double)2000 / this.readByteCosts()[this.speed()]) / 100))).toString()).append((Object)"/").append((Object)((Object)BoxesRunTime.boxToInteger((int)((int)((double)2000 / this.writeByteCosts()[this.speed()]) / 100))).toString()).toString())}));
                this.bitmap$0 = true;
            }
            return this.deviceInfo;
        }
    }

    public int capacity() {
        return this.capacity;
    }

    public int platterCount() {
        return this.platterCount;
    }

    public Label label() {
        return this.label;
    }

    public Option<String> sound() {
        return this.sound;
    }

    public int speed() {
        return this.speed;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    @Override
    public ComponentConnector node() {
        return this.node;
    }

    private File savePath() {
        return new File(DimensionManager.getCurrentSaveRootDirectory(), new StringBuilder().append((Object)Settings$.MODULE$.savePath()).append((Object)this.node().address()).append((Object)".bin").toString());
    }

    private final int sectorSize() {
        return 512;
    }

    private byte[] data() {
        return this.data;
    }

    private int sectorCount() {
        return this.sectorCount;
    }

    private int sectorsPerPlatter() {
        return this.sectorsPerPlatter;
    }

    private int headPos() {
        return this.headPos;
    }

    private void headPos_$eq(int x$1) {
        this.headPos = x$1;
    }

    public final double[] readSectorCosts() {
        return this.readSectorCosts;
    }

    public final double[] writeSectorCosts() {
        return this.writeSectorCosts;
    }

    public final double[] readByteCosts() {
        return this.readByteCosts;
    }

    public final double[] writeByteCosts() {
        return this.writeByteCosts;
    }

    private final Map<String, String> deviceInfo() {
        return this.bitmap$0 ? this.deviceInfo : this.deviceInfo$lzycompute();
    }

    @Override
    public java.util.Map<String, String> getDeviceInfo() {
        return WrapAsJava$.MODULE$.mapAsJavaMap(this.deviceInfo());
    }

    @Callback(direct=true, doc="function():string -- Get the current label of the drive.")
    public synchronized Object[] getLabel(Context context, Arguments args) {
        return this.label() == null ? null : package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.label().getLabel()}));
    }

    @Callback(doc="function(value:string):string -- Sets the label of the drive. Returns the new value, which may be truncated.")
    public synchronized Object[] setLabel(Context context, Arguments args) {
        if (this.isLocked()) {
            throw new Exception("drive is read only");
        }
        if (this.label() == null) {
            throw new Exception("drive does not support labeling");
        }
        if (args.checkAny(0) == null) {
            this.label().setLabel(null);
        } else {
            this.label().setLabel(args.checkString(0));
        }
        return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.label().getLabel()}));
    }

    @Callback(direct=true, doc="function():number -- Returns the total capacity of the drive, in bytes.")
    public Object[] getCapacity(Context context, Arguments args) {
        return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.capacity())}));
    }

    @Callback(direct=true, doc="function():number -- Returns the size of a single sector on the drive, in bytes.")
    public Object[] getSectorSize(Context context, Arguments args) {
        return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)512)}));
    }

    @Callback(direct=true, doc="function():number -- Returns the number of platters in the drive.")
    public Object[] getPlatterCount(Context context, Arguments args) {
        return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.platterCount())}));
    }

    @Callback(direct=true, doc="function(sector:number):string -- Read the current contents of the specified sector.")
    public synchronized Object[] readSector(Context context, Arguments args) {
        context.consumeCallBudget(this.readSectorCosts()[this.speed()]);
        int sector = this.moveToSector(context, this.checkSector(args, 0));
        this.diskActivity();
        byte[] sectorData = new byte[512];
        Array$.MODULE$.copy((Object)this.data(), this.sectorOffset(sector), (Object)sectorData, 0, 512);
        return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sectorData}));
    }

    @Callback(direct=true, doc="function(sector:number, value:string) -- Write the specified contents to the specified sector.")
    public synchronized Object[] writeSector(Context context, Arguments args) {
        if (this.isLocked()) {
            throw new Exception("drive is read only");
        }
        context.consumeCallBudget(this.writeSectorCosts()[this.speed()]);
        byte[] sectorData = args.checkByteArray(1);
        int sector = this.moveToSector(context, this.checkSector(args, 0));
        this.diskActivity();
        Array$.MODULE$.copy((Object)sectorData, 0, (Object)this.data(), this.sectorOffset(sector), scala.math.package$.MODULE$.min(512, sectorData.length));
        return null;
    }

    @Callback(direct=true, doc="function(offset:number):number -- Read a single byte at the specified offset.")
    public synchronized Object[] readByte(Context context, Arguments args) {
        context.consumeCallBudget(this.readByteCosts()[this.speed()]);
        int offset = args.checkInteger(0) - 1;
        this.moveToSector(context, this.checkSector(offset));
        this.diskActivity();
        return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)this.data()[offset])}));
    }

    @Callback(direct=true, doc="function(offset:number, value:number) -- Write a single byte to the specified offset.")
    public synchronized Object[] writeByte(Context context, Arguments args) {
        if (this.isLocked()) {
            throw new Exception("drive is read only");
        }
        context.consumeCallBudget(this.writeByteCosts()[this.speed()]);
        int offset = args.checkInteger(0) - 1;
        byte value = (byte)args.checkInteger(1);
        this.moveToSector(context, this.checkSector(offset));
        this.diskActivity();
        this.data()[offset] = value;
        return null;
    }

    private final String HeadPosTag() {
        return "headPos";
    }

    @Override
    public synchronized void load(NBTTagCompound nbt) {
        super.load(nbt);
        if (this.node().address() != null) {
            try {
                File path = this.savePath();
                if (path.exists()) {
                    ByteArrayInputStream bin = new ByteArrayInputStream(Files.toByteArray((File)path));
                    GZIPInputStream zin = new GZIPInputStream(bin);
                    int read = 0;
                    for (int offset = 0; read >= 0 && offset < this.data().length; offset += read) {
                        read = zin.read(this.data(), offset, this.data().length - offset);
                    }
                }
            }
            catch (Throwable throwable) {
                OpenComputers$.MODULE$.log().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed loading drive contents for '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.node().address()})), throwable);
            }
        }
        this.headPos_$eq(RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(nbt.func_74762_e("headPos")), 0)), this.sectorToHeadPos(this.sectorCount())));
        if (this.label() != null) {
            this.label().load(nbt);
        }
    }

    @Override
    public synchronized void save(NBTTagCompound nbt) {
        super.save(nbt);
        if (this.node().address() != null) {
            try {
                File path = this.savePath();
                path.getParentFile().mkdirs();
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                GZIPOutputStream zos = new GZIPOutputStream(bos);
                zos.write(this.data());
                zos.close();
                Files.write((byte[])bos.toByteArray(), (File)path);
            }
            catch (Throwable throwable) {
                OpenComputers$.MODULE$.log().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed saving drive contents for '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.node().address()})), throwable);
            }
        }
        nbt.func_74768_a("headPos", this.headPos());
        if (this.label() != null) {
            this.label().save(nbt);
        }
    }

    private int validateSector(int sector) {
        if (sector < 0 || sector >= this.sectorCount()) {
            throw new IllegalArgumentException("invalid offset, not in a usable sector");
        }
        return sector;
    }

    private int checkSector(int offset) {
        return this.validateSector(this.offsetSector(offset));
    }

    private int checkSector(Arguments args, int n) {
        return this.validateSector(args.checkInteger(n) - 1);
    }

    private int moveToSector(Context context, int sector) {
        int newHeadPos = this.sectorToHeadPos(sector);
        if (this.headPos() != newHeadPos) {
            int delta = scala.math.package$.MODULE$.abs(this.headPos() - newHeadPos);
            Object object = delta > Settings$.MODULE$.get().sectorSeekThreshold() ? BoxesRunTime.boxToBoolean((boolean)context.pause(Settings$.MODULE$.get().sectorSeekTime())) : BoxedUnit.UNIT;
            this.headPos_$eq(newHeadPos);
        }
        return sector;
    }

    private int sectorToHeadPos(int sector) {
        return sector % this.sectorsPerPlatter();
    }

    private int sectorOffset(int sector) {
        return sector * 512;
    }

    private int offsetSector(int offset) {
        return offset / 512;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void diskActivity() {
        Tuple2 tuple2 = new Tuple2(this.sound(), this.host);
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                String s = (String)some.x();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    EnvironmentHost h = (EnvironmentHost)some2.x();
                    PacketSender$.MODULE$.sendFileSystemActivity(this.node(), h, s);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public Drive(int capacity, int platterCount, Label label, Option<EnvironmentHost> host, Option<String> sound, int speed, boolean isLocked) {
        this.capacity = capacity;
        this.platterCount = platterCount;
        this.label = label;
        this.host = host;
        this.sound = sound;
        this.speed = speed;
        this.isLocked = isLocked;
        this.node = (ComponentConnector)Network.newNode(this, Visibility.Network).withComponent("drive", Visibility.Neighbors).withConnector().create();
        this.data = new byte[capacity];
        this.sectorCount = capacity / 512;
        this.sectorsPerPlatter = this.sectorCount() / platterCount;
        this.headPos = 0;
        this.readSectorCosts = new double[]{0.1, 0.05, 0.03333333333333333, 0.025, 0.02, 0.016666666666666666};
        this.writeSectorCosts = new double[]{0.2, 0.1, 0.06666666666666667, 0.05, 0.04, 0.03333333333333333};
        this.readByteCosts = new double[]{0.020833333333333332, 0.015625, 0.0125, 0.010416666666666666, 0.008928571428571428, 0.0078125};
        this.writeByteCosts = new double[]{0.041666666666666664, 0.03125, 0.025, 0.020833333333333332, 0.017857142857142856, 0.015625};
    }
}

