/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.world;

import java.util.ArrayList;
import java.util.Random;
import mod.lucky.block.BlockLuckyBlock;
import mod.lucky.drop.DropContainer;
import mod.lucky.drop.func.DropProcessData;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.fml.common.IWorldGenerator;

public class LuckyGenerator
implements IWorldGenerator {
    private BlockLuckyBlock block;
    private ArrayList<DropContainer> surfaceDrops;
    private ArrayList<DropContainer> netherDrops;
    private ArrayList<DropContainer> endDrops;

    public LuckyGenerator(BlockLuckyBlock block) {
        this.block = block;
        this.surfaceDrops = new ArrayList();
        this.netherDrops = new ArrayList();
        this.endDrops = new ArrayList();
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        try {
            switch (world.field_73011_w.getDimension()) {
                case -1: {
                    for (DropContainer drop : this.netherDrops) {
                        if (random.nextInt((int)drop.getChance()) != 0) continue;
                        this.generateNether(world, random, chunkX * 16, chunkZ * 16, drop);
                    }
                    break;
                }
                case 0: {
                    for (DropContainer drop : this.surfaceDrops) {
                        if (random.nextInt((int)drop.getChance()) != 0) continue;
                        this.generateSurface(world, random, chunkX * 16, chunkZ * 16, drop);
                    }
                    break;
                }
                case 1: {
                    for (DropContainer drop : this.endDrops) {
                        if (random.nextInt((int)drop.getChance()) != 0) continue;
                        this.generateEnd(world, random, chunkX * 16, chunkZ * 16, drop);
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            System.err.println("Lucky Block: Error during natural generation");
            e.printStackTrace();
        }
    }

    private void generateNether(World world, Random random, int x, int z, DropContainer drop) {
        this.generate(world, new BlockPos(x += random.nextInt(16) + 8, 64, z += random.nextInt(16) + 8), drop);
    }

    private void generateSurface(World world, Random random, int x, int z, DropContainer drop) {
        this.generate(world, new BlockPos(x += random.nextInt(16) + 8, 128, z += random.nextInt(16) + 8), drop);
    }

    private void generateEnd(World world, Random random, int x, int z, DropContainer drop) {
        this.generate(world, new BlockPos(x += random.nextInt(16) + 8, 100, z += random.nextInt(16) + 8), drop);
    }

    private void generate(World world, BlockPos pos, DropContainer drop) {
        if ((pos = this.getSurfacePos(world, pos)) != null) {
            this.block.getDropProcessor().processDrop(drop, new DropProcessData(world, null, pos));
        }
    }

    public void addSurfacedDrop(DropContainer drop) {
        this.addDrop(this.surfaceDrops, drop);
    }

    public void addNetherDrop(DropContainer drop) {
        this.addDrop(this.netherDrops, drop);
    }

    public void addEndDrop(DropContainer drop) {
        this.addDrop(this.endDrops, drop);
    }

    private void addDrop(ArrayList<DropContainer> list, DropContainer drop) {
        if (!drop.wasChanceSet()) {
            drop.setChance(300.0f);
        }
        list.add(drop);
    }

    private BlockPos getSurfacePos(World world, BlockPos pos) {
        int newPosY = pos.func_177956_o();
        boolean canAdjust = false;
        do {
            BlockPos newPos;
            if (!this.block.canBlockStay(world, newPos = new BlockPos(pos.func_177958_n(), newPosY, pos.func_177952_p()))) continue;
            canAdjust = true;
            break;
        } while (--newPosY > 0);
        return !canAdjust ? null : new BlockPos(pos.func_177958_n(), newPosY, pos.func_177952_p());
    }
}

