/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.util;

import java.util.ArrayList;
import java.util.Random;
import mod.lucky.drop.DropContainer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityGiantZombie;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemDye;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class LuckyFunction {
    public static int[] potionEffectList = new int[]{1, 2, 3, 4, 5, 6, 8, 9, 10, 12, 14};
    public static int[] potionEffectListGood = new int[]{1, 5, 6, 8, 10, 12, 13, 14, 16, 14};
    public static int[] potionEffectListBad = new int[]{2, 7, 18, 19};
    public static int[] mobEggList = new int[]{50, 51, 52, 54, 55, 56, 57, 58, 59, 60, 61, 62, 65, 66, 90, 91, 92, 93, 94, 95, 96, 98, 100, 120};
    public static int[] mobIDList = new int[]{50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 120};
    public static String[] mobNameList = new String[]{"creeper", "skeleton", "spider", "giant zombie", "zombie", "slime", "ghast", "zombie pigman", "enderman", "cave spider", "silverfish", "blaze", "magma cube", "ender dragon", "wither", "witch", "bat", "pig", "sheep", "cow", "chicken", "squid", "wolf", "mooshroom", "snow golem", "ocelot", "iron golem", "horse", "villager"};
    private static Random random = new Random();
    private static ArrayList<String> potionNames = new ArrayList();

    public static NBTTagCompound getRandomFireworksRocket() {
        Random random = new Random();
        NBTTagCompound mainTag = new NBTTagCompound();
        NBTTagCompound fireworksTag = new NBTTagCompound();
        NBTTagCompound explosionTag = new NBTTagCompound();
        NBTTagList explosionList = new NBTTagList();
        explosionTag.func_74774_a("Type", (byte)random.nextInt(5));
        explosionTag.func_74757_a("Flicker", random.nextBoolean());
        explosionTag.func_74757_a("Trail", random.nextBoolean());
        int colorAmount = random.nextInt(4) + 1;
        int[] colors = new int[colorAmount];
        for (int a = 0; a < colorAmount; ++a) {
            colors[a] = ItemDye.field_150922_c[random.nextInt(14)];
        }
        explosionTag.func_74783_a("Colors", colors);
        explosionList.func_74742_a((NBTBase)explosionTag);
        fireworksTag.func_74782_a("Explosions", (NBTBase)explosionList);
        fireworksTag.func_74774_a("Flight", (byte)(random.nextInt(2) + 1));
        mainTag.func_74782_a("Fireworks", (NBTBase)fireworksTag);
        return mainTag;
    }

    public static int getRandomPotionDamage() {
        return LuckyFunction.calculatePotionDamage(LuckyFunction.getRandomPotionEffect(), 0);
    }

    public static int calculatePotionDamage(int effect, int isSplash) {
        int tier = 0;
        int extended = 0;
        int i = random.nextInt(3);
        if (i == 1) {
            tier = 32;
        }
        if (i == 2) {
            extended = 64;
        }
        int splash = 0;
        if (isSplash == 0) {
            if (random.nextInt(2) == 0) {
                splash = 16384;
            }
        } else if (isSplash == 1) {
            splash = 0;
        } else if (isSplash == 2) {
            splash = 16384;
        }
        return effect + tier + extended + splash;
    }

    public static String getRandomPotionName() {
        return potionNames.get(random.nextInt(potionNames.size()));
    }

    @Deprecated
    public static EntityLiving getMobByNameOrId(World world, String name, int id) {
        if (name.equals(mobNameList[0]) || id == mobIDList[0]) {
            return new EntityCreeper(world);
        }
        if (name.equals(mobNameList[1]) || id == mobIDList[1]) {
            return new EntitySkeleton(world);
        }
        if (name.equals(mobNameList[2]) || id == mobIDList[2]) {
            return new EntitySpider(world);
        }
        if (name.equals(mobNameList[3]) || id == mobIDList[3]) {
            return new EntityGiantZombie(world);
        }
        if (name.equals(mobNameList[4]) || id == mobIDList[4]) {
            return new EntityZombie(world);
        }
        if (name.equals(mobNameList[5]) || id == mobIDList[5]) {
            return new EntitySlime(world);
        }
        if (name.equals(mobNameList[6]) || id == mobIDList[6]) {
            return new EntityGhast(world);
        }
        if (name.equals(mobNameList[7]) || id == mobIDList[7]) {
            return new EntityPigZombie(world);
        }
        if (name.equals(mobNameList[8]) || id == mobIDList[8]) {
            return new EntityEnderman(world);
        }
        if (name.equals(mobNameList[9]) || id == mobIDList[9]) {
            return new EntityCaveSpider(world);
        }
        if (name.equals(mobNameList[10]) || id == mobIDList[10]) {
            return new EntitySilverfish(world);
        }
        if (name.equals(mobNameList[11]) || id == mobIDList[11]) {
            return new EntityBlaze(world);
        }
        if (name.equals(mobNameList[12]) || id == mobIDList[12]) {
            return new EntityMagmaCube(world);
        }
        if (name.equals(mobNameList[13]) || id == mobIDList[13]) {
            return new EntityDragon(world);
        }
        if (name.equals(mobNameList[14]) || id == mobIDList[14]) {
            return new EntityWither(world);
        }
        if (name.equals(mobNameList[15]) || id == mobIDList[15]) {
            return new EntityWitch(world);
        }
        if (name.equals(mobNameList[16]) || id == mobIDList[16]) {
            return new EntityBat(world);
        }
        if (name.equals(mobNameList[17]) || id == mobIDList[17]) {
            return new EntityPig(world);
        }
        if (name.equals(mobNameList[18]) || id == mobIDList[18]) {
            return new EntitySheep(world);
        }
        if (name.equals(mobNameList[19]) || id == mobIDList[19]) {
            return new EntityCow(world);
        }
        if (name.equals(mobNameList[20]) || id == mobIDList[20]) {
            return new EntityChicken(world);
        }
        if (name.equals(mobNameList[21]) || id == mobIDList[21]) {
            return new EntitySquid(world);
        }
        if (name.equals(mobNameList[22]) || id == mobIDList[22]) {
            return new EntityWolf(world);
        }
        if (name.equals(mobNameList[23]) || id == mobIDList[23]) {
            return new EntityMooshroom(world);
        }
        if (name.equals(mobNameList[24]) || id == mobIDList[24]) {
            return new EntitySnowman(world);
        }
        if (name.equals(mobNameList[25]) || id == mobIDList[25]) {
            return new EntityOcelot(world);
        }
        if (name.equals(mobNameList[26]) || id == mobIDList[26]) {
            return new EntityIronGolem(world);
        }
        if (name.equals(mobNameList[27]) || id == mobIDList[27]) {
            return new EntityHorse(world);
        }
        if (name.equals(mobNameList[28]) || id == mobIDList[28]) {
            return new EntityVillager(world);
        }
        return null;
    }

    public static Entity getEntity(World world, int id, String name) {
        if (!EntityList.field_75627_a.containsKey(id)) {
            return EntityList.func_75620_a((String)name, (World)world);
        }
        return EntityList.func_75616_a((int)id, (World)world);
    }

    public static int getRandomStatusEffect() {
        return Potion.field_188414_b.func_148757_b(Potion.field_188414_b.func_186801_a(random));
    }

    public static int getRandomPotionEffect() {
        return random.nextInt(14) + 1;
    }

    public static int getRandomPotionEffectGood() {
        return potionEffectListGood[random.nextInt(potionEffectListGood.length)];
    }

    public static int getRandomPotionEffectBad() {
        return potionEffectListBad[random.nextInt(potionEffectListBad.length)];
    }

    public static int getRandomMobEggID() {
        Object[] values = EntityList.field_75627_a.values().toArray();
        EntityList.EntityEggInfo egg = (EntityList.EntityEggInfo)values[random.nextInt(values.length)];
        return EntityList.func_180122_a((String)egg.field_75613_a);
    }

    public static String getRandomMobEggName() {
        Object[] values = EntityList.field_75627_a.values().toArray();
        EntityList.EntityEggInfo egg = (EntityList.EntityEggInfo)values[random.nextInt(values.length)];
        return egg.field_75613_a;
    }

    public static int getPlayerDirection(EntityPlayer player, int accuracy) {
        int yaw = (int)player.field_70177_z;
        int angle = 360 / accuracy;
        if (yaw < 0) {
            yaw += 360;
        }
        yaw += angle / 2;
        return (yaw %= 360) / angle;
    }

    public static int adjustHeight(World world, int height, int posX, int posY, int posZ) {
        boolean wasHeightAdjusted = false;
        int newPosY = posY;
        int airCount = 0;
        for (int a = posY; a < posY + 16; ++a) {
            if (world.func_180495_p(new BlockPos(posX, a, posZ)).func_185914_p()) {
                airCount = 0;
                newPosY = a + 1;
            } else {
                ++airCount;
            }
            if (airCount != height) continue;
            wasHeightAdjusted = true;
            break;
        }
        if (wasHeightAdjusted) {
            return newPosY;
        }
        return -1;
    }

    public static NBTTagList getNBTTagListFromStringArray(String[] array) {
        NBTTagList nbttagList = new NBTTagList();
        for (String element : array) {
            nbttagList.func_74742_a((NBTBase)new NBTTagString(element));
        }
        return nbttagList;
    }

    public static String[] getStringArrayFromNBTTagList(NBTTagList nbttagList) {
        String[] array = new String[nbttagList == null ? 0 : nbttagList.func_74745_c()];
        for (int a = 0; a < array.length; ++a) {
            array[a] = nbttagList.func_150307_f(a);
        }
        return array;
    }

    public static ArrayList<DropContainer> getDropsFromStringArray(String[] array) {
        ArrayList<DropContainer> drops = new ArrayList<DropContainer>();
        for (String element : array) {
            DropContainer dropContainer = new DropContainer();
            dropContainer.readFromString(element);
            drops.add(dropContainer);
        }
        return drops;
    }

    static {
        for (ResourceLocation resource : PotionType.field_185176_a.func_148742_b()) {
            String potion = resource.func_110623_a();
            if (potion.equals("empty") || potion.equals("water") || potion.equals("mundane") || potion.equals("thick") || potion.equals("awkward")) continue;
            potionNames.add(potion);
        }
    }
}

