/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.item;

import java.util.List;
import mod.lucky.crafting.LuckyCrafting;
import mod.lucky.drop.func.DropProcessData;
import mod.lucky.drop.func.DropProcessor;
import mod.lucky.item.ItemLuckyBlock;
import mod.lucky.util.LuckyFunction;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemLuckyBow
extends ItemBow {
    private DropProcessor dropProcessor;
    private LuckyCrafting crafting;
    private String bowTextureName = "lucky:lucky_bow";

    public ItemLuckyBow() {
        this.func_77656_e(1000);
        this.dropProcessor = new DropProcessor();
        this.crafting = new LuckyCrafting((Item)this);
        this.func_185043_a(new ResourceLocation("pull"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                if (entityIn == null) {
                    return 0.0f;
                }
                ItemStack itemstack = entityIn.func_184607_cu();
                return itemstack != null && itemstack.func_77973_b() instanceof ItemLuckyBow ? (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / 20.0f : 0.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("pulling"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }

    public void func_77615_a(ItemStack itemStack, World world, EntityLivingBase entity, int timeLeft) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            boolean unlimitedArrows = player.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)itemStack) > 0;
            ItemStack arrowStack = this.getInventoryArrows(player);
            int initPower = this.func_77626_a(itemStack) - timeLeft;
            if ((initPower = ForgeEventFactory.onArrowLoose((ItemStack)itemStack, (World)world, (EntityPlayer)player, (int)initPower, (arrowStack != null || unlimitedArrows ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (unlimitedArrows || arrowStack != null) {
                float power = ItemLuckyBow.func_185059_b((int)initPower);
                if (!((double)power >= 0.1)) {
                    return;
                }
                if (!world.field_72995_K) {
                    try {
                        int luck = ItemLuckyBlock.getLuck(itemStack);
                        String[] drops = ItemLuckyBlock.getDrops(itemStack);
                        EntityTippedArrow entityArrow = new EntityTippedArrow(world, (EntityLivingBase)player);
                        if (drops != null && drops.length != 0) {
                            this.getDropProcessor().processRandomDrop(LuckyFunction.getDropsFromStringArray(drops), new DropProcessData(world, (Entity)player, entityArrow.func_174791_d()).setBowPower(power * 3.0f), luck);
                        } else {
                            this.getDropProcessor().processRandomDrop(new DropProcessData(world, (Entity)player, entityArrow.func_174791_d()).setBowPower(power * 3.0f), luck);
                        }
                    }
                    catch (Exception e) {
                        System.err.println("The Lucky Bow encountered and error while trying to perform a function. Error report below:");
                        e.printStackTrace();
                    }
                }
                world.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + power * 0.5f);
                if (!unlimitedArrows) {
                    --arrowStack.field_77994_a;
                    if (arrowStack.field_77994_a == 0) {
                        player.field_71071_by.func_184437_d(arrowStack);
                    }
                }
            }
        }
    }

    private ItemStack getInventoryArrows(EntityPlayer player) {
        if (this.func_185058_h_(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.func_185058_h_(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.func_185058_h_(itemstack)) continue;
            return itemstack;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getModel(ItemStack stack, EntityPlayer player, int useRemaining) {
        ModelResourceLocation modelResourceLocation = new ModelResourceLocation(this.bowTextureName, "inventory");
        int useTicks = stack.func_77988_m() - useRemaining;
        if (stack.func_77973_b() == this && player.func_184607_cu() != null) {
            if (useTicks >= 18) {
                modelResourceLocation = new ModelResourceLocation(this.bowTextureName + "_pulling_2", "inventory");
            } else if (useTicks > 13) {
                modelResourceLocation = new ModelResourceLocation(this.bowTextureName + "_pulling_1", "inventory");
            } else if (useTicks > 0) {
                modelResourceLocation = new ModelResourceLocation(this.bowTextureName + "_pulling_0", "inventory");
            }
        }
        return modelResourceLocation;
    }

    public void setBowTextureName(String bowTextureName) {
        this.bowTextureName = bowTextureName;
    }

    public int func_77619_b() {
        return 0;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public DropProcessor getDropProcessor() {
        return this.dropProcessor;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean flag) {
        int luck = ItemLuckyBlock.getLuck(itemStack);
        String[] drops = ItemLuckyBlock.getDrops(itemStack);
        list.add(I18n.func_74838_a((String)"item.luckyBlock.luck") + ": " + (luck == 0 ? TextFormatting.GOLD : (luck < 0 ? TextFormatting.RED : TextFormatting.GREEN + "+")) + String.valueOf(luck));
        if (drops != null && drops.length != 0) {
            list.add(TextFormatting.GRAY + "" + TextFormatting.ITALIC + I18n.func_74838_a((String)"item.luckyBlock.customDrop"));
        }
    }

    public LuckyCrafting getCrafting() {
        return this.crafting;
    }
}

