/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.drop.value;

import java.util.ArrayList;
import java.util.Random;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import mod.lucky.Lucky;
import mod.lucky.drop.DropProperties;
import mod.lucky.drop.func.DropProcessData;
import mod.lucky.drop.value.CustomNBTTags;
import mod.lucky.drop.value.DropStringUtils;
import mod.lucky.drop.value.ValueParser;
import mod.lucky.structure.Structure;
import mod.lucky.structure.StructureUtils;
import mod.lucky.util.LuckyFunction;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class HashVariables {
    private static String[] hashVariables = new String[]{"#randPotionDamage", "#randPotion", "#randPotionParticle", "#randSpawnEggDamage", "#randSpawnEgg", "#bPosX", "#bPosY", "#bPosZ", "#bPos", "#bExactPosX", "#bExactPosY", "#bExactPosZ", "#bExactPos", "#ePosX", "#ePosY", "#ePosZ", "#ePos", "#eExactPosX", "#eExactPosY", "#eExactPosZ", "#eExactPos", "#time", "#pPosX", "#pPosY", "#pPosZ", "#pPos", "#pExactPosX", "#pExactPosY", "#pExactPosZ", "#pExactPos", "#pName", "#pUUID", "#pDirect", "#pYaw", "#pPitch", "#posX", "#posY", "#posZ", "#pos", "#rotation", "#bowPosX", "#bowPosY", "#bowPosZ", "#bowPos"};
    private static String[] bracketHashVariables = new String[]{"#rand(", "#randPosNeg(", "#randList(", "#circleOffset(", "#sPosX(", "#sPosY(", "#sPosZ(", "#sPos(", "#drop(", "#eval(", "#randPotionDamage("};
    private static Random random = new Random();
    private static ScriptEngine scriptEngine = new ScriptEngineManager(null).getEngineByName("JavaScript");

    public static String processString(String string, DropProcessData processData) {
        if (!string.contains("#") && !string.contains("$")) {
            return string;
        }
        string = HashVariables.processBracketHash(string, processData);
        string = string.replace("#randPotionDamage", String.valueOf(LuckyFunction.getRandomPotionDamage()));
        string = string.replace("#randPotionParticle", String.valueOf(LuckyFunction.getRandomStatusEffect()));
        string = string.replace("#randPotion", LuckyFunction.getRandomPotionName());
        string = string.replace("#randSpawnEggDamage", String.valueOf(LuckyFunction.getRandomMobEggID()));
        string = string.replace("#randSpawnEgg", LuckyFunction.getRandomMobEggName());
        if (processData != null) {
            Vec3d harvestPos = processData.getHarvestPos();
            string = string.replace("#bPosX", String.valueOf(Math.floor(harvestPos.field_72450_a)));
            string = string.replace("#bPosY", String.valueOf(Math.floor(harvestPos.field_72448_b)));
            string = string.replace("#bPosZ", String.valueOf(Math.floor(harvestPos.field_72449_c)));
            string = string.replace("#bPos", String.valueOf("(" + Math.floor(harvestPos.field_72450_a) + "," + Math.floor(harvestPos.field_72448_b) + "," + Math.floor(harvestPos.field_72449_c) + ")"));
            string = string.replace("#bExactPosX", String.valueOf(harvestPos.field_72450_a));
            string = string.replace("#bExactPosY", String.valueOf(harvestPos.field_72448_b));
            string = string.replace("#bExactPosZ", String.valueOf(harvestPos.field_72449_c));
            string = string.replace("#bExactPos", String.valueOf("(" + harvestPos.field_72450_a + "," + harvestPos.field_72448_b + "," + harvestPos.field_72449_c + ")"));
            if (processData.getHitEntity() != null) {
                Vec3d entityPos = processData.getHitEntity().func_174791_d();
                string = string.replace("#ePosX", String.valueOf(Math.floor(entityPos.field_72450_a)));
                string = string.replace("#ePosY", String.valueOf(Math.floor(entityPos.field_72448_b)));
                string = string.replace("#ePosZ", String.valueOf(Math.floor(entityPos.field_72449_c)));
                string = string.replace("#ePos", String.valueOf("(" + Math.floor(entityPos.field_72450_a) + "," + Math.floor(entityPos.field_72448_b) + "," + Math.floor(entityPos.field_72449_c) + ")"));
                string = string.replace("#eExactPosX", String.valueOf(entityPos.field_72450_a));
                string = string.replace("#eExactPosY", String.valueOf(entityPos.field_72448_b));
                string = string.replace("#eExactPosZ", String.valueOf(entityPos.field_72449_c));
                string = string.replace("#eExactPos", String.valueOf("(" + entityPos.field_72450_a + "," + entityPos.field_72448_b + "," + entityPos.field_72449_c + ")"));
            }
            if (processData.getWorld() != null) {
                string = string.replace("#time", String.valueOf(processData.getWorld().func_72820_D()));
            }
            if (processData.getPlayer() != null) {
                string = string.replace("#pPosX", String.valueOf(Math.floor(processData.getPlayer().field_70165_t)));
                string = string.replace("#pPosY", String.valueOf(Math.floor(processData.getPlayer().field_70163_u)));
                string = string.replace("#pPosZ", String.valueOf(Math.floor(processData.getPlayer().field_70161_v)));
                string = string.replace("#pPos", String.valueOf("(" + Math.floor(processData.getPlayer().field_70165_t) + "," + Math.floor(processData.getPlayer().field_70163_u) + "," + Math.floor(processData.getPlayer().field_70161_v) + ")"));
                string = string.replace("#pExactPosX", String.valueOf(processData.getPlayer().field_70165_t));
                string = string.replace("#pExactPosY", String.valueOf(processData.getPlayer().field_70163_u));
                string = string.replace("#pExactPosZ", String.valueOf(processData.getPlayer().field_70161_v));
                string = string.replace("#pExactPos", String.valueOf("(" + processData.getPlayer().field_70165_t + "," + processData.getPlayer().field_70163_u + "," + processData.getPlayer().field_70161_v + ")"));
                string = string.replace("#pName", processData.getPlayer().func_145748_c_().func_150260_c());
                string = string.replace("#pUUID", processData.getPlayer().func_110124_au().toString());
                int playerRotation = (int)Math.round(((double)processData.getPlayer().func_70079_am() + 180.0) / 90.0) % 4;
                if (playerRotation < 0) {
                    playerRotation += 4;
                }
                string = string.replace("#pDirect", String.valueOf(playerRotation));
                string = string.replace("#pYaw", String.valueOf(processData.getPlayer().func_70079_am()));
                string = string.replace("#pPitch", String.valueOf(processData.getPlayer().field_70125_A));
                EntityTippedArrow entityArrow = processData.getPlayer() instanceof EntityLivingBase ? new EntityTippedArrow(processData.getWorld(), (EntityLivingBase)processData.getPlayer()) : new EntityTippedArrow(processData.getWorld(), processData.getPlayer().field_70165_t, processData.getPlayer().field_70163_u, processData.getPlayer().field_70161_v);
                string = string.replace("#bowPosX", String.valueOf(entityArrow.func_174791_d().field_72450_a));
                string = string.replace("#bowPosY", String.valueOf(entityArrow.func_174791_d().field_72448_b));
                string = string.replace("#bowPosZ", String.valueOf(entityArrow.func_174791_d().field_72449_c));
                string = string.replace("#bowPos", String.valueOf("(" + entityArrow.func_174791_d().field_72450_a + "," + entityArrow.func_174791_d().field_72448_b + "," + entityArrow.func_174791_d().field_72449_c + ")"));
            }
        }
        string = string.replace("'#'", "#");
        string = string.replace("'@'", "@");
        string = string.replace("'$'", "'\u00a7'");
        string = string.replace("$", "\u00a7");
        string = string.replace("'\u00a7'", "$");
        return string;
    }

    private static String fixBackslash(String value) {
        value = value.replace("\\\\t", "\t");
        value = value.replace("\\\\b", "\b");
        value = value.replace("\\\\n", "\n");
        value = value.replace("\\\\r", "\r");
        value = value.replace("\\\\f", "\f");
        return value;
    }

    private static String getBracketHashValue(String string, DropProcessData processData) {
        try {
            String propertiesString = string.substring(string.indexOf(40) + 1, string.length() - 1);
            String[] properties = DropStringUtils.splitBracketString(propertiesString, ',');
            String type = string.substring(0, string.indexOf(40));
            if (type.equals("#rand") || type.equals("#randPosNeg")) {
                boolean isFloat = DropStringUtils.isGenericFloat(properties[0]) || DropStringUtils.isGenericFloat(properties[1]);
                properties[0] = DropStringUtils.removeNumSuffix(properties[0]);
                properties[1] = DropStringUtils.removeNumSuffix(properties[1]);
                if (isFloat) {
                    float min = ValueParser.getFloat(properties[0], processData).floatValue();
                    float max = ValueParser.getFloat(properties[1], processData).floatValue();
                    float num = MathHelper.func_151240_a((Random)random, (float)min, (float)max);
                    if (type.equals("#randPosNeg") && random.nextInt(2) == 0) {
                        num *= -1.0f;
                    }
                    return String.valueOf(num);
                }
                int min = ValueParser.getInteger(properties[0], processData);
                int max = ValueParser.getInteger(properties[1], processData);
                int num = random.nextInt(max - min + 1) + min;
                if (type.equals("#randPosNeg") && random.nextInt(2) == 0) {
                    num *= -1;
                }
                return String.valueOf(num);
            }
            if (type.equals("#randList")) {
                int index = random.nextInt(properties.length);
                return ValueParser.getString(properties[index], processData);
            }
            if (type.equals("#circleOffset")) {
                int min = 0;
                int max = 0;
                if (properties.length == 1) {
                    min = max = ValueParser.getInteger(properties[0], processData).intValue();
                } else if (properties.length == 2) {
                    min = ValueParser.getInteger(properties[0], processData);
                    max = ValueParser.getInteger(properties[1], processData);
                }
                int radius = random.nextInt(max - min + 1) + min;
                int angle = random.nextInt(360);
                int length = (int)Math.round((double)radius * Math.sin(Math.toRadians(angle)));
                int width = (int)Math.round((double)radius * Math.cos(Math.toRadians(angle)));
                return "(" + length + "," + 0 + "," + width + ")";
            }
            if (type.equals("#eval")) {
                Object value = scriptEngine.eval(HashVariables.processString(properties[0], processData));
                String result = String.valueOf(value);
                result = value instanceof Double && result.endsWith(".0") ? result.substring(0, result.length() - 2) : String.valueOf(value);
                return HashVariables.fixBackslash(result);
            }
            if (processData != null && processData.getProcessType() == DropProcessData.EnumProcessType.LUCKY_STRUCT && processData.getDropProperties() != null && (type.equals("#sPosX") || type.equals("#sPosY") || type.equals("#sPosZ") || type.equals("#sPos"))) {
                boolean isFloat = DropStringUtils.isGenericFloat(properties[0]) || DropStringUtils.isGenericFloat(properties[1]) || DropStringUtils.isGenericFloat(properties[2]);
                properties[0] = DropStringUtils.removeNumSuffix(properties[0]);
                properties[1] = DropStringUtils.removeNumSuffix(properties[1]);
                properties[2] = DropStringUtils.removeNumSuffix(properties[2]);
                DropProperties drop = processData.getDropProperties();
                Structure structure = Lucky.getStructure(drop.getPropertyString("ID"));
                if (structure == null) {
                    return "";
                }
                Vec3d harvestPos = new Vec3d((double)drop.getPropertyFloat("posX").floatValue(), (double)drop.getPropertyFloat("posY").floatValue(), (double)drop.getPropertyFloat("posZ").floatValue());
                int rotation = drop.getPropertyInt("rotation");
                if (isFloat) {
                    Vec3d structCoordPos = new Vec3d((double)ValueParser.getFloat(properties[0], processData).floatValue(), (double)ValueParser.getFloat(properties[1], processData).floatValue(), (double)ValueParser.getFloat(properties[2], processData).floatValue());
                    Vec3d worldPos = StructureUtils.getWorldPos(structCoordPos, structure.getCenterPos(), harvestPos, rotation);
                    if (type.equals("#sPosX")) {
                        return String.valueOf((float)worldPos.field_72450_a);
                    }
                    if (type.equals("#sPosY")) {
                        return String.valueOf((float)worldPos.field_72448_b);
                    }
                    if (type.equals("#sPosZ")) {
                        return String.valueOf((float)worldPos.field_72449_c);
                    }
                    if (type.equals("#sPos")) {
                        return String.valueOf(String.valueOf("(" + (float)worldPos.field_72450_a + "," + (float)worldPos.field_72448_b + "," + (float)worldPos.field_72449_c + ")"));
                    }
                } else {
                    BlockPos structCoordPos = new BlockPos(ValueParser.getInteger(properties[0], processData).intValue(), ValueParser.getInteger(properties[1], processData).intValue(), ValueParser.getInteger(properties[2], processData).intValue());
                    BlockPos worldPos = StructureUtils.getWorldPos(structCoordPos, structure.getCenterPos(), harvestPos, rotation);
                    if (type.equals("#sPosX")) {
                        return String.valueOf(Math.round(worldPos.func_177958_n()));
                    }
                    if (type.equals("#sPosY")) {
                        return String.valueOf(Math.round(worldPos.func_177956_o()));
                    }
                    if (type.equals("#sPosZ")) {
                        return String.valueOf(Math.round(worldPos.func_177952_p()));
                    }
                    if (type.equals("#sPos")) {
                        return String.valueOf(String.valueOf("(" + Math.round(worldPos.func_177958_n()) + "," + Math.round(worldPos.func_177956_o()) + "," + Math.round(worldPos.func_177952_p()) + ")"));
                    }
                }
            } else if (processData != null && processData.getProcessType() == DropProcessData.EnumProcessType.LUCKY_STRUCT && processData.getDropProperties() != null && type.equals("#drop")) {
                String name = properties[0];
                return processData.getDropProperties().getProperty(name).toString();
            }
        }
        catch (Exception e) {
            System.err.println("Lucky Block: Error processing hash variable: " + string);
            e.printStackTrace();
        }
        return "";
    }

    private static String processBracketHash(String value, DropProcessData processData) {
        ArrayList<Integer> points = new ArrayList<Integer>();
        int pointCount = 0;
        while (true) {
            int minPoint = -1;
            int minHashIndex = -1;
            for (int i = 0; i < bracketHashVariables.length; ++i) {
                int point = value.indexOf(bracketHashVariables[i], pointCount == 0 ? 0 : (Integer)points.get(pointCount - 1) + 1);
                if (point == -1 || minPoint != -1 && point >= minPoint) continue;
                minPoint = point;
                minHashIndex = i;
            }
            if (minPoint == -1) break;
            String hashType = bracketHashVariables[minHashIndex];
            int hashLength = bracketHashVariables[minHashIndex].length() - 1;
            points.add(pointCount, minPoint);
            String curHash = "";
            int curEndPoint = -1;
            char[] lineChar = value.toCharArray();
            int bracketTier = 0;
            boolean inQuotesBefore = false;
            boolean inQuotesNow = false;
            char[] newLine = new char[lineChar.length];
            int writeIndex = 0;
            for (int i = 0; i < lineChar.length; ++i) {
                boolean charCanceled = i > 0 && lineChar[i - 1] == '\\';
                newLine[writeIndex] = lineChar[i];
                if (i >= (Integer)points.get(pointCount) + hashLength) {
                    if (!charCanceled) {
                        if (lineChar[i] == '\"') {
                            boolean bl = inQuotesNow = !inQuotesNow;
                        }
                        if (!(lineChar[i] != '(' && lineChar[i] != '[' && lineChar[i] != '{' || inQuotesNow)) {
                            ++bracketTier;
                        }
                        if (!(lineChar[i] != ')' && lineChar[i] != ']' && lineChar[i] != '}' || inQuotesNow)) {
                            --bracketTier;
                        }
                        if (bracketTier == 0) {
                            char[] newLineFinal = new char[writeIndex + 1];
                            for (int j = 0; j < newLineFinal.length; ++j) {
                                newLineFinal[j] = newLine[j];
                            }
                            curHash = new String(newLineFinal);
                            curEndPoint = i;
                            break;
                        }
                    }
                    if (lineChar[i] == '\"' && charCanceled && inQuotesBefore) {
                        boolean charDoubleCanceled;
                        newLine[--writeIndex] = 34;
                        boolean bl = charDoubleCanceled = i >= 2 && lineChar[i - 2] == '\\';
                        if (!charDoubleCanceled) {
                            inQuotesNow = !inQuotesNow;
                        }
                    }
                } else if (lineChar[i] == '\"' && !charCanceled) {
                    inQuotesBefore = !inQuotesBefore;
                }
                ++writeIndex;
            }
            curHash = curHash.substring((Integer)points.get(pointCount), curHash.length());
            String result = HashVariables.getBracketHashValue(curHash, processData);
            String valuePart1 = value.substring(0, (Integer)points.get(pointCount));
            String valuePart2 = value.substring(curEndPoint + 1, value.length());
            value = valuePart1 + result + valuePart2;
            ++pointCount;
        }
        return value;
    }

    public static boolean containsHashVariables(String string) {
        for (String hashVariable : hashVariables) {
            if (!string.contains(hashVariable)) continue;
            return true;
        }
        for (String hashVariable : bracketHashVariables) {
            if (!string.contains(hashVariable)) continue;
            return true;
        }
        for (String hashVariable : CustomNBTTags.nbtHashVariables) {
            if (!string.contains(hashVariable)) continue;
            return true;
        }
        return false;
    }

    public static String autoCancelHash(String s) {
        s = s.replace("#", "'#'");
        s = s.replace("''#''", "'#'");
        s = s.replace("['#']", "#");
        return s;
    }
}

