/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.drop.func;

import mod.lucky.drop.DropProperties;
import mod.lucky.drop.func.DropFunction;
import mod.lucky.drop.func.DropProcessData;
import mod.lucky.drop.value.ValueParser;
import net.minecraft.potion.PotionType;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.WorldServer;

public class DropFuncParticle
extends DropFunction {
    @Override
    public void process(DropProcessData processData) {
        DropProperties drop = processData.getDropProperties();
        String particleName = drop.getPropertyString("ID");
        EnumParticleTypes particle = null;
        for (EnumParticleTypes particleType : EnumParticleTypes.values()) {
            if (!particleName.startsWith(particleType.func_179346_b()) || particleName.equals("splashpotion")) continue;
            particle = particleType;
            break;
        }
        if (processData.getWorld() instanceof WorldServer) {
            WorldServer worldServer = (WorldServer)processData.getWorld();
            if (particle != null) {
                int[] arguments = new int[particle.func_179345_d()];
                String[] astring1 = particleName.split("_", 3);
                for (int l = 1; l < astring1.length; ++l) {
                    try {
                        arguments[l - 1] = Integer.parseInt(astring1[l]);
                        continue;
                    }
                    catch (NumberFormatException numberformatexception) {
                        // empty catch block
                    }
                }
                float posX = drop.getPropertyFloat("posX").floatValue();
                float posY = drop.getPropertyFloat("posY").floatValue();
                float posZ = drop.getPropertyFloat("posZ").floatValue();
                int particleAmount = drop.getPropertyInt("particleAmount");
                float length = drop.getPropertyFloat("length").floatValue();
                float height = drop.getPropertyFloat("height").floatValue();
                float width = drop.getPropertyFloat("width").floatValue();
                worldServer.func_180505_a(particle, true, (double)posX, (double)posY, (double)posZ, particleAmount, (double)length, (double)height, (double)width, 0.0, arguments);
            } else {
                int id = ValueParser.getString(particleName, processData).equals("splashpotion") ? 2002 : ValueParser.getInteger(particleName, processData);
                int damage = 0;
                if (id == 2002) {
                    damage = drop.hasProperty("potion") ? PotionType.func_185171_a((PotionType)PotionType.func_185168_a((String)drop.getPropertyString("potion"))) : drop.getPropertyInt("damage");
                }
                worldServer.func_175718_b(id, drop.getBlockPos(), damage);
            }
        }
    }

    @Override
    public void registerProperties() {
        DropProperties.setDefaultProperty(this.getType(), "length", Float.class, Float.valueOf(0.0f));
        DropProperties.setDefaultProperty(this.getType(), "height", Float.class, Float.valueOf(0.0f));
        DropProperties.setDefaultProperty(this.getType(), "width", Float.class, Float.valueOf(0.0f));
        DropProperties.setDefaultProperty(this.getType(), "size", String.class, "(0.0,0.0,0.0)");
        DropProperties.setDefaultProperty(this.getType(), "particleAmount", Integer.class, 1);
        DropProperties.setDefaultProperty(this.getType(), "potion", String.class, "poison");
    }

    @Override
    public String getType() {
        return "particle";
    }
}

