/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.drop.func;

import mod.lucky.drop.DropProperties;
import mod.lucky.drop.func.DropFunction;
import mod.lucky.drop.func.DropProcessData;
import mod.lucky.entity.EntityLuckyProjectile;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class DropFuncEntity
extends DropFunction {
    @Override
    public void process(DropProcessData processData) {
        DropProperties drop = processData.getDropProperties();
        float posX = drop.getPropertyFloat("posX").floatValue();
        float posY = drop.getPropertyFloat("posY").floatValue();
        float posZ = drop.getPropertyFloat("posZ").floatValue();
        if (posY <= -1.0f) {
            return;
        }
        NBTTagCompound nbtTagCompound = drop.getPropertyNBT("NBTTag") == null ? new NBTTagCompound() : drop.getPropertyNBT("NBTTag");
        String id = drop.getPropertyString("ID");
        if (id.equals("LightningBolt")) {
            processData.getWorld().func_72942_c((Entity)new EntityLightningBolt(processData.getWorld(), (double)posX, (double)posY, (double)posZ, false));
            return;
        }
        nbtTagCompound.func_74778_a("id", id);
        DropFuncEntity.spawnEntity(processData, nbtTagCompound, processData.getWorld(), posX, posY, posZ);
    }

    private static Entity spawnEntity(DropProcessData processData, NBTTagCompound nbtTagCompound, World world, double posX, double posY, double posZ) {
        Entity entity = EntityList.func_75615_a((NBTTagCompound)nbtTagCompound, (World)world);
        if (entity == null) {
            return null;
        }
        boolean hasPos = nbtTagCompound.func_74764_b("Pos");
        boolean hasMotion = nbtTagCompound.func_74764_b("Motion");
        boolean hasRotation = nbtTagCompound.func_74764_b("Rotation");
        if (!hasPos) {
            entity.field_70165_t = posX;
            entity.field_70163_u = posY;
            entity.field_70161_v = posZ;
        }
        if (entity instanceof EntityThrowable && !hasRotation && hasMotion) {
            float sqrt = MathHelper.func_76133_a((double)(entity.field_70159_w * entity.field_70159_w + entity.field_70179_y * entity.field_70179_y));
            entity.field_70177_z = (float)(Math.atan2(entity.field_70159_w, entity.field_70179_y) * 180.0 / Math.PI);
            entity.field_70125_A = (float)(Math.atan2(entity.field_70181_x, sqrt) * 180.0 / Math.PI);
            entity.field_70133_I = true;
        }
        if (entity instanceof EntityFallingBlock && !nbtTagCompound.func_74764_b("Time")) {
            ((EntityFallingBlock)entity).field_145812_b = 1;
        } else if (entity instanceof EntityLuckyProjectile) {
            ((EntityLuckyProjectile)entity).shootingEntity = processData.getPlayer();
        } else if (entity instanceof EntityArrow) {
            ((EntityArrow)entity).field_70250_c = processData.getPlayer();
        }
        for (int y = 0; y < 10; ++y) {
            if (!processData.getWorld().func_175623_d(new BlockPos(entity.field_70165_t, entity.field_70163_u + (double)y, entity.field_70161_v))) continue;
            entity.field_70163_u += (double)y;
            break;
        }
        entity.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
        if (entity instanceof EntityLiving) {
            if (processData.getProcessType() != DropProcessData.EnumProcessType.LUCKY_STRUCT) {
                ((EntityLiving)entity).func_180482_a(world.func_175649_E(new BlockPos(entity)), (IEntityLivingData)null);
            }
            ((EntityLiving)entity).func_70037_a(nbtTagCompound);
        }
        if (!world.func_72838_d(entity)) {
            return null;
        }
        if (nbtTagCompound.func_150297_b("Passengers", 9)) {
            NBTTagList nbttaglist = nbtTagCompound.func_150295_c("Passengers", 10);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                Entity entity1 = DropFuncEntity.spawnEntity(processData, nbttaglist.func_150305_b(i), world, posX, posY, posZ);
                if (entity1 == null) continue;
                entity1.func_184205_a(entity, true);
            }
        }
        return entity;
    }

    @Override
    public void registerProperties() {
        DropProperties.setDefaultProperty(this.getType(), "NBTTag", NBTTagCompound.class, null);
        DropProperties.setDefaultProperty(this.getType(), "posX", Float.class, Float.valueOf(0.0f));
        DropProperties.setDefaultProperty(this.getType(), "posY", Float.class, Float.valueOf(0.0f));
        DropProperties.setDefaultProperty(this.getType(), "posZ", Float.class, Float.valueOf(0.0f));
        DropProperties.setDefaultProperty(this.getType(), "posOffsetX", Float.class, Float.valueOf(0.0f));
        DropProperties.setDefaultProperty(this.getType(), "posOffsetY", Float.class, Float.valueOf(0.0f));
        DropProperties.setDefaultProperty(this.getType(), "posOffsetZ", Float.class, Float.valueOf(0.0f));
    }

    @Override
    public String getType() {
        return "entity";
    }
}

