/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.proxy;

import com.sun.deploy.config.Config;
import com.sun.deploy.net.proxy.AbstractAutoProxyHandler;
import com.sun.deploy.net.proxy.BrowserProxyInfo;
import com.sun.deploy.net.proxy.ProxyConfigException;
import com.sun.deploy.net.proxy.ProxyInfo;
import com.sun.deploy.net.proxy.ProxyUnavailableException;
import com.sun.deploy.trace.Trace;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.StringTokenizer;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

public class SunAutoProxyHandler
extends AbstractAutoProxyHandler {
    private ScriptEngineManager manager = null;
    private ScriptEngine engine = null;
    private static final String jsDnsResolve = "    function dnsResolve(host){\n                       return String(obj.dnsResolve(host));\n     }";

    public String dnsResolve(final String string) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return SunAutoProxyHandler.this.dnsResolveImpl(string);
            }
        });
    }

    private String dnsResolveImpl(String string) {
        String string2 = "";
        try {
            string2 = InetAddress.getByName(string).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
        return string2;
    }

    protected String getBrowserSpecificAutoProxy() {
        return jsDnsResolve;
    }

    public final void init(BrowserProxyInfo browserProxyInfo) throws ProxyConfigException {
        super.init(browserProxyInfo);
        this.initEngine(Config.getNoPermissionACC());
    }

    private void initEngine(AccessControlContext accessControlContext) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SunAutoProxyHandler.this.initEngine();
                return null;
            }
        }, accessControlContext);
    }

    private void initEngine() {
        this.manager = new ScriptEngineManager(null);
        this.engine = this.manager.getEngineByName("js");
    }

    public ProxyInfo[] getProxyInfo(URL uRL) throws ProxyUnavailableException {
        ProxyInfo[] proxyInfoArray = null;
        proxyInfoArray = this.jsGetProxyInfo(uRL, Config.getNoPermissionACC());
        if (proxyInfoArray == null) {
            proxyInfoArray = this.fallbackGetProxyInfo(uRL);
        }
        return proxyInfoArray;
    }

    private ProxyInfo[] jsGetProxyInfo(final URL uRL, AccessControlContext accessControlContext) {
        return (ProxyInfo[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return SunAutoProxyHandler.this.jsGetProxyInfo(uRL);
            }
        }, accessControlContext);
    }

    private ProxyInfo[] jsGetProxyInfo(URL uRL) {
        ProxyInfo[] proxyInfoArray = null;
        if (this.engine != null) {
            try {
                this.engine.put("obj", this);
                this.engine.eval(this.autoProxyScript.toString());
                if (this.engine instanceof Invocable) {
                    Invocable invocable = (Invocable)((Object)this.engine);
                    Object object = invocable.invokeFunction("FindProxyForURL", uRL.toString(), uRL.getHost());
                    proxyInfoArray = this.extractAutoProxySetting((String)object);
                } else {
                    Trace.netPrintln("JavaScript engine cannot invoke methods");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return proxyInfoArray;
    }

    ProxyInfo[] fallbackGetProxyInfo(URL uRL) {
        try {
            String string = null;
            if (this.jsPacScript != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(this.jsPacScript, ";", false);
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    int n = string2.indexOf("DIRECT");
                    int n2 = string2.indexOf("PROXY");
                    int n3 = string2.indexOf("SOCKS");
                    int n4 = this.positiveMin(n, this.positiveMin(n2, n3));
                    int n5 = string2.lastIndexOf("\"");
                    if (n4 == -1) continue;
                    string = n5 <= n4 ? string2.substring(n4) : string2.substring(n4, n5);
                    break;
                }
            }
            return this.extractAutoProxySetting(string);
        }
        catch (Throwable throwable) {
            Trace.msgNetPrintln("net.proxy.auto.result.error");
            return new ProxyInfo[]{new ProxyInfo(null)};
        }
    }

    private int positiveMin(int n, int n2) {
        if (n < 0) {
            return n2;
        }
        if (n2 < 0) {
            return n;
        }
        if (n > n2) {
            return n2;
        }
        return n;
    }
}

