/*
 * Decompiled with CFR 0.152.
 */
package win7pecore.corebuild;

import build.Core;
import downloads.common;
import inifiles.IniFile;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import relink.MSlink;
import utils.ExtractSevenZip;
import utils.Settings;
import utils.files;
import win7pecore.CustomShortcut;
import win7pecore.Shortcuts;
import win7pecore.corebuild.PluginTemplate;

public class StartupCode
extends PluginTemplate {
    final String pluginName = "StartupCode";
    String nameRoot;
    Settings settings;
    File peDevDir;
    File target;
    String drive;
    File customFolder;

    public StartupCode() {
        this.setName("StartupCode");
    }

    @Override
    public boolean pluginCode() {
        String theInf;
        String theDir;
        int p;
        String drv;
        Object driver;
        File textFile;
        this.logit();
        this.extractRAM();
        this.extractCD();
        this.hive.softwareHive.createValue("Microsoft\\Windows\\CurrentVersion", "CommonFilesDir", 1, "X:\\Program Files\\Common Files");
        this.hive.softwareHive.createValue("Microsoft\\Windows\\CurrentVersion", "ProgramFilesDir", 1, "X:\\Program Files");
        boolean useHideRun = false;
        if (this.pluginSettings != null) {
            useHideRun = this.pluginSettings.read("UseHideRun", "False").equalsIgnoreCase("True");
        }
        if ((textFile = new File(this.winpe.targetWinSysFolder, "winpeshl.ini")).exists()) {
            textFile.delete();
        }
        IniFile txt = new IniFile(textFile);
        txt.sectionCreate("LaunchApps");
        File test1 = new File(this.winpe.targetWinSysFolder, "startboot.cmd");
        File test2 = new File(this.winpe.targetWinSysFolder, "startlogon.cmd");
        if (useHideRun) {
            File source = new File(this.winpe.targetWinSysFolder, "hiderunEx.zip");
            ExtractSevenZip extractor = new ExtractSevenZip(source, this.winpe.targetWinSysFolder, null);
            try {
                extractor.extract("hiderunEx.exe", "exec");
            }
            catch (ExtractSevenZip.ExtractionException ex) {
                Logger.getLogger(StartupCode.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (test1.exists()) {
                txt.sectionLineInsert("LaunchApps", -1, "hiderunEx.exe, \"/w /c startboot.cmd\"");
            }
            txt.sectionLineInsert("LaunchApps", -1, "hiderunEx.exe, \"/w easyDriveLetter.exe\"");
            if (test2.exists()) {
                txt.sectionLineInsert("LaunchApps", -1, "hiderunEx.exe, \"/w /c startlogon.cmd\"");
            }
        } else {
            if (test1.exists()) {
                txt.sectionLineInsert("LaunchApps", -1, "\"startboot.cmd\"");
            }
            txt.sectionLineInsert("LaunchApps", -1, "\"easyDriveLetter.exe\"");
            if (test2.exists()) {
                txt.sectionLineInsert("LaunchApps", -1, "\"startlogon.cmd\"");
            }
        }
        txt.sectionLineInsert("LaunchApps", -1, "\"%SystemRoot%\\explorer.exe\"");
        txt.sectionCreate("Admin");
        txt.keyWrite("Admin", "Newletter", this.cdDrive);
        txt.keyWrite("Admin", "Date", new SimpleDateFormat("yyyy-MMM-dd").format(new Date()));
        try {
            txt.closeFile();
        }
        catch (IOException ex) {
            Logger.getLogger(StartupCode.class.getName()).log(Level.SEVERE, null, ex);
        }
        textFile = new File(this.winpe.targetWinSysFolder, "easyDriveLetter.ini");
        if (textFile.exists()) {
            textFile.delete();
        }
        txt = new IniFile(textFile);
        txt.sectionCreate("Params");
        txt.keyWrite("Params", "LoaderConfig", this.winpe.projectName + ".cfg");
        txt.keyWrite("Params", "MediaType", "DRIVE_CDROM");
        txt.keyWrite("Params", "VolumeID", this.winpe.projectName);
        String dbg = this.winpe.projectSettings.read("BootDebug", "False");
        if (dbg.equalsIgnoreCase("True")) {
            txt.keyWrite("Params", "Debug", "True");
        }
        HashMap startShell = (HashMap)Core.temp.get("StartShell");
        Collection shellEntries = startShell.values();
        HashMap drivers = (HashMap)Core.temp.get("Drivers");
        txt.sectionCreate("LaunchPC");
        int counter = 1;
        for (int i = 0; i < drivers.size(); ++i) {
            driver = drivers.get(i);
            drv = driver.toString();
            p = drv.lastIndexOf("\\");
            theDir = drv.substring(0, p);
            theInf = drv.substring(p + 1);
            txt.keyWrite("LaunchPC", "Launch" + String.valueOf(counter++), "addDriver.cmd|" + theDir + " " + theInf);
        }
        for (Object entry : shellEntries) {
            txt.keyWrite("LaunchPC", "Launch" + String.valueOf(counter++), entry.toString() + "||SILENTNOWAIT");
        }
        txt.keyWrite("LaunchPC", "Launch" + String.valueOf(counter++), "%SystemRoot%\\System32\\IconRefresh.exe||SILENT");
        txt.keyWrite("LaunchPC", "Launch" + String.valueOf(counter++), "%SystemRoot%\\System32\\RemapDrives.exe|/x " + this.cdDrive + " $@$???$@$|SILENT");
        txt.keyWrite("LaunchPC", "Launch" + String.valueOf(counter++), "%SystemRoot%\\System32\\NoDIni.exe||SILENTNOWAIT");
        txt.keyWrite("LaunchPC", "Launch" + String.valueOf(counter++), "%SystemRoot%\\System32\\ReloadEnv.exe||SILENT");
        txt.keyWrite("LaunchPC", "Count", String.valueOf(--counter));
        txt.sectionCreate("LaunchVM");
        counter = 1;
        for (int i = 0; i < drivers.size(); ++i) {
            driver = drivers.get(i);
            drv = driver.toString();
            p = drv.lastIndexOf("\\");
            theDir = drv.substring(0, p);
            theInf = drv.substring(p + 1);
            txt.keyWrite("LaunchVM", "Launch" + String.valueOf(counter++), "addDriver.cmd|" + theDir + " " + theInf);
        }
        for (Object entry : shellEntries) {
            txt.keyWrite("LaunchVM", "Launch" + String.valueOf(counter++), entry.toString() + "||SILENTNOWAIT");
        }
        txt.keyWrite("LaunchVM", "Launch" + String.valueOf(counter++), "%SystemRoot%\\System32\\IconRefresh.exe||SILENT");
        txt.keyWrite("LaunchVM", "Launch" + String.valueOf(counter++), "%SystemRoot%\\System32\\NoDIni.exe||SILENTNOWAIT");
        txt.keyWrite("LaunchVM", "Count", String.valueOf(--counter));
        this.setResolution("PCScreen", txt);
        this.setResolution("VMScreen", txt);
        if (Core.sys.useRegistration) {
            this.winpe.addPlugin("BrandPE");
        }
        File toHash = Core.sys.useCertification ? new File(this.winpe.targetWinSysFolder, "winpe.bmp") : new File(this.winpe.targetWinSysFolder, "winpeshl.ini");
        String hex = Core.sys.registrationLib.getHashVal(toHash);
        txt.keyWrite("Params", "Hash", hex);
        try {
            txt.closeFile();
        }
        catch (IOException ex) {
            Logger.getLogger(StartupCode.class.getName()).log(Level.SEVERE, null, ex);
        }
        File autoRunFile = new File(this.winpe.targetWinSysFolder, "autoRun.cmd");
        if (autoRunFile.exists()) {
            txt = new IniFile(autoRunFile);
            txt.lineInsert(-1, "exit");
            try {
                txt.closeFile();
            }
            catch (IOException ex) {
                Logger.getLogger(StartupCode.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.sourceWIM.boot.extractMui("Windows\\System32\\attrib.exe");
        File localDevDir = common.getFolderDevelop();
        File tag = new File(localDevDir, "nocopy");
        if (!tag.exists()) {
            String theName = localDevDir.getName();
            File peDevDir = new File(this.winpe.targetWimFolder, theName);
            files.copyFolder(localDevDir, peDevDir);
        }
        this.checkUserFolder(common.getFolderUser_CD(), false);
        this.checkUserFolder(common.getFolderUser_RAM(), true);
        if (this.winpe.projectSettings.read("DesktopCommandLink", "False").equalsIgnoreCase("True")) {
            this.peLibrary.addDesktopShortcut(null, "cmd.exe", null, "Command.lnk", null);
        }
        this.peLibrary.importReg(this.hive.defaultHive, "StartupCode", "stuckrects.reg");
        String fbwf = this.winpe.projectSettings.read("FBWF", "$Default");
        if (!fbwf.equalsIgnoreCase("$Default")) {
            int val = Integer.parseInt(fbwf);
            this.hive.systemHive.createValue("ControlSet001\\Services\\FBWF", "WinPECacheThreshold", 4, val);
        }
        return true;
    }

    void checkUserFolder(File folder, boolean isRam) {
        File tag;
        if (folder.exists() && !(tag = new File(folder, "nocopy")).exists()) {
            File[] fileList;
            int index;
            if (isRam) {
                this.target = this.winpe.targetWimFolder;
                this.drive = "X:";
                index = 42;
            } else {
                this.target = this.winpe.targetBootFolder;
                this.drive = Core.sys.settings.read("CD-Drive", "Y:");
                index = 11;
            }
            File theDrive = new File(this.drive);
            this.customFolder = new File(theDrive, folder.getName());
            String theName = folder.getName();
            this.peDevDir = new File(this.target, theName);
            files.copyFolder(folder, this.peDevDir);
            CustomShortcut peShortcut = (CustomShortcut)Core.temp.get("Shortcuts");
            peShortcut.addFolder(this.drive, theName, index);
            for (File file : fileList = folder.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getName().toLowerCase().endsWith(".xml");
                }
            })) {
                this.nameRoot = file.getName().replace(".xml", "");
                this.settings = new Settings(file, "Settings for " + this.nameRoot);
                File linkFile = this.generateShortcut();
                if (linkFile != null) {
                    if (this.settings.read("DesktopShortcut", "false").equalsIgnoreCase("True")) {
                        String desktopFolder = this.settings.read("DesktopFolder");
                        if (desktopFolder.equalsIgnoreCase("$Default")) {
                            desktopFolder = "CustomFolder";
                        }
                        this.copyShortcut("Desktop", linkFile, desktopFolder, this.drive);
                    }
                    if (this.settings.read("StartmenuShortcut", "false").equalsIgnoreCase("True")) {
                        String startmenuFolder = this.settings.read("StartMenuFolder");
                        if (startmenuFolder.equalsIgnoreCase("$Default")) {
                            startmenuFolder = "CustomFolder";
                        }
                        this.copyShortcut("StartMenu", linkFile, startmenuFolder, this.drive);
                    }
                }
                new File(this.peDevDir, file.getName()).delete();
            }
        }
    }

    void copyShortcut(String type, File shPath, String subDir, String cdDrive) {
        char cdDriveLetter = cdDrive.charAt(0);
        File targ = null;
        File winDirFolder = new File(Core.sys.build.folderPeWIM, "Windows");
        File winSysFolder = new File(winDirFolder, "System32");
        File profile = new File(winSysFolder, "config");
        profile = new File(profile, "systemprofile");
        File roaming = new File(profile, "AppData");
        roaming = new File(roaming, "Roaming");
        roaming = new File(roaming, "Microsoft");
        roaming = new File(roaming, "Windows");
        if (type.equalsIgnoreCase("Desktop")) {
            targ = new File(profile, "DeskTop");
        } else if (type.equalsIgnoreCase("StartMenu")) {
            File menu = new File(roaming, "Start Menu");
            targ = new File(menu, "Programs");
        }
        if (targ != null) {
            if (!subDir.equals("")) {
                targ = new File(targ, subDir);
            }
            files.mkdirs(targ);
            String nam = shPath.getName();
            File trg = new File(targ, nam);
            files.copyFile(shPath, trg);
            try {
                Shortcuts.changeDriveLetter(trg, cdDriveLetter);
            }
            catch (IOException ex) {
                Logger.getLogger(StartupCode.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    File generateShortcut() {
        MSlink newLink = new MSlink();
        File linkFile = null;
        String targ = this.settings.read("ShortcutTarget", "").replace("\\", System.getProperty("file.separator"));
        File peExe = new File(this.customFolder, targ);
        String target = peExe.getPath().replace(System.getProperty("file.separator"), "\\");
        newLink.setTarget(target, false);
        String openmodus = this.settings.read("OpenModus", "MSlink.SW_SHOWNORMAL");
        int modus = openmodus.equals("SW_SHOWMAXIMIZED") ? 3 : (openmodus.equals("SW_SHOWMINNOACTIVE") ? 7 : 1);
        newLink.setShowWindowMode(modus);
        String linkName = this.settings.read("ShortcutFileName", "$Default");
        if (linkName.equalsIgnoreCase("$Default")) {
            linkName = peExe.getName().replace(".exe", ".lnk");
        }
        String tempDir = System.getProperty("java.io.tmpdir");
        linkFile = new File(tempDir, linkName);
        newLink.save(linkFile);
        return linkFile;
    }

    void setResolution(String what, IniFile txt) {
        String wanted = this.peLibrary.getOptionString(this.winpe.projectSettings, what);
        if (!wanted.equalsIgnoreCase("DEFAULT")) {
            txt.sectionCreate(what + "Alt");
            txt.keyWrite(what + "Alt", "xres", "800");
            txt.keyWrite(what + "Alt", "yres", "600");
            txt.sectionCreate(what);
            String[] pair = wanted.split("x");
            txt.keyWrite(what, "xres", pair[0]);
            txt.keyWrite(what, "yres", pair[1]);
        }
    }
}

