/*
 * Decompiled with CFR 0.152.
 */
package win7pecore.corebuild;

import bsh2java.Plugin;
import bsh2java.log;
import build.Core;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import reg.RegHeader;
import utils.Settings;
import utils.files;
import win7pecore.ArchiveWIM;
import win7pecore.Hives;
import win7pecore.Shortcuts;
import win7pecore.WinPeLibrary;
import win7pecore.components.VSS;

public class PluginTemplate
extends Plugin {
    protected String ramZip;
    protected String cdZip;
    protected String appZip;
    protected Settings pluginSettings = null;
    protected WinPeLibrary peLibrary = null;
    protected ArchiveWIM sourceWIM = null;
    protected Hives hive = null;
    protected HashMap componentList;
    protected Shortcuts shortcutLib;
    String name;
    protected String cdDrive;
    protected File fileCache;
    protected final String sourceLanguage;
    protected final String sourceBuild;
    protected final String sourceMajor;

    public PluginTemplate() {
        this.sourceMajor = this.winpe.coreSource.major;
        this.sourceLanguage = this.winpe.coreSource.defaultLanguage;
        this.sourceBuild = this.winpe.coreSource.build + "." + this.winpe.coreSource.spbuild;
        this.pluginSettings = (Settings)Core.temp.get("pluginSettings");
        this.peLibrary = new WinPeLibrary(this.winpe);
        this.sourceWIM = (ArchiveWIM)Core.temp.get("sourceWim");
        this.hive = (Hives)Core.temp.get("hive");
        this.componentList = (HashMap)Core.temp.get("componentList");
        if (this.pluginSettings != null) {
            this.shortcutLib = new Shortcuts(this.pluginSettings.getSettingsFile());
            this.shortcutLib.setPeLib(this.peLibrary);
            this.shortcutLib.getInfo();
        }
        this.cdDrive = Core.sys.settings.read("CD-Drive", "Y:");
    }

    private void subPatch(File candidate, String search) throws FileNotFoundException, IOException {
        int start;
        boolean replaced = false;
        byte[] bSrch = new byte[search.length() * 2];
        int p = 0;
        for (start = 0; start < search.length(); ++start) {
            bSrch[p++] = (byte)search.charAt(start);
            bSrch[p++] = 0;
        }
        int len = bSrch.length;
        FileInputStream fis = new FileInputStream(candidate);
        byte[] buffer = new byte[(int)candidate.length()];
        fis.read(buffer);
        fis.close();
        for (start = 0; start < buffer.length - len; ++start) {
            boolean found = true;
            for (p = 0; p < len; ++p) {
                if (buffer[start + p] == bSrch[p]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            buffer[start + p - 2] = 88;
            replaced = true;
        }
        if (replaced) {
            FileOutputStream fos = new FileOutputStream(candidate);
            fos.write(buffer);
            fos.close();
        }
    }

    protected void denyPE(String fileName) {
        try {
            File candidate = new File(this.winpe.targetWinSysFolder, fileName);
            this.subPatch(candidate, "MININT");
            this.subPatch(candidate, "MiniNT");
            this.subPatch(candidate, "SystemSetupInProgress");
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(VSS.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(VSS.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected void setName(String pluginName) {
        this.name = pluginName;
        this.ramZip = pluginName + "/plugin_RAM.zip";
        this.cdZip = pluginName + "/plugin_CD.zip";
        this.appZip = pluginName + "/plugin_APP.zip";
    }

    public boolean getCachedFiles() {
        this.fileCache = new File(this.winpe.sourceFilesFolder, this.name);
        if (this.fileCache.exists()) {
            File content = new File(this.fileCache, this.winpe.targetWinFolder.getName());
            files.copyFolder(content, this.winpe.targetWinFolder);
            return true;
        }
        return false;
    }

    public boolean pluginCode() {
        return true;
    }

    protected void extractRAM() {
        this.peLibrary.unZipResource(this.ramZip, this.winpe.targetWimFolder);
    }

    protected void extractCD() {
        this.peLibrary.unZipResource(this.cdZip, this.winpe.targetBootFolder);
    }

    protected void extractAPP() {
        this.peLibrary.unZipResource(this.appZip, this.shortcutLib.getLocalTargetFolder());
    }

    protected void logit() {
        String typ = "CORE";
        if (this.pluginSettings != null) {
            typ = this.pluginSettings.read("!Type", "CORE").toUpperCase();
        }
        log.write(500, typ + ": %1", this.name);
    }

    protected void logit(int message) {
        String typ = "CORE";
        if (this.pluginSettings != null) {
            typ = this.pluginSettings.read("!Type", "CORE").toUpperCase();
        }
        log.write(message, typ + ": %1", this.name);
    }

    protected void importResource(RegHeader theHive, String resource) {
        File tempFile = this.peLibrary.copyResourceToTempFile(this.name + "/" + resource);
        if (tempFile != null) {
            theHive.importReg(tempFile.getAbsolutePath());
            tempFile.delete();
        }
    }
}

