/*
 * Decompiled with CFR 0.152.
 */
package win7pecore.corebuild;

import build.Core;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import utils.files;
import win7pecore.corebuild.PluginTemplate;

public class BaseHive
extends PluginTemplate {
    final String pluginName = "BaseHive";
    final File sourceHivesDir;
    final File configBuildCache;
    final File configBootCache;
    final File configInstallCache;
    final File configPE;

    public BaseHive() {
        this.sourceHivesDir = this.winpe.sourceHivesFolder;
        this.configBuildCache = new File(this.sourceHivesDir, "build");
        this.configBootCache = new File(this.sourceHivesDir, "boot");
        this.configInstallCache = new File(this.sourceHivesDir, "install");
        this.configPE = new File(this.winpe.targetWinSysFolder, "config");
        this.setName("BaseHive");
    }

    private File copyHive(String hiveName) {
        File targetBoot = new File(this.sourceHivesDir, "boot");
        File targetInstall = new File(this.sourceHivesDir, "install");
        File targetWinre = new File(this.sourceHivesDir, "winre");
        File target = new File(targetBoot, hiveName);
        if (!target.exists()) {
            this.sourceWIM.boot.extractFile("Windows\\System32\\config\\" + hiveName, targetBoot.getAbsolutePath());
        }
        if (!(target = new File(targetInstall, hiveName)).exists()) {
            this.sourceWIM.install.extractFile("Windows\\System32\\config\\" + hiveName, targetInstall.getAbsolutePath());
        }
        if (!(target = new File(targetWinre, hiveName)).exists()) {
            this.sourceWIM.winre.extractFile("Windows\\System32\\config\\" + hiveName, targetWinre.getAbsolutePath());
        }
        return target;
    }

    private void transferHive(String hiveName, File sourceConfig, File targetConfig) {
        this.transferHive(hiveName, sourceConfig, targetConfig, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean transferHive(String hiveName, File sourceConfig, File targetConfig, int addMeg) {
        boolean result = true;
        File theHive = new File(sourceConfig, hiveName);
        File target = new File(targetConfig, hiveName);
        if (target.exists()) {
            target.delete();
        }
        files.copyFile(theHive, target);
        if (addMeg != 0) {
            byte[] add = new byte[0x100000];
            FileOutputStream output = null;
            try {
                output = new FileOutputStream(target.getAbsoluteFile(), true);
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(BaseHive.class.getName()).log(Level.SEVERE, null, ex);
                result = false;
            }
            try {
                for (int i = 0; i < addMeg; ++i) {
                    output.write(add);
                }
            }
            catch (IOException ex) {
                Logger.getLogger(BaseHive.class.getName()).log(Level.SEVERE, null, ex);
                result = false;
            }
            finally {
                try {
                    output.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(BaseHive.class.getName()).log(Level.SEVERE, null, ex);
                    result = false;
                }
            }
        }
        return result;
    }

    boolean loadBaseHive() {
        this.transferHive("DEFAULT", this.configBuildCache, this.configPE);
        this.transferHive("SYSTEM", this.configBuildCache, this.configPE);
        this.transferHive("SOFTWARE", this.configBuildCache, this.configPE);
        this.transferHive("SAM", this.configBootCache, this.configPE);
        this.transferHive("SECURITY", this.configBootCache, this.configPE);
        return true;
    }

    void buildBaseHive() {
        File winreDir;
        File installDir;
        File bootDir;
        if (!this.sourceHivesDir.exists()) {
            files.mkdirs(this.sourceHivesDir);
        }
        if (!(bootDir = new File(this.sourceHivesDir, "boot")).exists()) {
            files.mkdirs(bootDir);
        }
        if (!(installDir = new File(this.sourceHivesDir, "install")).exists()) {
            files.mkdirs(installDir);
        }
        if (!(winreDir = new File(this.sourceHivesDir, "winre")).exists()) {
            files.mkdirs(winreDir);
        }
        if (!this.configBuildCache.exists()) {
            files.mkdirs(this.configBuildCache);
        }
        this.copyHive("DEFAULT");
        this.copyHive("SYSTEM");
        this.copyHive("SOFTWARE");
        this.copyHive("SAM");
        this.copyHive("SECURITY");
        this.transferHive("DEFAULT", this.configBootCache, this.configBuildCache);
        this.transferHive("SYSTEM", this.configBootCache, this.configBuildCache);
        this.extractRAM();
        this.transferHive("SOFTWARE", this.configPE, this.configBuildCache);
        this.hive.open(this.winpe, this.configBuildCache);
        this.peLibrary.addPlugin("AssembleHive");
        this.hive.closeHives();
    }

    @Override
    public boolean pluginCode() {
        this.logit();
        File buildSoftware = new File(this.configBuildCache, "SOFTWARE");
        boolean projectHivesExist = buildSoftware.exists();
        Core.temp.put("projectHivesExist", Boolean.toString(projectHivesExist));
        if (!projectHivesExist) {
            this.buildBaseHive();
        }
        Core.temp.put("projectHivesExist", Boolean.toString(true));
        return this.loadBaseHive();
    }
}

