/*
 * Decompiled with CFR 0.152.
 */
package win7pecore.components;

import bsh2java.log;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import utils.ImageConvert;
import win7pecore.corebuild.PluginTemplate;

public class WallPaper
extends PluginTemplate {
    final String pluginName = "WallPaper";

    public WallPaper() {
        this.setName("WallPaper");
    }

    @Override
    public boolean pluginCode() {
        if (!this.componentList.containsKey("WallPaper")) {
            this.logit();
            File wallPaper = new File(this.winpe.targetWinSysFolder, "winpe.bmp");
            if (wallPaper.exists()) {
                wallPaper.delete();
            }
            File customWallPaper = null;
            String[] wildCards = new String[]{"WallPaper.jpg", "WallPaper.bmp", "WallPaper.gif"};
            WildcardFileFilter fileFilter = new WildcardFileFilter(wildCards);
            File[] files2 = this.winpe.coreFolder.listFiles(fileFilter);
            if (files2.length > 0) {
                customWallPaper = files2[0];
            }
            if (customWallPaper != null) {
                ImageConvert imgConvert = new ImageConvert(customWallPaper);
                imgConvert.writeImage(wallPaper.getAbsolutePath(), "bmp");
            } else {
                this.sourceWIM.install.extractFile("Windows\\System32\\oobe\\background.bmp", this.winpe.targetWinSysFolder.getAbsolutePath());
                File src = new File(this.winpe.targetWinSysFolder, "background.bmp");
                try {
                    FileUtils.moveFile(src, wallPaper);
                }
                catch (IOException ex) {
                    log.write(-1, "Failed to move wallpaperfile 1% to %2 with error message %3", src.getAbsolutePath(), wallPaper.getAbsolutePath(), ex.getLocalizedMessage());
                }
            }
            this.peLibrary.importReg(this.hive.systemHive, "WallPaper", "productoptions.reg");
            this.peLibrary.importReg(this.hive.softwareHive, "WallPaper", "personalisation.reg");
            this.componentList.put("WallPaper", this);
        }
        return true;
    }
}

