/*
 * Decompiled with CFR 0.152.
 */
package win7pecore.components;

import win7pecore.corebuild.PluginTemplate;

public class ExplorerSearch
extends PluginTemplate {
    final String pluginName = "ExplorerSearch";
    final String sourceLanguage;
    final String sourceBuild;
    final String sourceVersion;

    public ExplorerSearch() {
        this.sourceLanguage = this.winpe.coreSource.defaultLanguage;
        this.sourceBuild = this.winpe.coreSource.build + "." + this.winpe.coreSource.spbuild;
        this.sourceVersion = this.winpe.coreSource.major + "." + this.winpe.coreSource.minor + "." + this.winpe.coreSource.build + "." + this.winpe.coreSource.spbuild;
        this.setName("ExplorerSearch");
    }

    @Override
    public boolean pluginCode() {
        if (!this.componentList.containsKey("ExplorerSearch")) {
            this.logit();
            this.sourceWIM.createFolderWIM(this.winpe.targetWimFolder, "ProgramData\\Microsoft\\Search\\Data\\Applications\\Windows");
            this.sourceWIM.install.extractMui("Windows\\System32\\mssrch.dll");
            this.sourceWIM.install.extractMui("Windows\\System32\\srchadmin.dll");
            this.sourceWIM.install.extractMui("Windows\\System32\\SearchIndexer.exe");
            this.sourceWIM.install.extractMui("Windows\\System32\\SearchFolder.dll");
            this.sourceWIM.install.extractMui("Windows\\System32\\ELScore.dll");
            this.sourceWIM.install.extractMui("Windows\\System32\\tquery.dll");
            this.importResource(this.hive.systemHive, "wsearch.reg");
            this.importResource(this.hive.defaultHive, "usearch.reg");
            this.importResource(this.hive.softwareHive, "search.reg");
            this.hive.softwareHive.modifyValueMulti("Microsoft\\Windows NT\\CurrentVersion\\Svchost", "LocalService", "WSearch", -1);
            this.hive.softwareHive.createValue("Microsoft\\Windows Search", "CurrentVersion", 1, this.sourceVersion);
            String[] list = new String[]{"net start eventsystem", "net start sens", "net start wsearch"};
            this.peLibrary.unZipResource("ExplorerSearch/StartExplorerSearch.zip", this.winpe.targetWinSysFolder);
            this.peLibrary.addDesktopShortcut("ExplorerSearch", "StartExplorerSearch.cmd", "StartExplorerSearch", "StartExplorerSearch.lnk", list);
            this.peLibrary.addPlugin("EventSystem");
            this.componentList.put("ExplorerSearch", this);
        }
        return true;
    }
}

