/*
 * Decompiled with CFR 0.152.
 */
package win7pecore.components;

import bsh2java.log;
import build.Core;
import downloads.common;
import java.io.File;
import utils.Settings;
import utils.files;
import win7pecore.corebuild.PluginTemplate;

public class DriverPacks
extends PluginTemplate {
    final String pluginName = "DriverPacks";

    public DriverPacks() {
        this.setName("DriverPacks");
    }

    @Override
    public boolean pluginCode() {
        if (!this.componentList.containsKey("DriverPacks")) {
            this.logit();
            boolean copied = false;
            File pluginFolder = this.winpe.coreFolder;
            File packsSourceFolder = common.getFolderDriverPacks();
            File driversFolder = this.peLibrary.getDriversFolder();
            String sep = Core.sys.settings.read("FileSeparator");
            File settingsFile = new File(pluginFolder, "DriverPacks.extra.xml");
            Settings driverSettings = new Settings(settingsFile, "Settings for DriverPacks");
            int countPacks = Integer.parseInt(driverSettings.read("Packs", "0"));
            String tempDir = System.getProperty("java.io.tmpdir");
            File tempFolder = new File(tempDir, "driverpack");
            for (int p = 1; p <= countPacks; ++p) {
                String thePack = "Pack" + String.valueOf(p);
                String theURL = thePack + "URL";
                String url = driverSettings.read(theURL);
                String pack = this.peLibrary.downloadTorrent(url, packsSourceFolder);
                File sourcePack = new File(packsSourceFolder, pack);
                if (!sourcePack.exists()) continue;
                driverSettings.write(thePack, sourcePack.getName());
                File tempExtract = new File(tempFolder, pack);
                files.mkdirs(tempExtract);
                int countEntries = Integer.parseInt(driverSettings.read(thePack + "Entries", "0"));
                for (int e = 1; e <= countEntries; ++e) {
                    String entDone;
                    String isDone;
                    String theEntry = thePack + "Entry" + String.valueOf(e);
                    String entry = driverSettings.read(theEntry, "");
                    if (entry.equals("") || "True".equalsIgnoreCase(isDone = driverSettings.read(entDone = thePack + "Done" + String.valueOf(e)))) continue;
                    String theName = thePack + "Name" + String.valueOf(e);
                    String name = driverSettings.read(theName, "$Default");
                    if (name.equalsIgnoreCase("$Default")) {
                        name = entry;
                    }
                    String theAction = thePack + "Action" + String.valueOf(e);
                    String action = driverSettings.read(theAction, "BootInstall");
                    String osEntry = entry.replace("\\", sep);
                    String[] driverNames = this.winpe.zipExtractInfDir(sourcePack, entry, new File(tempExtract, theEntry));
                    if (driverNames != null) {
                        if (driverNames.length == 1) {
                            name = driverNames[0];
                        }
                        File infFolder = new File(driversFolder, name);
                        File tmpDriverDir = new File(new File(tempExtract, theEntry), osEntry);
                        files.mkdirs(infFolder);
                        files.copyFolder(tmpDriverDir, infFolder);
                        copied = true;
                        for (String driverName : driverNames) {
                            log.write(507, driverName);
                            if (!action.equalsIgnoreCase("BootInstall")) continue;
                            files.touch(infFolder, driverName + ".inf.install");
                        }
                    }
                    driverSettings.write(entDone, "True");
                }
            }
            if (copied) {
                this.winpe.projectSettings.write("CustomDrivers", "True");
                this.peLibrary.addPlugin("CustomDrivers");
            }
            this.winpe.projectSettings.write("DriverPacks", "False");
            this.componentList.put("DriverPacks", this);
        }
        return true;
    }
}

