/*
 * Decompiled with CFR 0.152.
 */
package win7pecore.components;

import build.Core;
import downloads.common;
import java.io.File;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import utils.files;
import win7pecore.corebuild.PluginTemplate;

public class CustomDrivers
extends PluginTemplate {
    final String pluginName = "CustomDrivers";

    public CustomDrivers() {
        this.setName("CustomDrivers");
    }

    @Override
    public boolean pluginCode() {
        if (!this.componentList.containsKey("CustomDrivers")) {
            this.logit();
            String sep = Core.sys.settings.read("FileSeparator");
            File sourceDriversFolder = this.peLibrary.getDriversFolder();
            if (sourceDriversFolder.exists()) {
                File[] sourceDriverFolders;
                File targetDriversFolder = new File(this.winpe.targetWimFolder, common.getFolderDrivers().getName());
                for (File driverFolder : sourceDriverFolders = sourceDriversFolder.listFiles()) {
                    File[] infFiles;
                    String driverName = driverFolder.getName();
                    File infFolder = new File(targetDriversFolder, driverName);
                    files.mkdirs(infFolder);
                    files.copyFolder(driverFolder, infFolder);
                    File peDriversFolder = new File(infFolder.getAbsolutePath().replace(targetDriversFolder.getAbsolutePath(), "X:\\drivers"));
                    if (new File(infFolder, driverName + ".inf").exists()) {
                        File inst = new File(driverFolder, driverName + ".inf.install");
                        String inf = peDriversFolder.getPath().replace(sep, "\\") + "\\" + driverName + ".inf";
                        if (!inst.exists()) continue;
                        this.winpe.addDriverLoad(inf);
                        continue;
                    }
                    String[] wildCards = new String[]{"*.inf"};
                    WildcardFileFilter fileFilter = new WildcardFileFilter(wildCards);
                    for (File infFile : infFiles = infFolder.listFiles(fileFilter)) {
                        String name = infFile.getName();
                        File inst = new File(infFile.getAbsolutePath() + ".install");
                        if ("nodev.inf".equalsIgnoreCase(name)) continue;
                        String inf = peDriversFolder.getPath().replace(sep, "\\") + "\\" + name;
                        if (!inst.exists()) continue;
                        this.winpe.addDriverLoad(inf);
                    }
                }
            }
            this.componentList.put("CustomDrivers", this);
        }
        return true;
    }
}

