/*
 * Decompiled with CFR 0.152.
 */
package win7pecore.components;

import bsh2java.log;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import utils.ImageConvert;
import utils.files;
import win7pecore.corebuild.PluginTemplate;

public class BrandPE
extends PluginTemplate {
    final String pluginName = "BrandPE";

    public BrandPE() {
        this.setName("BrandPE");
    }

    void writeLogo(String logoName, File wallPaper, Color color, String[] lines) {
        File temp = this.winpe.winPeLibrary.copyResourceToTempFile("BrandPE/" + logoName);
        if (temp != null) {
            File logo = new File(this.winpe.coreRegistration.getBaseDir(), logoName);
            files.copyFile(temp, logo);
            temp.delete();
            ImageConvert.writeText(wallPaper, lines, color, logo);
            logo.delete();
        }
    }

    @Override
    public boolean pluginCode() {
        boolean result = true;
        if (!this.componentList.containsKey("BrandPE")) {
            Color color;
            File wallPaper = new File(this.winpe.targetWinSysFolder, "winpe.bmp");
            if (!wallPaper.exists()) {
                ImageConvert.createColourBitMap(wallPaper, 1280, 1024, 0, 0, 255);
                color = Color.WHITE;
                result = false;
            } else {
                try {
                    color = this.suggestColor(wallPaper);
                }
                catch (IOException ex) {
                    Logger.getLogger(BrandPE.class.getName()).log(Level.SEVERE, null, ex);
                    return false;
                }
            }
            ArrayList<String> list = new ArrayList<String>();
            String info = this.winpe.coreRegistration.getRegistrationInfo();
            if (info != null) {
                list.add(info);
            }
            String theDate = this.winpe.peDateString(new Date(), 1);
            list.add("Created at " + theDate);
            String theSource = this.winpe.coreSource.getDetails();
            list.add("WinPE based on " + theSource);
            String[] lines = new String[list.size()];
            list.toArray(lines);
            File logo = new File(this.winpe.coreRegistration.getBaseDir(), this.winpe.coreRegistration.getOwner() + ".bmp");
            if (logo.exists()) {
                boolean ok = this.winpe.coreRegistration.checkLogo(logo);
                if (!ok) {
                    String message = this.winpe.coreRegistration.getMessage();
                    log.write(-1, message);
                    list.add(0, "Original distributed by " + this.winpe.coreRegistration.getOwner());
                    lines = new String[list.size()];
                    list.toArray(lines);
                    this.writeLogo("hack.bmp", wallPaper, color, lines);
                } else {
                    ImageConvert.writeText(wallPaper, lines, color, logo);
                }
            } else if (this.winpe.coreRegistration.isRegistered()) {
                this.writeLogo("reboot.bmp", wallPaper, color, lines);
            } else {
                this.writeLogo("nonreg.bmp", wallPaper, color, lines);
            }
            this.componentList.put("BrandPE", this);
        }
        return result;
    }

    public Color suggestColor(File picture) throws IOException {
        String[] wildCards = new String[]{"WallPaper.jpg", "WallPaper.bmp", "WallPaper.gif"};
        WildcardFileFilter fileFilter = new WildcardFileFilter(wildCards);
        File[] files2 = this.winpe.coreFolder.listFiles(fileFilter);
        if (files2.length > 0) {
            double avg;
            int red = 0;
            int green = 0;
            int blue = 0;
            BufferedImage img = ImageIO.read(picture);
            int width = img.getWidth();
            int height = img.getHeight();
            int startX = width / 2;
            int startY = height / 6;
            int count = 0;
            for (int x = startX; x < width; ++x) {
                for (int y = startY; y < height; ++y) {
                    int rgb = img.getRGB(x, y);
                    Color c = new Color(rgb);
                    red += c.getRed();
                    green += c.getGreen();
                    blue += c.getBlue();
                    ++count;
                }
            }
            if ((avg = Math.sqrt((red /= count) * red + (green /= count) * green + (blue /= count) * blue)) < 200.0) {
                return Color.WHITE;
            }
            if (avg > 240.0) {
                return Color.BLACK;
            }
            int index = 0;
            if (green < red) {
                index = 1;
                if (blue < green) {
                    index = 2;
                }
            } else if (blue < red) {
                index = 2;
            }
            int[] values = new int[3];
            values[index] = 255;
            return new Color(values[0], values[1], values[2]);
        }
        return Color.BLACK;
    }
}

