/*
 * Decompiled with CFR 0.152.
 */
package win7pecore;

import bsh2java.log;
import build.Core;
import downloads.common;
import inifiles.IniFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.sevenzipjbinding.ArchiveFormat;
import org.apache.commons.io.FileUtils;
import reg.HivePatcher;
import reg.RegHeader;
import reg.RegKey;
import reg.RegVal;
import rewim.WimExtractorEx;
import utils.ExtractSevenZip;
import utils.Settings;
import utils.Torrent;
import utils.files;
import utils.internet;
import win7pecore.CustomShortcut;
import win7pecore.Plugins;
import win7pecore.Shortcuts;
import win7pecore.Win7PE;

public class WinPeLibrary {
    Win7PE winpe;
    private boolean isPatched = false;

    public WinPeLibrary(Win7PE theCore) {
        this.winpe = theCore;
    }

    public WinPeLibrary() {
    }

    public File copyResourceToTempFile(String resourceName) {
        File tempFile = null;
        try {
            tempFile = this.copyResourceToTempFileInternal(resourceName);
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(WinPeLibrary.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(WinPeLibrary.class.getName()).log(Level.SEVERE, null, ex);
        }
        System.gc();
        return tempFile;
    }

    private File copyResourceToTempFileInternal(String resourceName) throws URISyntaxException, FileNotFoundException, IOException {
        String resString = "/resources/" + resourceName;
        URL url = this.getClass().getResource(resString);
        if (url == null) {
            return null;
        }
        InputStream inStream = this.getClass().getResourceAsStream(resString);
        String tempDir = System.getProperty("java.io.tmpdir");
        File outFile = new File(tempDir, resourceName.replace("/", "."));
        FileOutputStream outStream = new FileOutputStream(outFile);
        int read = 0;
        byte[] bytes = new byte[1024];
        while ((read = inStream.read(bytes)) != -1) {
            outStream.write(bytes, 0, read);
        }
        inStream.close();
        inStream = null;
        outStream.close();
        outStream = null;
        return outFile;
    }

    public boolean unZipResource(String zipName, File targetDir) {
        try {
            File ressourceFile = this.copyResourceToTempFile(zipName);
            if (ressourceFile == null) {
                return false;
            }
            this.zipExtractAll(ressourceFile, targetDir);
            return true;
        }
        catch (Exception ex) {
            Logger.getLogger(WinPeLibrary.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    public void sp0Patch() {
        this.winpe.sourceWIM.install.set7zip(true);
        this.winpe.sourceWIM.boot.set7zip(true);
        this.checkSp0(this.winpe.sourceWIM.install, "Windows\\System32\\ie4uinit.exe");
        this.checkSp0(this.winpe.sourceWIM.install, "Windows\\System32\\sysmon.ocx");
        this.checkSp0(this.winpe.sourceWIM.install, "Windows\\System32\\msvbvm60.dll");
        this.checkSp0(this.winpe.sourceWIM.boot, "Windows\\System32\\iertutil.dll");
        this.checkSp0(this.winpe.sourceWIM.boot, "Windows\\System32\\shell32.dll");
        this.winpe.sourceWIM.install.set7zip(false);
        this.winpe.sourceWIM.boot.set7zip(false);
    }

    public void checkSp0(WimExtractorEx extractor, String fileName) {
        String osName = fileName.replace("\\\\", Core.sys.settings.read("FileSeparator"));
        File targetFile = new File(this.winpe.targetWimFolder, osName);
        if (targetFile.exists()) {
            extractor.extractFile(fileName);
        }
    }

    public boolean getOptionBool(Settings control, String entry) {
        return "True".equalsIgnoreCase(control.read(entry));
    }

    public String getOptionString(Settings control, String key) {
        return control.read(key, "");
    }

    public void importReg(RegHeader hive, String component, String regName) {
        File regFile = this.copyResourceToTempFile(component + "/" + regName);
        if (regFile != null) {
            hive.importReg(regFile.getAbsolutePath());
        }
    }

    public boolean download(Settings pluginSettings, File pluginFolder) {
        boolean useLocal = !this.getOptionBool(pluginSettings, "IsAttached");
        File localPluginDir = common.getFolderPlugins();
        boolean doProcess = true;
        Core.temp.put("downloadResult", true);
        if (useLocal) {
            String name = this.getOptionString(pluginSettings, "!Name");
            String localDir = this.getOptionString(pluginSettings, "LocalFolder");
            String subDir = this.getOptionString(pluginSettings, "!Category");
            if (!localDir.equals("")) {
                File localFolder;
                if (localDir.equalsIgnoreCase("$Default")) {
                    localFolder = new File(localPluginDir, subDir);
                    localFolder = new File(localFolder, name);
                } else {
                    localFolder = new File(localDir);
                }
                String URL2 = this.getOptionString(pluginSettings, "DownloadURL");
                if (!URL2.equals("") && !this.checkDownload(pluginSettings, URL2, localFolder)) {
                    return doProcess;
                }
            }
        }
        return doProcess;
    }

    String specialURL(String URL2, Settings pluginSettings) {
        String key;
        String repl;
        int ends;
        String result = URL2;
        int starts = URL2.indexOf("~");
        if (starts >= 0 && (ends = URL2.indexOf("~", starts + 1)) > starts && !(repl = this.getOptionString(pluginSettings, key = URL2.substring(starts, ends + 1))).equals("")) {
            result = URL2.replace(key, repl);
        }
        return result;
    }

    private boolean checkDownload(Settings pluginSettings, String URL2, File localFolder) {
        boolean doDownload;
        boolean result = true;
        boolean createTag = true;
        boolean forceDownload = this.getOptionBool(pluginSettings, "ForceDownload");
        URL2 = this.specialURL(URL2, pluginSettings);
        File tagFile = new File(localFolder, "core");
        File tempFolder = common.getFolderDownloadedPlugins();
        if (!tempFolder.exists()) {
            tempFolder.mkdirs();
        }
        int starts = URL2.lastIndexOf("/");
        String nam = URL2.substring(starts + 1);
        File tempFile = new File(tempFolder, nam);
        boolean bl = doDownload = !localFolder.exists() || this.getOptionBool(pluginSettings, "DoDownload") || forceDownload;
        if (doDownload) {
            if (localFolder.exists()) {
                files.deleteDir(localFolder);
            }
            if (!tempFile.exists() || forceDownload) {
                log.write(30, "Downloading %1 to %2", URL2, tempFile.getAbsolutePath());
                internet.downloadFile(URL2, tempFile);
                Core.temp.put("theDownloaded", tempFile);
            }
            if (tagFile.exists()) {
                tagFile.delete();
            }
        }
        if (!tempFile.exists()) {
            Core.temp.put("downloadResult", false);
            return false;
        }
        Core.temp.put("downloadResult", true);
        pluginSettings.write("DoDownload", "False");
        if (!tagFile.exists()) {
            String strExtract = pluginSettings.read("DoExtract", "");
            if (strExtract.equals("$Default")) {
                String tempName = tempFile.getName();
                if (tempName.endsWith(".paf.exe")) {
                    strExtract = "True";
                } else if (tempName.endsWith(".zip")) {
                    strExtract = "True";
                } else if (tempName.endsWith(".7z")) {
                    strExtract = "True";
                } else if (tempName.endsWith(".exe")) {
                    strExtract = "False";
                }
            }
            boolean doExtract = strExtract.equalsIgnoreCase("True");
            files.waitForReady(tempFile);
            if (tempFile.getName().endsWith(".paf.exe")) {
                if (doExtract) {
                    this.pafExtract(tempFile, localFolder);
                } else {
                    createTag = false;
                }
            } else {
                File targetFolder;
                File pluginsFolder = localFolder.getParentFile();
                String subFolder = pluginSettings.read("ZipSubFolder", "");
                if (!"".equals(subFolder)) {
                    subFolder = new File(pluginsFolder, this.specialURL(subFolder, pluginSettings)).getName();
                    targetFolder = new File(tempFolder, subFolder);
                } else {
                    targetFolder = localFolder;
                }
                if (!doExtract) {
                    log.write(30, "Copying %1 to %2", tempFile.getAbsolutePath(), localFolder.getAbsolutePath());
                    try {
                        FileUtils.copyFileToDirectory(tempFile, localFolder);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(WinPeLibrary.class.getName()).log(Level.SEVERE, null, ex);
                    }
                } else {
                    log.write(30, "Unzipping %1 to %2", tempFile.getAbsolutePath(), localFolder.getAbsolutePath());
                    try {
                        this.zipExtractAll(tempFile, targetFolder);
                        if (!"".equals(subFolder)) {
                            FileUtils.moveDirectory(new File(targetFolder, subFolder), localFolder);
                            targetFolder.delete();
                        }
                        result = true;
                    }
                    catch (Exception ex) {
                        Logger.getLogger(WinPeLibrary.class.getName()).log(Level.SEVERE, null, ex);
                        result = false;
                    }
                }
            }
            if (result & createTag) {
                try {
                    tagFile.createNewFile();
                }
                catch (IOException ex) {
                    Logger.getLogger(WinPeLibrary.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return result;
    }

    public boolean zipExtractAll(File archiveFile, File destinationFolder) throws ExtractSevenZip.ExtractionException, IOException {
        if (!destinationFolder.exists()) {
            destinationFolder.mkdirs();
        }
        ExtractSevenZip extractor = new ExtractSevenZip(archiveFile, destinationFolder, null);
        extractor.extract();
        return true;
    }

    public boolean zipExtractDir(File archiveFile, String singleDirName, File destinationFolder) throws ExtractSevenZip.ExtractionException, IOException {
        if (!destinationFolder.exists()) {
            destinationFolder.mkdirs();
        }
        ExtractSevenZip extractor = new ExtractSevenZip(archiveFile, destinationFolder, null);
        extractor.setDir(singleDirName);
        extractor.extract();
        return true;
    }

    public boolean zipExtractFile(File archiveFile, String singleFileName, File destinationFolder) throws ExtractSevenZip.ExtractionException, IOException {
        if (!destinationFolder.exists()) {
            destinationFolder.mkdirs();
        }
        ExtractSevenZip extractor = new ExtractSevenZip(archiveFile, destinationFolder, null);
        extractor.extract(singleFileName);
        return true;
    }

    public boolean zipExtractFile(File archiveFile, String singleFileName, String password, File destinationFolder) throws ExtractSevenZip.ExtractionException, IOException {
        if (!destinationFolder.exists()) {
            destinationFolder.mkdirs();
        }
        ExtractSevenZip extractor = new ExtractSevenZip(archiveFile, destinationFolder, null);
        extractor.extract(singleFileName, password);
        return true;
    }

    public boolean pafExtract(File archiveFile, File destinationFolder) {
        String App = "App";
        String $PLUGINSDIR = "$PLUGINSDIR";
        String $_OUTDIR = "$_OUTDIR";
        String $R0 = "$R0";
        String appInfo = "AppInfo";
        String other = "Other";
        String help = "Help";
        String source = "Source";
        String defaultData = "DefaultData";
        if (destinationFolder.exists()) {
            files.deleteDir(destinationFolder);
        }
        destinationFolder.mkdirs();
        log.write(30, "Extracting %1 to %2", archiveFile.getAbsolutePath(), destinationFolder.getAbsolutePath());
        File tempFolder = new File(common.getFolderDownloadedPlugins(), "p_" + destinationFolder.getName());
        if (tempFolder.exists()) {
            files.deleteDir(tempFolder);
        }
        tempFolder.mkdirs();
        ExtractSevenZip extractor = new ExtractSevenZip(archiveFile, tempFolder, null);
        try {
            files.waitForReady(archiveFile);
            extractor.setArchiveFormat(ArchiveFormat.NSIS);
            extractor.extract();
            File plug = new File(tempFolder, "$PLUGINSDIR");
            files.deleteDir(plug);
            plug = new File(tempFolder, "App");
            WinPeLibrary.moveDirectoryContents(plug, destinationFolder);
            File appDir = new File(destinationFolder, "App");
            File rDir = new File(tempFolder, "$R0");
            if (rDir.exists()) {
                WinPeLibrary.moveDirectoryContents(rDir, destinationFolder);
            }
            File outDir = new File(tempFolder, "$_OUTDIR");
            plug = new File(outDir, "AppInfo");
            WinPeLibrary.moveDirectoryContents(plug, new File(appDir, "AppInfo"));
            plug = new File(outDir, "DefaultData");
            WinPeLibrary.moveDirectoryContents(plug, appDir);
            File otherDir = new File(destinationFolder, "Other");
            plug = new File(outDir, "Help");
            WinPeLibrary.moveDirectoryContents(plug, otherDir);
            plug = new File(outDir, "Source");
            WinPeLibrary.moveDirectoryContents(plug, otherDir);
            WinPeLibrary.moveDirectoryContents(outDir, appDir);
            plug = new File(tempFolder, "Other");
            WinPeLibrary.moveDirectoryContents(plug, new File(otherDir, "Source"));
            WinPeLibrary.moveDirectoryContents(tempFolder, destinationFolder);
            return true;
        }
        catch (Exception ex) {
            Logger.getLogger(WinPeLibrary.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    public boolean exeExtract(File archiveFile, File destinationFolder) {
        File contentFolder;
        if (destinationFolder.exists()) {
            files.deleteDir(destinationFolder);
        }
        destinationFolder.mkdirs();
        log.write(30, "Extracting %1 to %2", archiveFile.getAbsolutePath(), destinationFolder.getAbsolutePath());
        File tempFolder = new File(common.getFolderDownloadedPlugins(), "redist");
        if (tempFolder.exists()) {
            files.deleteDir(tempFolder);
        }
        tempFolder.mkdirs();
        ExtractSevenZip extractor = new ExtractSevenZip(archiveFile, tempFolder, null);
        try {
            extractor.setArchiveFormat(ArchiveFormat.CAB);
            extractor.extract();
            File plug = new File(tempFolder, "vc_red.cab");
            contentFolder = new File(common.getFolderDownloadedPlugins(), "content");
            if (contentFolder.exists()) {
                files.deleteDir(contentFolder);
            }
            tempFolder.mkdirs();
            extractor = new ExtractSevenZip(plug, contentFolder, null);
            extractor.setArchiveFormat(ArchiveFormat.CAB);
            extractor.extract();
        }
        catch (Exception ex) {
            Logger.getLogger(WinPeLibrary.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
        try {
            files.deleteDir(tempFolder);
            this.moveDll(contentFolder, destinationFolder);
        }
        catch (IOException ex) {
            Logger.getLogger(WinPeLibrary.class.getName()).log(Level.SEVERE, null, ex);
        }
        return true;
    }

    private String dllName(String archiveName) {
        String inp = archiveName;
        if (!inp.startsWith("F_")) {
            return null;
        }
        inp = inp.replace("F_CENTRAL_", "");
        return inp.replace("_x86", ".dll");
    }

    private void moveDll(File src, File trg) throws IOException {
        if (src.exists()) {
            File[] files2 = src.listFiles();
            if (!trg.exists()) {
                trg.mkdirs();
            }
            for (File file : files2) {
                File trgFile;
                String dll = this.dllName(file.getName());
                if (dll == null || (trgFile = new File(trg, dll)).exists()) continue;
                file.renameTo(trgFile);
            }
            files.deleteDir(src);
        }
    }

    private static void moveDirectoryContents(File src, File trg) {
        if (src.exists()) {
            File[] files2 = src.listFiles();
            if (!trg.exists()) {
                trg.mkdirs();
            }
            for (File file : files2) {
                if (file.isDirectory()) {
                    WinPeLibrary.moveDirectoryContents(file, new File(trg, file.getName()));
                    continue;
                }
                File trgFile = new File(trg, file.getName());
                if (trgFile.exists()) continue;
                files.waitForReady(file);
                try {
                    FileUtils.moveFileToDirectory(file, trg, true);
                }
                catch (IOException ex) {
                    Logger.getLogger(WinPeLibrary.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            files.deleteDir(src);
        }
    }

    public boolean addPlugin(String theName) {
        boolean isOk = true;
        if (!this.winpe.componentList.containsKey(theName)) {
            Plugins save = this.winpe.pluginLib;
            this.winpe.pluginLib = new Plugins(theName);
            isOk = this.winpe.pluginLib.checkPlugin(theName);
            this.winpe.pluginLib = save;
        }
        return isOk;
    }

    public boolean addCache(String theName) {
        this.winpe.pluginLib = new Plugins(theName);
        boolean isOk = this.winpe.pluginLib.checkPlugin(theName);
        File cf = new File(this.winpe.sourceFilesFolder, theName);
        files.mkdirs(cf);
        File target = new File(cf, this.winpe.targetWinFolder.getName());
        this.winpe.targetWinFolder.renameTo(target);
        this.winpe.sourceWIM.createSkeleton();
        return isOk;
    }

    public String getFetchHive(String hive, boolean isInstall) {
        File fetchDir = isInstall ? new File(this.winpe.sourceHivesFolder, "install") : new File(this.winpe.sourceHivesFolder, "boot");
        File theHive = new File(fetchDir, hive);
        return theHive.getAbsolutePath();
    }

    public File getDriversFolder() {
        File sourceDriversFolder0 = common.getFolderDrivers();
        File sourceDriversFolder1 = null;
        File sourceDriversFolder = null;
        sourceDriversFolder1 = Core.sys.source.arch.equals("0") ? new File(sourceDriversFolder0, "x86") : new File(sourceDriversFolder0, "x64");
        String version = Core.sys.source.major + "." + Core.sys.source.minor;
        if (version.equals("6.1")) {
            sourceDriversFolder = new File(sourceDriversFolder1, "win7");
        } else if (version.equals("6.2")) {
            sourceDriversFolder = new File(sourceDriversFolder1, "win8");
        } else if (version.equals("6.3")) {
            sourceDriversFolder = new File(sourceDriversFolder1, "win8.1");
        }
        return sourceDriversFolder;
    }

    public void appendTextLine(File textFile, String line) {
        IniFile txt = new IniFile(textFile);
        txt.lineInsert(-1, line);
        try {
            txt.closeFile();
        }
        catch (IOException ex) {
            Logger.getLogger(Shortcuts.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void transferSettings(String components) {
        if (components != null) {
            String[] plugs;
            for (String plug : plugs = components.split("\\|")) {
                File resDriverFile;
                File actDriverFile;
                File resIniFile;
                File actIniFile;
                File actFormularFile;
                File resSettingsFile = null;
                File actSettingsFile = new File(this.winpe.coreFolder, plug + ".xml");
                if (!actSettingsFile.exists() && (resSettingsFile = this.copyResourceToTempFile(plug + "/settings.xml")) != null) {
                    files.copyFile(resSettingsFile, actSettingsFile);
                    resSettingsFile.delete();
                    Settings settings = new Settings(actSettingsFile, "Settings for core " + plug);
                    settings.write("!Name", plug);
                }
                if (!(actFormularFile = new File(this.winpe.coreFolder, plug + ".html")).exists()) {
                    File resFormularFile = this.copyResourceToTempFile(plug + "/settings.html");
                    files.copyFile(resFormularFile, actFormularFile);
                    resFormularFile.delete();
                }
                if (!(actIniFile = new File(this.winpe.coreFolder, plug + ".ini")).exists() && (resIniFile = this.copyResourceToTempFile(plug + "/" + plug + ".ini")) != null) {
                    files.copyFile(resIniFile, actIniFile);
                    resIniFile.delete();
                }
                if ((actDriverFile = new File(this.winpe.coreFolder, plug + ".extra.xml")).exists() || (resDriverFile = this.copyResourceToTempFile(plug + "/extra.xml")) == null) continue;
                files.copyFile(resDriverFile, actDriverFile);
                resDriverFile.delete();
            }
        }
    }

    public void addDesktopShortcut(String plugin, String exe, String comment, String link, String[] commands) {
        CustomShortcut cs = (CustomShortcut)Core.temp.get("Shortcuts");
        cs.add(plugin, exe, comment, link);
        if (commands != null) {
            cs.write(commands);
        }
    }

    public String peDateString(Date date, int format) {
        String[] locStr = this.winpe.coreSource.defaultLanguage.split("-");
        Locale loc = new Locale(locStr[0], locStr[1]);
        DateFormat df = DateFormat.getDateInstance(format, loc);
        return df.format(date);
    }

    public void fetchKeyTranslate(RegHeader sourceHive, RegHeader targetHive, String theKey, String from, String to) {
        RegKey actKey = sourceHive.readKey(theKey);
        File tmp = new File(actKey.getKeyName() + ".reg");
        actKey.regExport(tmp);
        this.textReplace(tmp, from, to);
        targetHive.importReg(tmp.getAbsolutePath());
        tmp.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void textReplace(File candidate, String from, String to) {
        String line;
        ArrayList<String> lines = new ArrayList<String>();
        String format = "UTF-16LE";
        BufferedReader buffReader = null;
        try {
            buffReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(candidate), "UTF-16LE"));
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(WinPeLibrary.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(WinPeLibrary.class.getName()).log(Level.SEVERE, null, ex);
        }
        while (true) {
            try {
                while ((line = buffReader.readLine()) != null) {
                    lines.add(line);
                }
            }
            catch (IOException ex) {
                Logger.getLogger(WinPeLibrary.class.getName()).log(Level.SEVERE, null, ex);
                continue;
            }
            break;
        }
        try {
            buffReader.close();
        }
        catch (IOException ex) {
            Logger.getLogger(WinPeLibrary.class.getName()).log(Level.SEVERE, null, ex);
        }
        boolean resave = false;
        for (int i = 0; i < lines.size(); ++i) {
            line = (String)lines.get(i);
            boolean changed = false;
            while (line.contains(from)) {
                line = line.replace(from, to);
                changed = true;
            }
            if (!changed) continue;
            lines.set(i, line);
            resave = true;
        }
        if (resave) {
            OutputStreamWriter writer = null;
            try {
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(candidate), "UTF-16LE");
                for (String str : lines) {
                    writer.write(str + "\r\n");
                }
            }
            catch (UnsupportedEncodingException ex) {
                Logger.getLogger(WinPeLibrary.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(WinPeLibrary.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(WinPeLibrary.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(WinPeLibrary.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
    }

    public void patchLetter(RegHeader hive, String key) {
        HivePatcher patcher = new HivePatcher(hive);
        patcher.patchLetter(key);
    }

    public void fetchClassKey(RegHeader head, String key) {
        String keyPath = "Classes\\" + key;
        head.fetchKey(keyPath);
        RegKey theKey = head.readKey(keyPath);
        RegVal theStandard = theKey.getVal("");
        if (theStandard != null) {
            RegKey theClass;
            keyPath = "Classes\\" + theStandard.toString();
            head.fetchKey(keyPath);
            theKey = head.readKey(keyPath);
            if (theKey != null) {
                this.patchLetter(head, keyPath);
            }
            if ((theClass = head.readKey(keyPath = keyPath + "\\CLSID")) != null) {
                theStandard = theClass.getVal("");
                keyPath = "Classes\\CLSID\\" + theStandard.toString();
                head.fetchKey(keyPath);
                theKey = head.readKey(keyPath);
                if (theKey != null) {
                    this.patchLetter(head, keyPath);
                }
            }
        }
    }

    public String downloadTorrent(String url, File outputDir) {
        File pack = null;
        try {
            Torrent x;
            File torrentDir = new File(outputDir, "torrents");
            if (!torrentDir.exists()) {
                files.mkdirs(torrentDir);
            }
            if (!outputDir.exists()) {
                files.mkdirs(outputDir);
            }
            if (!(pack = (x = new Torrent(url, torrentDir, outputDir)).getPack()).exists()) {
                log.write(30, "Downloading %1. Please be patient ...", pack.getName());
                x.download();
            } else {
                log.write(30, "Using already downloaded %1", pack.getName());
            }
        }
        catch (Exception ex) {
            Logger.getLogger(Torrent.class.getName()).log(Level.SEVERE, null, ex);
        }
        return pack.getName();
    }

    public String downloadTorrent(File torrent, File outputDir) {
        File pack = null;
        try {
            Torrent x;
            if (!outputDir.exists()) {
                files.mkdirs(outputDir);
            }
            if ((pack = (x = new Torrent(torrent, outputDir)).getPack()).exists()) {
                pack.delete();
            }
            log.write(30, "Downloading %1. Please be patient ...", pack.getName());
            x.download();
        }
        catch (Exception ex) {
            Logger.getLogger(Torrent.class.getName()).log(Level.SEVERE, null, ex);
        }
        return pack.getName();
    }
}

