/*
 * Decompiled with CFR 0.152.
 */
package win7pecore;

import bsh2java.log;
import build.Builder;
import build.Core;
import build.Source;
import definitions.messages;
import downloads.common;
import inifiles.IniFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import licenses.RegistrationLib;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import reg.RegHeader;
import reg.RegKey;
import reg.RegKeyList;
import reg.RegVal;
import relink.MSlink;
import utils.ArtASCII;
import utils.BackDelete;
import utils.ExtractSevenZip;
import utils.Settings;
import utils.files;
import win7pecore.ArchiveWIM;
import win7pecore.CustomShortcut;
import win7pecore.Hives;
import win7pecore.IsoHandler;
import win7pecore.Plugins;
import win7pecore.Update;
import win7pecore.WinPeLibrary;

public class Win7PE {
    public Plugins pluginLib = null;
    static final String resString = "/resources/";
    public Source coreSource = null;
    public RegistrationLib coreRegistration = null;
    public Settings projectSettings = null;
    Builder coreBuilder = null;
    public File coreFolder = null;
    public File targetWinFolder = null;
    public File targetBootFolder = null;
    public File targetWimFolder = null;
    public File targetWinSysFolder = null;
    public File componentFolder = null;
    public File sourceHivesFolder = null;
    public File sourceFilesFolder = null;
    public File autoRunFile = null;
    public String[] allComponents = null;
    public String[] allFileCollections = null;
    public WinPeLibrary winPeLibrary;
    Settings wbSettings = null;
    public boolean hasFinished = false;
    boolean isWin7PE;
    public HashMap coreTemp = Core.temp;
    HashMap startShell;
    HashMap componentList;
    HashMap drivers;
    public ArchiveWIM sourceWIM;
    public Hives hive;
    public boolean doBeep = false;
    public String projectName = null;
    public CustomShortcut peShortcut = null;
    Win7PE winpe = this;
    final String components = "AudioSupport|AutoRun|EventSystem|ExplorerSearch|InternetExplorer|MMC|MSI|MSPaint|MSTSC|NetSupport|Notepad|PENetwork|RecEnv|Regedit|StickyKeys|TaskManager|VSS|WallPaper|DriverPacks|CustomDrivers";
    final String files = "AudioFiles|BrowserFonts|DOSCommands|DriverStore|EastAsianBootFonts|IEFiles|MMCFiles|MoreDrivers|NetFiles";
    final String[] validSources = new String[]{"7600", "7601"};
    final boolean test = false;
    final boolean pluginTest = false;

    public Win7PE() {
        String projectSettingsName;
        this.winPeLibrary = new WinPeLibrary(this);
        this.coreBuilder = Core.sys.build;
        this.coreSource = Core.sys.source;
        this.coreRegistration = Core.sys.registrationLib;
        this.wbSettings = Core.sys.settings;
        this.targetWimFolder = Core.sys.build.folderPeWIM;
        this.targetBootFolder = Core.sys.build.folderBase;
        this.targetWinFolder = new File(this.targetWimFolder, "Windows");
        this.targetWinSysFolder = new File(this.targetWinFolder, "System32");
        this.sourceHivesFolder = new File(common.getFolderHives(), this.coreSource.defaultLanguage + "." + this.coreSource.build + "." + this.coreSource.arch);
        this.sourceFilesFolder = new File(common.getFolderFiles(), this.coreSource.defaultLanguage + "." + this.coreSource.build + "." + this.coreSource.arch);
        this.coreFolder = common.getFolderCore().getAbsoluteFile();
        this.projectName = this.wbSettings.read("Project");
        if (this.projectName == null) {
            this.projectName = this.getClass().getSimpleName();
            this.wbSettings.write("Project", this.projectName);
        }
        if ((projectSettingsName = this.wbSettings.read("projectSettings")) == null) {
            projectSettingsName = new File(this.coreFolder, this.projectName + ".xml").getAbsolutePath();
            this.wbSettings.write("projectSettings", projectSettingsName);
        }
        this.projectSettings = new Settings(new File(projectSettingsName), "Settings for " + this.projectName);
        this.isWin7PE = this.projectName.equals(this.getClass().getSimpleName());
        Core.temp.put("ProjectSettings", this.projectSettings);
        if (!this.coreFolder.exists()) {
            utils.files.mkdirs(this.coreFolder);
        }
        if (this.isWin7PE) {
            File theDrivers;
            File actFormularFile;
            Update update = new Update(this);
            boolean done = update.action();
            File actSettingsFile = new File(this.coreFolder, this.projectName + ".xml");
            if (!actSettingsFile.exists()) {
                File resSettingsFile = this.winPeLibrary.copyResourceToTempFile(this.projectName + "/settings.xml");
                utils.files.copyFile(resSettingsFile, actSettingsFile);
                resSettingsFile.delete();
                Settings settings = new Settings(actSettingsFile, "Settings for core " + this.projectName);
                settings.write("!Name", this.projectName);
            }
            if (!(actFormularFile = new File(this.coreFolder, this.projectName + ".html")).exists()) {
                File resFormularFile = this.winPeLibrary.copyResourceToTempFile(this.projectName + "/settings.html");
                utils.files.copyFile(resFormularFile, actFormularFile);
                resFormularFile.delete();
            }
            if ((theDrivers = this.winPeLibrary.getDriversFolder()) != null && !theDrivers.exists()) {
                utils.files.mkdirs(theDrivers);
            }
        }
        this.winPeLibrary.transferSettings("AudioSupport|AutoRun|EventSystem|ExplorerSearch|InternetExplorer|MMC|MSI|MSPaint|MSTSC|NetSupport|Notepad|PENetwork|RecEnv|Regedit|StickyKeys|TaskManager|VSS|WallPaper|DriverPacks|CustomDrivers|BrandPE");
        this.winPeLibrary.transferSettings("AudioFiles|BrowserFonts|DOSCommands|DriverStore|EastAsianBootFonts|IEFiles|MMCFiles|MoreDrivers|NetFiles");
        this.allComponents = "AudioSupport|AutoRun|EventSystem|ExplorerSearch|InternetExplorer|MMC|MSI|MSPaint|MSTSC|NetSupport|Notepad|PENetwork|RecEnv|Regedit|StickyKeys|TaskManager|VSS|WallPaper|DriverPacks|CustomDrivers|BrandPE".split("\\|");
        this.allFileCollections = "AudioFiles|BrowserFonts|DOSCommands|DriverStore|EastAsianBootFonts|IEFiles|MMCFiles|MoreDrivers|NetFiles".split("\\|");
        this.hive = (Hives)Core.temp.get("hive");
        if (this.hive == null) {
            this.hive = new Hives();
            Core.temp.put("hive", this.hive);
        }
        this.sourceWIM = (ArchiveWIM)Core.temp.get("sourceWim");
        if (this.sourceWIM == null) {
            this.sourceWIM = new ArchiveWIM(this);
            Core.temp.put("sourceWim", this.sourceWIM);
        }
    }

    public void registerProject(File thisFile) {
        Plugins tmp = new Plugins(thisFile);
        File actSettingsFile = tmp.settingsFile;
        if (!actSettingsFile.exists()) {
            File resSettingsFile = new File(thisFile.getParentFile(), "settings.xml");
            utils.files.copyFile(resSettingsFile, actSettingsFile);
        }
        this.projectSettings = tmp.settings;
        this.wbSettings.write("Project", tmp.pluginName);
        this.wbSettings.write("projectSettings", actSettingsFile.getAbsolutePath());
        this.wbSettings.write("customProject", thisFile.getParentFile().getAbsolutePath());
        Core.temp.put("restart", true);
    }

    public void unRegisterProject(File thisFile) {
        Plugins tmp = new Plugins(thisFile);
        this.projectSettings = tmp.settings;
        this.wbSettings.delete("Project");
        this.wbSettings.delete("projectSettings");
        this.wbSettings.delete("customProject");
        Core.temp.put("restart", true);
    }

    private void test() {
        log.write(30, messages.Adding_plugin_Win7PEx86);
    }

    private void initLists() {
        this.componentList = (HashMap)Core.temp.get("componentList");
        if (this.componentList == null) {
            this.componentList = new HashMap();
            Core.temp.put("componentList", this.componentList);
        }
        this.startShell = (HashMap)Core.temp.get("StartShell");
        if (this.startShell == null) {
            this.startShell = new HashMap();
            Core.temp.put("StartShell", this.startShell);
        }
        this.drivers = (HashMap)Core.temp.get("Drivers");
        if (this.drivers == null) {
            this.drivers = new HashMap();
            Core.temp.put("Drivers", this.drivers);
        }
        this.peShortcut = (CustomShortcut)Core.temp.get("Shortcuts");
        if (this.peShortcut == null) {
            this.peShortcut = new CustomShortcut(this);
            Core.temp.put("Shortcuts", this.peShortcut);
        }
        Core.temp.remove("pluginSettings");
    }

    void resetLists() {
        Core.temp.remove("StartShell");
        Core.temp.remove("Drivers");
        Core.temp.remove("componentList");
        Core.temp.remove("Shortcuts");
    }

    public boolean buildWin7PECache() {
        this.initLists();
        if (this.isWin7PE) {
            if (!this.checkSource(this.validSources)) {
                log.write(-1, "This project needs a Win7 source!");
                return false;
            }
            this.backDelete();
            new BackDelete("from current cache").delete(this.winpe.sourceFilesFolder);
            this.baseISO();
            utils.files.mkdirs(this.winpe.targetWinFolder);
            this.sourceWIM.createSkeleton();
            this.sourceWIM.open();
            log.write(5, "Extract Files from source WIMs to Cache");
            this.addCache("BasicFiles");
            for (String item : this.allFileCollections) {
                this.addCache(item);
            }
        }
        this.sourceWIM.releaseSourceWims();
        this.hasFinished = true;
        this.resetLists();
        return this.hasFinished;
    }

    public boolean buildWin7PE() {
        this.initLists();
        if (this.isWin7PE) {
            if (!this.checkSource(this.validSources)) {
                log.write(-1, "This project needs a Win7 source!");
                return false;
            }
            this.peShortcut.clean();
            this.doBeep = this.wbSettings.read("BEEP", "OFF").equalsIgnoreCase("ON");
            log.printNoTTS("");
            log.printNoTTS(ArtASCII.text(this.projectName, 0, "SansSerif"));
            log.printNoTTS("reboot friends proudly present " + this.projectName);
            log.printNoTTS("");
            log.printNoTTS("Source: " + this.coreSource.getDetails());
            log.printNoTTS("");
            this.backDelete();
            this.baseISO();
            log.write(506, "Basic WIM folder structure");
            this.sourceWIM.createSkeleton();
            this.sourceWIM.open();
            this.winPeLibrary.addPlugin("BaseHive");
            this.hive.open(this);
            if (!this.hive.defaultHive.existVal("Software\\reboot.pro\\memoryflag", "ok")) {
                String message = "AssembleHive did not run successfully! Propably there is not sufficient memory.";
                message = message + "\nAssign more memory at WinBuilder start!";
                log.write(-1, message);
                this.sourceWIM.releaseSourceWims();
                this.hive.closeHives();
                this.hasFinished = false;
            } else {
                log.write(5, "Copy Components to %1", this.targetWimFolder.getAbsolutePath());
                this.addPlugin("BasicFiles");
                this.addPlugin("Localise");
                for (String item : this.allFileCollections) {
                    this.checkPlugin(item);
                }
                for (String item : this.allComponents) {
                    String doit = this.projectSettings.read(item, "False");
                    if (!doit.equalsIgnoreCase("True")) continue;
                    this.winPeLibrary.addPlugin(item);
                }
                if (this.coreRegistration.isRegistered() || !Core.sys.useRegistration) {
                    log.write(30, messages.Adding_plugin_Win7PEx86);
                }
                this.sp0Patch();
                if (this.coreRegistration.isRegistered() || !Core.sys.useRegistration) {
                    this.checkPlugin("DriverPacks");
                    this.checkPlugin("CustomDrivers");
                }
                this.winPeLibrary.addPlugin("ShutDownPE");
                this.winPeLibrary.addPlugin("StartupCode");
                this.winPeLibrary.addPlugin("Grub4DOS");
            }
            this.peShortcut.apply();
            this.sourceWIM.releaseSourceWims();
            this.hive.closeHives();
            this.hasFinished = true;
        } else {
            File script = new File(this.wbSettings.read("customProject"), "main.bsh");
            if (script.exists()) {
                this.hasFinished = Core.sys.script.run(script, "createTarget") != null;
            }
        }
        this.resetLists();
        return this.hasFinished;
    }

    public Plugins openPlugin(File thisFile) {
        this.pluginLib = new Plugins(thisFile);
        return this.pluginLib;
    }

    public void sp0Patch() {
        if (this.coreSource.build.equals("7600")) {
            this.winPeLibrary.sp0Patch();
        }
    }

    public void backDelete() {
        new BackDelete("from previous build").delete(Core.sys.build.folderTarget);
    }

    public MSlink openLink() {
        return new MSlink();
    }

    public boolean isInstalled(String pluginName) {
        return this.componentList.containsKey(pluginName);
    }

    public IniFile getCustomFile(String filePath) {
        return new IniFile(new File(filePath));
    }

    public boolean copyApp() {
        return this.pluginLib.copyApp();
    }

    public void importReg(RegHeader hive, String regName) {
        File regFile = new File(this.pluginLib.pluginFolder, regName);
        if (regFile.exists()) {
            hive.importReg(regFile.getAbsolutePath());
        }
    }

    public void baseISO() {
        IsoHandler.ISOfolders(this);
        IsoHandler.ISOfiles(this);
    }

    public boolean copyFileISO(File isoPath, File buildPath, String what) {
        File src = new File(isoPath, what);
        File trg = new File(buildPath, what);
        if (utils.files.copyFile(src, trg).booleanValue()) {
            return true;
        }
        log.write(404, "Didn't found %1 in %2", what, this.coreSource.getFolderSource().getAbsolutePath());
        return false;
    }

    public void createShortcuts() {
        this.pluginLib.createShortcuts();
        this.pluginLib.createAssocs(this.hive.softwareHive);
        this.pluginLib.doOpenWith(this.hive.softwareHive);
    }

    public void build(String what) {
        this.execute("BUILD " + what);
    }

    public void downloadApp() {
        this.pluginLib.downloadApp();
    }

    public void checkReadme() {
        this.pluginLib.checkReadme();
    }

    public String getPluginName() {
        return this.pluginLib.getPluginName();
    }

    public String getPluginProperty(String key) {
        return this.pluginLib.settings.read(key);
    }

    public void setPluginProperty(String key, String value) {
        this.pluginLib.settings.write(key, value);
    }

    public File getPluginFolder() {
        return this.pluginLib.getPluginFolder();
    }

    public String getPluginSettingsFileName() {
        return this.pluginLib.getPluginSettingsFileName();
    }

    public File getPluginPeFolder() {
        return this.pluginLib.getPluginPeExe().getParentFile();
    }

    public File getPluginSourceFolder() {
        return this.pluginLib.getPluginSourceFolder();
    }

    public File getPluginTargetFolder() {
        return this.pluginLib.getTargetFolder();
    }

    public File getDriversFolder() {
        return this.winPeLibrary.getDriversFolder();
    }

    public boolean copyFile(String srcName, String trgPath) {
        return this.pluginLib.copyFile(srcName, trgPath);
    }

    public boolean deleteFile(String trgPath) {
        return this.pluginLib.deleteFile(trgPath);
    }

    public boolean deleteDir(String trgPath) {
        return this.pluginLib.deleteDir(trgPath);
    }

    public String downloadTorrent(String url, File outputDir) {
        return this.winPeLibrary.downloadTorrent(url, outputDir);
    }

    public String downloadTorrent(File torrent, File outputDir) {
        return this.winPeLibrary.downloadTorrent(torrent, outputDir);
    }

    public void startAtBoot(String cmd) {
        this.winPeLibrary.appendTextLine(new File(this.targetWinSysFolder, "startboot.cmd"), cmd);
    }

    public void startAtBoot() {
        this.startAtBoot(this.pluginLib.getPluginPeExe().getPath());
    }

    public void startAtLogon(String cmd) {
        this.winPeLibrary.appendTextLine(new File(this.targetWinSysFolder, "startlogon.cmd"), cmd);
    }

    public void startAtLogon() {
        this.startAtLogon(this.pluginLib.getPluginPeExe().getPath());
    }

    public void startAtShell() {
        this.startShell = (HashMap)Core.temp.get("StartShell");
        this.startShell.put(this.pluginLib.getPluginName(), this.pluginLib.getPluginPeExe().getPath());
        Core.temp.put("StartShell", this.startShell);
    }

    public void addPlugin(String plugin) {
        this.winPeLibrary.addPlugin(plugin);
    }

    public void addCache(String plugin) {
        this.winPeLibrary.addCache(plugin);
    }

    public void checkPlugin(String item) {
        String doit = this.projectSettings.read(item, "False");
        if (doit.equalsIgnoreCase("True")) {
            this.winPeLibrary.addPlugin(item);
        }
    }

    public boolean checkSource(String[] validSources) {
        for (String item : validSources) {
            if (!this.coreSource.build.equals(item)) continue;
            return true;
        }
        return false;
    }

    public void addDriverLoad(String infName) {
        this.drivers = (HashMap)Core.temp.get("Drivers");
        this.drivers.put(this.drivers.size(), infName);
        Core.temp.put("Drivers", this.drivers);
        int p = infName.lastIndexOf("\\");
        log.write(500, "Driver %1", infName.substring(p + 1));
    }

    public boolean zipExtractAll(File archiveFile, File destinationFolder) {
        try {
            return this.winPeLibrary.zipExtractAll(archiveFile, destinationFolder);
        }
        catch (ExtractSevenZip.ExtractionException ex) {
            Logger.getLogger(Win7PE.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
        catch (IOException ex) {
            Logger.getLogger(Win7PE.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    public String[] zipExtractInfDir(File archiveFile, String singleDirectory, File destinationFolder) {
        if (archiveFile.exists()) {
            File[] theFiles;
            String sep = this.wbSettings.read("FileSeparator");
            String[] wildCards = new String[]{"*.inf"};
            ArrayList<String> result = new ArrayList<String>();
            utils.files.mkdirs(destinationFolder);
            String theDirectory = singleDirectory.replace("\\", sep);
            try {
                boolean res = this.winPeLibrary.zipExtractDir(archiveFile, theDirectory, destinationFolder);
            }
            catch (ExtractSevenZip.ExtractionException ex) {
                Logger.getLogger(Win7PE.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
            catch (IOException ex) {
                Logger.getLogger(Win7PE.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
            File extractDir = new File(destinationFolder, singleDirectory.replace("\\", sep));
            WildcardFileFilter fileFilter = new WildcardFileFilter(wildCards);
            for (File file : theFiles = extractDir.listFiles(fileFilter)) {
                String name = file.getName();
                if (name.equalsIgnoreCase("nodev.inf")) continue;
                result.add(name.substring(0, name.indexOf(".")));
            }
            String[] strings = new String[result.size()];
            result.toArray(strings);
            return strings;
        }
        return null;
    }

    public String getFetchHive(String hive, boolean isInstall) {
        return this.winPeLibrary.getFetchHive(hive, isInstall);
    }

    public boolean zipExtractFile(File archiveFile, String singleFileName, File destinationFolder) {
        try {
            return this.winPeLibrary.zipExtractFile(archiveFile, singleFileName, destinationFolder);
        }
        catch (ExtractSevenZip.ExtractionException ex) {
            Logger.getLogger(Win7PE.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
        catch (IOException ex) {
            Logger.getLogger(Win7PE.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    public boolean zipExtractFile(File archiveFile, String singleFileName, String password, File destinationFolder) {
        try {
            return this.winPeLibrary.zipExtractFile(archiveFile, singleFileName, password, destinationFolder);
        }
        catch (ExtractSevenZip.ExtractionException ex) {
            Logger.getLogger(Win7PE.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
        catch (IOException ex) {
            Logger.getLogger(Win7PE.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    public void execute(String command) {
        Core.sys.command.execute(command);
    }

    public void snapshoot(String directory) {
        File trgDir = new File(Core.sys.build.folderTarget, directory);
        utils.files.mkdirs(trgDir);
        File peWindows = new File(Core.sys.build.folderPeWIM, "Windows");
        this.hive.closeHives();
        utils.files.copyFolder(peWindows, trgDir);
        this.hive.open(this.winpe);
    }

    public String peDateString(Date date, int format) {
        return this.winPeLibrary.peDateString(date, format);
    }

    public void deleteExtentions(boolean list) {
        RegKey classes = this.hive.softwareHive.readKey("Classes");
        RegKeyList childList = classes.getChildList();
        Vector<RegKey> childs = childList.getSubkeys();
        for (RegKey child : childs) {
            String name = child.getKeyName();
            if (!name.startsWith(".")) continue;
            this.deleteExtention(name, list);
        }
    }

    private void deleteExtention(String key, boolean list) {
        String keyPath = "Classes\\" + key;
        String extPath = "";
        RegKey theKey = this.hive.softwareHive.readKey(keyPath);
        RegVal theStandard = theKey.getVal("");
        if (theStandard != null) {
            extPath = "Classes\\" + theStandard.toString();
        }
        if (list) {
            log.write(30, keyPath);
        } else {
            this.hive.softwareHive.deleteKey(keyPath);
        }
        if (!extPath.equals("")) {
            if (list) {
                log.write(30, extPath);
            } else {
                this.hive.softwareHive.deleteKey(extPath);
            }
        }
    }
}

